/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.activemq.broker.jmx.JobSchedulerViewMBean;
import org.apache.activemq.web.BrokerFacade;
import org.apache.activemq.web.DestinationFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class DeleteJob
extends DestinationFacade
implements Controller {
    private String jobId;
    private static final Logger LOG = LoggerFactory.getLogger(DeleteJob.class);

    public DeleteJob(BrokerFacade brokerFacade) {
        super(brokerFacade);
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.jobId != null) {
            JobSchedulerViewMBean jobScheduler = this.getBrokerFacade().getJobScheduler();
            if (jobScheduler != null) {
                jobScheduler.removeJob(this.jobId);
                LOG.info("Removed scheduled Job " + this.jobId);
            } else {
                LOG.warn("Scheduler not configured");
            }
        }
        return new ModelAndView("redirect:scheduled.jsp");
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String id) {
        this.jobId = id;
    }
}

