/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.ServletContextResource;

public class SpringBrokerContextListener
implements ServletContextListener {
    public static final String INIT_PARAM_BROKER_URI = "brokerURI";
    private BrokerService brokerContainer;

    protected void setBrokerService(BrokerService container) {
        this.brokerContainer = container;
    }

    protected BrokerService getBrokerService() {
        return this.brokerContainer;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.log("Creating ActiveMQ Broker...");
        this.brokerContainer = this.createBroker(context);
        context.log("Starting ActiveMQ Broker");
        try {
            this.brokerContainer.start();
            context.log("Started ActiveMQ Broker");
        }
        catch (Exception e) {
            context.log("Failed to start ActiveMQ broker: " + e, (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        if (this.brokerContainer != null) {
            try {
                this.brokerContainer.stop();
            }
            catch (Exception e) {
                context.log("Failed to stop the ActiveMQ Broker: " + e, (Throwable)e);
            }
            this.brokerContainer = null;
        }
    }

    protected BrokerService createBroker(ServletContext context) {
        String brokerURI = context.getInitParameter(INIT_PARAM_BROKER_URI);
        if (brokerURI == null) {
            brokerURI = "activemq.xml";
        }
        context.log("Loading ActiveMQ Broker configuration from: " + brokerURI);
        ServletContextResource resource = new ServletContextResource(context, brokerURI);
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)resource);
        try {
            factory.afterPropertiesSet();
        }
        catch (Exception e) {
            context.log("Failed to create broker: " + e, (Throwable)e);
        }
        return factory.getBroker();
    }
}

