/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.xml.encryption;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jasypt.encryption.pbe.config.EnvironmentPBEConfig;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.SimplePBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.jasypt.spring31.xml.encryption.AbstractEncryptionBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class EncryptorConfigBeanDefinitionParser
extends AbstractEncryptionBeanDefinitionParser {
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String PARAM_ALGORITHM = "algorithm";
    private static final String PARAM_KEY_OBTENTION_ITERATIONS = "key-obtention-iterations";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_POOL_SIZE = "pool-size";
    private static final String PARAM_PROVIDER_BEAN = "provider-bean";
    private static final String PARAM_PROVIDER_CLASS_NAME = "provider-class-name";
    private static final String PARAM_PROVIDER_NAME = "provider-name";
    private static final String PARAM_SALT_GENERATOR_BEAN = "salt-generator-bean";
    private static final String PARAM_SALT_GENERATOR_CLASS_NAME = "salt-generator-class-name";
    private static final String PARAM_IV_GENERATOR_BEAN = "iv-generator-bean";
    private static final String PARAM_IV_GENERATOR_CLASS_NAME = "iv-generator-class-name";
    private static final Set<String> PARAMS_SIMPLE = new HashSet<String>(Arrays.asList("algorithm", "key-obtention-iterations", "password", "pool-size", "provider-bean", "provider-class-name", "provider-name", "salt-generator-bean", "salt-generator-class-name", "iv-generator-bean", "iv-generator-class-name"));
    private static final String PARAM_STRING_OUTPUT_TYPE = "string-output-type";
    private static final Set<String> PARAMS_STRING = new HashSet<String>(Arrays.asList("string-output-type"));
    private static final String PARAM_ALGORITHM_ENV_NAME = "algorithm-env-name";
    private static final String PARAM_ALGORITHM_SYS_PROPERTY_NAME = "algorithm-sys-property-name";
    private static final String PARAM_KEY_OBTENTION_ITERATIONS_ENV_NAME = "key-obtention-iterations-env-name";
    private static final String PARAM_KEY_OBTENTION_ITERATIONS_SYS_PROPERTY_NAME = "key-obtention-iterations-sys-property-name";
    private static final String PARAM_PASSWORD_ENV_NAME = "password-env-name";
    private static final String PARAM_PASSWORD_SYS_PROPERTY_NAME = "password-sys-property-name";
    private static final String PARAM_POOL_SIZE_ENV_NAME = "pool-size-env-name";
    private static final String PARAM_POOL_SIZE_SYS_PROPERTY_NAME = "pool-size-sys-property-name";
    private static final String PARAM_PROVIDER_CLASS_NAME_ENV_NAME = "provider-class-name-env-name";
    private static final String PARAM_PROVIDER_CLASS_NAME_SYS_PROPERTY_NAME = "provider-class-name-sys-property-name";
    private static final String PARAM_PROVIDER_NAME_ENV_NAME = "provider-name-env-name";
    private static final String PARAM_PROVIDER_NAME_SYS_PROPERTY_NAME = "provider-name-sys-property-name";
    private static final String PARAM_SALT_GENERATOR_CLASS_NAME_ENV_NAME = "salt-generator-class-name-env-name";
    private static final String PARAM_SALT_GENERATOR_CLASS_NAME_SYS_PROPERTY_NAME = "salt-generator-class-name-sys-property-name";
    private static final String PARAM_IV_GENERATOR_CLASS_NAME_ENV_NAME = "iv-generator-class-name-env-name";
    private static final String PARAM_IV_GENERATOR_CLASS_NAME_SYS_PROPERTY_NAME = "iv-generator-class-name-sys-property-name";
    private static final Set<String> PARAMS_ENVIRONMENT = new HashSet<String>(Arrays.asList("algorithm-env-name", "algorithm-sys-property-name", "key-obtention-iterations-env-name", "key-obtention-iterations-sys-property-name", "password-env-name", "password-sys-property-name", "pool-size-env-name", "pool-size-sys-property-name", "provider-class-name-env-name", "provider-class-name-sys-property-name", "provider-name-env-name", "provider-name-sys-property-name", "salt-generator-class-name-env-name", "salt-generator-class-name-sys-property-name", "iv-generator-class-name-env-name", "iv-generator-class-name-sys-property-name"));
    private static final String PARAM_STRING_OUTPUT_TYPE_ENV_NAME = "string-output-type-env-name";
    private static final String PARAM_STRING_OUTPUT_TYPE_SYS_PROPERTY_NAME = "string-output-type-sys-property-name";
    private static final Set<String> PARAMS_STRING_ENVIRONMENT = new HashSet<String>(Arrays.asList("string-output-type-env-name", "string-output-type-sys-property-name"));

    EncryptorConfigBeanDefinitionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return EncryptorConfigBeanDefinitionParser.computeConfigClass(element);
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        this.processStringAttribute(element, builder, PARAM_ALGORITHM, PARAM_ALGORITHM);
        this.processIntegerAttribute(element, builder, PARAM_KEY_OBTENTION_ITERATIONS, "keyObtentionIterations");
        this.processStringAttribute(element, builder, PARAM_PASSWORD, PARAM_PASSWORD);
        this.processIntegerAttribute(element, builder, PARAM_POOL_SIZE, "poolSize");
        this.processBeanAttribute(element, builder, PARAM_PROVIDER_BEAN, "provider");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_CLASS_NAME, "providerClassName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_NAME, "providerName");
        this.processBeanAttribute(element, builder, PARAM_SALT_GENERATOR_BEAN, "saltGenerator");
        this.processStringAttribute(element, builder, PARAM_SALT_GENERATOR_CLASS_NAME, "saltGeneratorClassName");
        this.processBeanAttribute(element, builder, PARAM_IV_GENERATOR_BEAN, "ivGenerator");
        this.processStringAttribute(element, builder, PARAM_IV_GENERATOR_CLASS_NAME, "ivGeneratorClassName");
        this.processStringAttribute(element, builder, PARAM_STRING_OUTPUT_TYPE, "stringOutputType");
        this.processStringAttribute(element, builder, PARAM_ALGORITHM_ENV_NAME, "algorithmEnvName");
        this.processStringAttribute(element, builder, PARAM_KEY_OBTENTION_ITERATIONS_ENV_NAME, "keyObtentionIterationsEnvName");
        this.processStringAttribute(element, builder, PARAM_PASSWORD_ENV_NAME, "passwordEnvName");
        this.processStringAttribute(element, builder, PARAM_POOL_SIZE_ENV_NAME, "poolSizeEnvName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_CLASS_NAME_ENV_NAME, "providerClassNameEnvName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_NAME_ENV_NAME, "providerNameEnvName");
        this.processStringAttribute(element, builder, PARAM_SALT_GENERATOR_CLASS_NAME_ENV_NAME, "saltGeneratorClassNameEnvName");
        this.processStringAttribute(element, builder, PARAM_IV_GENERATOR_CLASS_NAME_ENV_NAME, "ivGeneratorClassNameEnvName");
        this.processStringAttribute(element, builder, PARAM_ALGORITHM_SYS_PROPERTY_NAME, "algorithmSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_KEY_OBTENTION_ITERATIONS_SYS_PROPERTY_NAME, "keyObtentionIterationsSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_PASSWORD_SYS_PROPERTY_NAME, "passwordSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_POOL_SIZE_SYS_PROPERTY_NAME, "poolSizeSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_CLASS_NAME_SYS_PROPERTY_NAME, "providerClassNameSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_PROVIDER_NAME_SYS_PROPERTY_NAME, "providerNameSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_SALT_GENERATOR_CLASS_NAME_SYS_PROPERTY_NAME, "saltGeneratorClassNameSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_IV_GENERATOR_CLASS_NAME_SYS_PROPERTY_NAME, "ivGeneratorClassNameSysPropertyName");
        this.processStringAttribute(element, builder, PARAM_STRING_OUTPUT_TYPE_ENV_NAME, "stringOutputTypeEnvName");
        this.processStringAttribute(element, builder, PARAM_STRING_OUTPUT_TYPE_SYS_PROPERTY_NAME, "stringOutputTypeSysPropertyName");
        String scope = element.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.hasLength((String)scope)) {
            builder.setScope(scope);
        }
    }

    private static Class<?> computeConfigClass(Element element) {
        boolean isSimpleConfig = false;
        boolean isStringConfig = false;
        boolean isEnvironmentConfig = false;
        boolean isStringEnvironmentConfig = false;
        NamedNodeMap attributesMap = element.getAttributes();
        int attributesLen = attributesMap.getLength();
        for (int i = 0; i < attributesLen; ++i) {
            Node attribute = attributesMap.item(i);
            String attributeName = attribute.getNodeName();
            if (!isSimpleConfig && PARAMS_SIMPLE.contains(attributeName)) {
                isSimpleConfig = true;
            }
            if (!isStringConfig && PARAMS_STRING.contains(attributeName)) {
                isStringConfig = true;
            }
            if (!isEnvironmentConfig && PARAMS_ENVIRONMENT.contains(attributeName)) {
                isEnvironmentConfig = true;
            }
            if (isStringEnvironmentConfig || !PARAMS_STRING_ENVIRONMENT.contains(attributeName)) continue;
            isStringEnvironmentConfig = true;
        }
        if (isStringEnvironmentConfig || isEnvironmentConfig && isStringConfig) {
            return EnvironmentStringPBEConfig.class;
        }
        if (isEnvironmentConfig) {
            return EnvironmentPBEConfig.class;
        }
        if (isStringConfig) {
            return SimpleStringPBEConfig.class;
        }
        return SimplePBEConfig.class;
    }
}

