/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.apache.activemq.web.BrokerFacade;
import org.apache.activemq.web.DestinationFacade;
import org.apache.activemq.web.WebClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class QueueBrowseQuery
extends DestinationFacade
implements DisposableBean {
    private String selector;
    private Queue queue;
    private QueueBrowser browser;

    public QueueBrowseQuery(BrokerFacade brokerFacade) throws JMSException {
        super(brokerFacade);
        this.setJMSDestinationType("query");
    }

    public void destroy() throws Exception {
        if (this.browser != null) {
            this.browser.close();
        }
    }

    public QueueBrowser getBrowser() throws JMSException {
        if (this.browser == null) {
            this.browser = this.createBrowser();
        }
        return this.browser;
    }

    public void setBrowser(QueueBrowser browser) {
        this.browser = browser;
    }

    public Queue getQueue() throws JMSException {
        if (this.queue == null) {
            this.queue = this.getSession().createQueue(this.getValidDestination());
        }
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public Session getSession() throws JMSException {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        return WebClient.getWebClient(servletRequestAttributes.getRequest()).getSession();
    }

    @Override
    public boolean isQueue() {
        return true;
    }

    protected QueueBrowser createBrowser() throws JMSException {
        return this.getSession().createBrowser(this.getQueue(), this.getSelector());
    }
}

