/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Experimental;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StartupListener;
import org.apache.camel.impl.DefaultRouteController;
import org.apache.camel.management.event.CamelContextStartedEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.HasId;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.backoff.BackOff;
import org.apache.camel.util.backoff.BackOffTimer;
import org.apache.camel.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class SupervisingRouteController
extends DefaultRouteController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupervisingRouteController.class);
    private final Object lock = new Object();
    private final AtomicBoolean contextStarted = new AtomicBoolean(false);
    private final AtomicInteger routeCount;
    private final List<Filter> filters = new ArrayList<Filter>();
    private final Set<RouteHolder> routes;
    private final CamelContextStartupListener listener;
    private final RouteManager routeManager;
    private BackOffTimer timer;
    private ScheduledExecutorService executorService;
    private BackOff defaultBackOff;
    private Map<String, BackOff> backOffConfigurations;
    private Duration initialDelay;

    public SupervisingRouteController() {
        this.routeCount = new AtomicInteger(0);
        this.routes = new TreeSet<RouteHolder>();
        this.routeManager = new RouteManager();
        this.defaultBackOff = BackOff.builder().build();
        this.backOffConfigurations = new HashMap<String, BackOff>();
        this.initialDelay = Duration.ofMillis(0L);
        try {
            this.listener = new CamelContextStartupListener();
            this.listener.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BackOff getDefaultBackOff() {
        return this.defaultBackOff;
    }

    public void setDefaultBackOff(BackOff defaultBackOff) {
        this.defaultBackOff = defaultBackOff;
    }

    public Map<String, BackOff> getBackOffConfigurations() {
        return this.backOffConfigurations;
    }

    public void setBackOffConfigurations(Map<String, BackOff> backOffConfigurations) {
        this.backOffConfigurations = backOffConfigurations;
    }

    public BackOff getBackOff(String id) {
        return this.backOffConfigurations.getOrDefault(id, this.defaultBackOff);
    }

    public void setBackOff(String id, BackOff backOff) {
        this.backOffConfigurations.put(id, backOff);
    }

    public Duration getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(Duration initialDelay) {
        this.initialDelay = initialDelay;
    }

    public void setInitialDelay(long initialDelay, TimeUnit initialDelayUnit) {
        this.initialDelay = Duration.ofMillis(initialDelayUnit.toMillis(initialDelay));
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = Duration.ofMillis(initialDelay);
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void setFilters(Collection<Filter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
    }

    public Collection<Filter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public Optional<BackOffTimer.Task> getBackOffContext(String id) {
        return this.routeManager.getBackOffContext(id);
    }

    @Override
    protected void doStart() throws Exception {
        CamelContext context = this.getCamelContext();
        context.setAutoStartup(false);
        context.addRoutePolicyFactory(new ManagedRoutePolicyFactory());
        context.addStartupListener(this.listener);
        context.getManagementStrategy().addEventNotifier(this.listener);
        this.executorService = context.getExecutorServiceManager().newSingleThreadScheduledExecutor(this, "SupervisingRouteController");
        this.timer = new BackOffTimer(this.executorService);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.getCamelContext() != null && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdown(this.executorService);
            this.executorService = null;
            this.timer = null;
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.getCamelContext() != null) {
            this.getCamelContext().getManagementStrategy().removeEventNotifier(this.listener);
        }
    }

    @Override
    public void startRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.startRoute(routeId);
        } else {
            this.doStartRoute(route.get(), true, r -> super.startRoute(routeId));
        }
    }

    @Override
    public void stopRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.stopRoute(routeId);
        } else {
            this.doStopRoute(route.get(), true, r -> super.stopRoute(routeId));
        }
    }

    @Override
    public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.stopRoute(routeId, timeout, timeUnit);
        } else {
            this.doStopRoute(route.get(), true, r -> super.stopRoute(r.getId(), timeout, timeUnit));
        }
    }

    @Override
    public boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            return super.stopRoute(routeId, timeout, timeUnit, abortAfterTimeout);
        }
        AtomicBoolean result = new AtomicBoolean(false);
        this.doStopRoute(route.get(), true, r -> result.set(super.stopRoute(r.getId(), timeout, timeUnit, abortAfterTimeout)));
        return result.get();
    }

    @Override
    public void suspendRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.suspendRoute(routeId);
        } else {
            this.doStopRoute(route.get(), true, r -> super.suspendRoute(r.getId()));
        }
    }

    @Override
    public void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.suspendRoute(routeId, timeout, timeUnit);
        } else {
            this.doStopRoute(route.get(), true, r -> super.suspendRoute(r.getId(), timeout, timeUnit));
        }
    }

    @Override
    public void resumeRoute(String routeId) throws Exception {
        Optional<RouteHolder> route = this.routes.stream().filter(r -> r.getId().equals(routeId)).findFirst();
        if (!route.isPresent()) {
            super.resumeRoute(routeId);
        } else {
            this.doStartRoute(route.get(), true, r -> super.startRoute(routeId));
        }
    }

    @Override
    public Collection<Route> getControlledRoutes() {
        return this.routes.stream().map(RouteHolder::get).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStopRoute(RouteHolder route, boolean checker, ThrowingConsumer<RouteHolder, Exception> consumer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (checker) {
                this.routeManager.release(route);
            }
            LOGGER.info("Route {} has been requested to stop: stop supervising it", (Object)route.getId());
            route.getContext().setRouteController(null);
            consumer.accept(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartRoute(RouteHolder route, boolean checker, ThrowingConsumer<RouteHolder, Exception> consumer) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            route.getContext().setRouteController(this);
            try {
                if (checker) {
                    this.routeManager.release(route);
                }
                consumer.accept(route);
            }
            catch (Exception e) {
                if (checker) {
                    this.routeManager.start(route);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRoutes() {
        List routeList;
        if (!this.isRunAllowed()) {
            return;
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            routeList = this.routes.stream().filter(r -> r.getStatus() == ServiceStatus.Stopped).map(RouteHolder::getId).collect(Collectors.toList());
        }
        for (String route : routeList) {
            try {
                this.startRoute(route);
            }
            catch (Exception exception) {}
        }
        LOGGER.info("Total managed routes: {} of which {} successfully started and {} re-starting", this.routes.size(), this.routes.stream().filter(r -> r.getStatus() == ServiceStatus.Started).count(), this.routeManager.routes.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stopRoutes() {
        List routeList;
        if (!this.isRunAllowed()) {
            return;
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            routeList = this.routes.stream().filter(r -> r.getStatus() == ServiceStatus.Started).map(RouteHolder::getId).collect(Collectors.toList());
        }
        for (String route : routeList) {
            try {
                this.stopRoute(route);
            }
            catch (Exception exception) {}
        }
    }

    @Experimental
    public static interface Filter
    extends Function<Route, FilterResult> {
    }

    @Experimental
    public static class FilterResult {
        public static final FilterResult SUPERVISED = new FilterResult(true, null);
        private final boolean controlled;
        private final String reason;

        public FilterResult(boolean controlled, String reason) {
            this.controlled = controlled;
            this.reason = reason;
        }

        public FilterResult(boolean controlled, String format2, Object ... args) {
            this(controlled, String.format(format2, args));
        }

        public boolean supervised() {
            return this.controlled;
        }

        public String reason() {
            return this.reason;
        }
    }

    private class CamelContextStartupListener
    extends EventNotifierSupport
    implements StartupListener {
        private CamelContextStartupListener() {
        }

        @Override
        public void notify(EventObject event) throws Exception {
            this.onCamelContextStarted();
        }

        @Override
        public boolean isEnabled(EventObject event) {
            return event instanceof CamelContextStartedEvent;
        }

        @Override
        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            if (alreadyStarted) {
                this.onCamelContextStarted();
            }
        }

        private void onCamelContextStarted() {
            if (SupervisingRouteController.this.contextStarted.compareAndSet(false, true)) {
                if (SupervisingRouteController.this.initialDelay.toMillis() > 0L) {
                    LOGGER.debug("Routes will be started in {}", (Object)SupervisingRouteController.this.initialDelay);
                    SupervisingRouteController.this.executorService.schedule(() -> SupervisingRouteController.this.startRoutes(), SupervisingRouteController.this.initialDelay.toMillis(), TimeUnit.MILLISECONDS);
                } else {
                    SupervisingRouteController.this.startRoutes();
                }
            }
        }
    }

    private class ManagedRoutePolicy
    implements RoutePolicy {
        private ManagedRoutePolicy() {
        }

        private void startRoute(RouteHolder holder) {
            try {
                SupervisingRouteController.this.doStartRoute(holder, true, r -> SupervisingRouteController.super.startRoute(r.getId()));
            }
            catch (Exception e) {
                throw new RuntimeCamelException(e);
            }
        }

        @Override
        public void onInit(Route route) {
            String autoStartup = route.getRouteContext().getRoute().getAutoStartup();
            if (ObjectHelper.equalIgnoreCase("false", autoStartup)) {
                LOGGER.info("Route {} won't be supervised (reason: has explicit auto-startup flag set to false)", (Object)route.getId());
                return;
            }
            for (Filter filter : SupervisingRouteController.this.filters) {
                FilterResult result = (FilterResult)filter.apply(route);
                if (result.supervised()) continue;
                LOGGER.info("Route {} won't be supervised (reason: {})", (Object)route.getId(), (Object)result.reason());
                return;
            }
            RouteHolder holder = new RouteHolder(route, SupervisingRouteController.this.routeCount.incrementAndGet());
            if (SupervisingRouteController.this.routes.add(holder)) {
                holder.getContext().setRouteController(SupervisingRouteController.this);
                holder.getDefinition().setAutoStartup("false");
                if (SupervisingRouteController.this.contextStarted.get()) {
                    LOGGER.info("Context is already started: attempt to start route {}", (Object)route.getId());
                    if (SupervisingRouteController.this.initialDelay.toMillis() > 0L) {
                        LOGGER.debug("Route {} will be started in {}", (Object)holder.getId(), (Object)SupervisingRouteController.this.initialDelay);
                        SupervisingRouteController.this.executorService.schedule(() -> this.startRoute(holder), SupervisingRouteController.this.initialDelay.toMillis(), TimeUnit.MILLISECONDS);
                    } else {
                        this.startRoute(holder);
                    }
                } else {
                    LOGGER.info("Context is not yet started: defer route {} start", (Object)holder.getId());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemove(Route route) {
            Object object = SupervisingRouteController.this.lock;
            synchronized (object) {
                SupervisingRouteController.this.routes.removeIf(r -> ObjectHelper.equal(r.get(), route) || ObjectHelper.equal(r.getId(), route.getId()));
            }
        }

        @Override
        public void onStart(Route route) {
        }

        @Override
        public void onStop(Route route) {
        }

        @Override
        public void onSuspend(Route route) {
        }

        @Override
        public void onResume(Route route) {
        }

        @Override
        public void onExchangeBegin(Route route, Exchange exchange) {
        }

        @Override
        public void onExchangeDone(Route route, Exchange exchange) {
        }
    }

    private class ManagedRoutePolicyFactory
    implements RoutePolicyFactory {
        private final RoutePolicy policy;

        private ManagedRoutePolicyFactory() {
            this.policy = new ManagedRoutePolicy();
        }

        @Override
        public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, RouteDefinition route) {
            return this.policy;
        }
    }

    private class RouteHolder
    implements HasId,
    Comparable<RouteHolder> {
        private final int order;
        private final Route route;

        RouteHolder(Route route, int order) {
            this.route = route;
            this.order = order;
        }

        @Override
        public String getId() {
            return this.route.getId();
        }

        public Route get() {
            return this.route;
        }

        public RouteContext getContext() {
            return this.route.getRouteContext();
        }

        public RouteDefinition getDefinition() {
            return this.route.getRouteContext().getRoute();
        }

        public ServiceStatus getStatus() {
            return this.getContext().getCamelContext().getRouteStatus(this.getId());
        }

        public int getInitializationOrder() {
            return this.order;
        }

        public int getStartupOrder() {
            Integer order = this.getDefinition().getStartupOrder();
            if (order == null) {
                order = Integer.MAX_VALUE;
            }
            return order;
        }

        @Override
        public int compareTo(RouteHolder o) {
            int answer = Integer.compare(this.getStartupOrder(), o.getStartupOrder());
            if (answer == 0) {
                answer = Integer.compare(this.getInitializationOrder(), o.getInitializationOrder());
            }
            return answer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.route.equals(((RouteHolder)o).route);
        }

        public int hashCode() {
            return this.route.hashCode();
        }
    }

    private class RouteManager {
        private final Logger logger = LoggerFactory.getLogger(RouteManager.class);
        private final ConcurrentMap<RouteHolder, BackOffTimer.Task> routes = new ConcurrentHashMap<RouteHolder, BackOffTimer.Task>();

        RouteManager() {
        }

        void start(RouteHolder route) {
            route.getContext().setRouteController(SupervisingRouteController.this);
            this.routes.computeIfAbsent(route, r -> {
                BackOff backOff = SupervisingRouteController.this.getBackOff(r.getId());
                this.logger.info("Start supervising route: {} with back-off: {}", (Object)r.getId(), (Object)backOff);
                BackOffTimer.Task task = SupervisingRouteController.this.timer.schedule(backOff, context -> {
                    try {
                        this.logger.info("Try to restart route: {}", (Object)r.getId());
                        SupervisingRouteController.this.doStartRoute(r, false, rx -> SupervisingRouteController.super.startRoute(rx.getId()));
                        return false;
                    }
                    catch (Exception e) {
                        return true;
                    }
                });
                task.whenComplete((backOffTask, throwable) -> {
                    if (backOffTask == null || backOffTask.getStatus() != BackOffTimer.Task.Status.Active) {
                        Object object = SupervisingRouteController.this.lock;
                        synchronized (object) {
                            boolean stopped;
                            ServiceStatus status2 = route.getStatus();
                            boolean bl = stopped = status2.isStopped() || status2.isStopping();
                            if (backOffTask != null && backOffTask.getStatus() == BackOffTimer.Task.Status.Exhausted && stopped) {
                                LOGGER.info("Back-off for route {} is exhausted, no more attempts will be made and stop supervising it", (Object)route.getId());
                                r.getContext().setRouteController(null);
                            }
                        }
                    }
                    this.routes.remove(r);
                });
                return task;
            });
        }

        boolean release(RouteHolder route) {
            BackOffTimer.Task task = (BackOffTimer.Task)this.routes.remove(route);
            if (task != null) {
                LOGGER.info("Cancel restart task for route {}", (Object)route.getId());
                task.cancel();
            }
            return task != null;
        }

        void clear() {
            this.routes.values().forEach(BackOffTimer.Task::cancel);
            this.routes.clear();
        }

        public Optional<BackOffTimer.Task> getBackOffContext(String id) {
            return this.routes.entrySet().stream().filter(e -> ObjectHelper.equal(((RouteHolder)e.getKey()).getId(), id)).findFirst().map(Map.Entry::getValue);
        }
    }
}

