/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.spel;

import org.apache.camel.Exchange;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.impl.ExpressionSupport;
import org.apache.camel.language.spel.RootObject;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.RegistryBeanResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpelExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;
    private final BeanResolver beanResolver;
    private final SpelExpressionParser expressionParser;

    public SpelExpression(String expressionString, Class<?> type) {
        this(expressionString, type, null);
    }

    public SpelExpression(String expressionString, Class<?> type, BeanResolver beanResolver) {
        this.expressionString = expressionString;
        this.type = type;
        this.beanResolver = beanResolver;
        this.expressionParser = new SpelExpressionParser();
    }

    public static SpelExpression spel(String expression) {
        return new SpelExpression(expression, Object.class);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> tClass) {
        try {
            Expression expression = this.parseExpression();
            EvaluationContext evaluationContext = this.createEvaluationContext(exchange);
            Object value = expression.getValue(evaluationContext);
            return exchange.getContext().getTypeConverter().convertTo(tClass, value);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(this, exchange, e);
        }
    }

    private EvaluationContext createEvaluationContext(Exchange exchange) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(new RootObject(exchange));
        evaluationContext.addPropertyAccessor(new MapAccessor());
        if (this.beanResolver != null) {
            evaluationContext.setBeanResolver(this.beanResolver);
        } else if (exchange.getContext() instanceof SpringCamelContext) {
            ApplicationContext applicationContext = ((SpringCamelContext)exchange.getContext()).getApplicationContext();
            evaluationContext.setBeanResolver(new BeanFactoryResolver(applicationContext));
        } else {
            evaluationContext.setBeanResolver(new RegistryBeanResolver(exchange.getContext().getRegistry()));
        }
        return evaluationContext;
    }

    private Expression parseExpression() {
        TemplateParserContext parserContext = new TemplateParserContext();
        Expression expression = this.expressionParser.parseExpression(this.expressionString, parserContext);
        return expression;
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }

    public String toString() {
        return "SpelExpression[" + this.expressionString + "]";
    }
}

