/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.table;

import com.google.common.base.Preconditions;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;

public class BlockTrailer {
    public static final int ENCODED_LENGTH = 5;
    private final CompressionType compressionType;
    private final int crc32c;

    public BlockTrailer(CompressionType compressionType, int crc32c) {
        Preconditions.checkNotNull((Object)compressionType, (Object)"compressionType is null");
        this.compressionType = compressionType;
        this.crc32c = crc32c;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public int getCrc32c() {
        return this.crc32c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockTrailer that = (BlockTrailer)o;
        if (this.crc32c != that.crc32c) {
            return false;
        }
        return this.compressionType == that.compressionType;
    }

    public int hashCode() {
        int result = this.compressionType.hashCode();
        result = 31 * result + this.crc32c;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BlockTrailer");
        sb.append("{compressionType=").append(this.compressionType);
        sb.append(", crc32c=0x").append(Integer.toHexString(this.crc32c));
        sb.append('}');
        return sb.toString();
    }

    public static BlockTrailer readBlockTrailer(Slice slice) {
        SliceInput sliceInput = slice.input();
        CompressionType compressionType = CompressionType.getCompressionTypeByPersistentId((int)sliceInput.readUnsignedByte());
        int crc32c = sliceInput.readInt();
        return new BlockTrailer(compressionType, crc32c);
    }

    public static Slice writeBlockTrailer(BlockTrailer blockTrailer) {
        Slice slice = Slices.allocate(5);
        BlockTrailer.writeBlockTrailer(blockTrailer, slice.output());
        return slice;
    }

    public static void writeBlockTrailer(BlockTrailer blockTrailer, SliceOutput sliceOutput) {
        sliceOutput.writeByte(blockTrailer.getCompressionType().persistentId());
        sliceOutput.writeInt(blockTrailer.getCrc32c());
    }
}

