/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions;

import com.gentlyweb.utils.Getter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.expressions.Expression;
import org.josql.functions.AbstractFunctionHandler;
import org.josql.internal.Utilities;

public class GroupingFunctions
extends AbstractFunctionHandler {
    public static final String VALUE = "value";
    public static final String HANDLER_ID = "_internal_grouping";

    public Object least(List allobjs, Expression exp, String saveValueName) throws QueryExecutionException {
        Object o;
        if (saveValueName != null && (o = this.q.getSaveValue(saveValueName)) != null) {
            return o;
        }
        if (allobjs.size() == 0) {
            return null;
        }
        Object g = null;
        int s = allobjs.size();
        for (int i = 0; i < s; ++i) {
            Object o2 = allobjs.get(i);
            Object v = null;
            try {
                v = exp.getValue(o2, this.q);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from expression: " + exp + " for maximum value" + e);
            }
            if (g == null) {
                g = v;
                continue;
            }
            int c = Utilities.compare(v, g);
            if (c >= 0) continue;
            g = v;
        }
        if (saveValueName != null && this.q != null) {
            this.q.setSaveValue(saveValueName, g);
        }
        return g;
    }

    public Object minObject(Expression exp) throws QueryExecutionException {
        return this.minObject((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public Object minObject(List allobjs, Expression exp) throws QueryExecutionException {
        return this.leastObject(allobjs, exp);
    }

    public Object leastObject(List allobjs, Expression exp) throws QueryExecutionException {
        if (allobjs.size() == 0) {
            return null;
        }
        Object l = null;
        Object lo = null;
        int s = allobjs.size();
        for (int i = 0; i < s; ++i) {
            Object o = allobjs.get(i);
            Object v = null;
            try {
                v = exp.getValue(o, this.q);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from expression: " + exp + " for maximum value" + e);
            }
            if (l == null) {
                l = v;
                lo = o;
                continue;
            }
            int c = Utilities.compare(v, l);
            if (c >= 0) continue;
            l = v;
            lo = o;
        }
        return lo;
    }

    public Object maxObject(List allobjs, Expression exp) throws QueryExecutionException {
        return this.greatestObject(allobjs, exp);
    }

    public Object maxObject(Expression exp) throws QueryExecutionException {
        return this.maxObject((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public Object greatestObject(List allobjs, Expression exp) throws QueryExecutionException {
        if (allobjs.size() == 0) {
            return null;
        }
        Object g = null;
        Object go = null;
        int s = allobjs.size();
        for (int i = 0; i < s; ++i) {
            Object o = allobjs.get(i);
            Object v = null;
            try {
                v = exp.getValue(o, this.q);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from expression: " + exp + " for maximum value" + e);
            }
            if (g == null) {
                g = v;
                go = o;
                continue;
            }
            int c = Utilities.compare(v, g);
            if (c <= 0) continue;
            g = v;
            go = o;
        }
        return go;
    }

    public Object least(List allobjs, Expression exp) throws QueryExecutionException {
        return this.least(allobjs, exp, null);
    }

    public Object min(Expression exp) throws QueryExecutionException {
        return this.min((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public Object min(List allobjs, Expression exp) throws QueryExecutionException {
        return this.least(allobjs, exp, null);
    }

    public Object min(List allobjs, Expression exp, String saveValueName) throws QueryExecutionException {
        return this.least(allobjs, exp, saveValueName);
    }

    public Map.Entry maxEntry(Map m, String type) {
        boolean t = false;
        if (type.equals(VALUE)) {
            t = true;
        }
        Map.Entry r = null;
        Map.Entry le = null;
        Iterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            r = iter.next();
            if (le != null) {
                if (!t) {
                    if (!Utilities.isGTEquals(r.getKey(), le.getKey())) continue;
                    le = r;
                    continue;
                }
                if (!Utilities.isGTEquals(r.getValue(), le.getValue())) continue;
                le = r;
                continue;
            }
            le = r;
        }
        return le;
    }

    public Map.Entry minEntry(Object m, String type) throws QueryExecutionException {
        if (!(m instanceof Map)) {
            throw new QueryExecutionException("Only instances of: " + Map.class.getName() + " are supported, passed: " + m.getClass().getName());
        }
        return this.minEntry((Map)m, type);
    }

    public Map.Entry minEntry(Map m, String type) {
        boolean t = false;
        if (type.equals(VALUE)) {
            t = true;
        }
        Map.Entry r = null;
        Map.Entry le = null;
        Iterator iter = m.entrySet().iterator();
        while (iter.hasNext()) {
            r = iter.next();
            if (le != null) {
                if (!t) {
                    if (!Utilities.isLTEquals(r.getKey(), le.getKey())) continue;
                    le = r;
                    continue;
                }
                if (!Utilities.isLTEquals(r.getValue(), le.getValue())) continue;
                le = r;
                continue;
            }
            le = r;
        }
        return le;
    }

    public Object max(List allobjs, Expression exp, String saveValueName) throws QueryExecutionException {
        return this.greatest(allobjs, exp, saveValueName);
    }

    public Object greatest(List allobjs, Expression exp, String saveValueName) throws QueryExecutionException {
        Object o;
        if (saveValueName != null && (o = this.q.getSaveValue(saveValueName)) != null) {
            return (Double)o;
        }
        if (allobjs.size() == 0) {
            return null;
        }
        Object g = null;
        int s = allobjs.size();
        for (int i = 0; i < s; ++i) {
            Object o2 = allobjs.get(i);
            Object v = null;
            try {
                v = exp.getValue(o2, this.q);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from expression: " + exp + " for maximum value" + e);
            }
            if (g == null) {
                g = v;
                continue;
            }
            int c = Utilities.compare(v, g);
            if (c <= 0) continue;
            g = v;
        }
        if (saveValueName != null) {
            this.q.setSaveValue(saveValueName, g);
        }
        return g;
    }

    public Object greatest(List allobjs, Expression exp) throws QueryExecutionException {
        return this.greatest(allobjs, exp, null);
    }

    public Object max(Expression exp) throws QueryExecutionException {
        return this.max((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public Object max(List allobjs, Expression exp) throws QueryExecutionException {
        return this.greatest(allobjs, exp, null);
    }

    private double getTotal(List allobjs, Expression exp) throws QueryExecutionException {
        Object currObj = this.q.getCurrentObject();
        double total = 0.0;
        int size = allobjs.size();
        for (int i = 0; i < size; ++i) {
            Object o = allobjs.get(i);
            this.q.setCurrentObject(o);
            Number n = null;
            try {
                n = (Number)exp.getValue(o, this.q);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from expression: " + exp + " for item: " + i + " from the list of objects.", e);
            }
            total += n.doubleValue();
        }
        this.q.setCurrentObject(currObj);
        return total;
    }

    public void checkType(Object o, Class expected, Expression exp) throws QueryExecutionException {
        if (!expected.isInstance(o)) {
            throw new QueryExecutionException("Expression: " + exp + " returns type: " + o.getClass().getName() + " however must return instance of: " + expected.getName());
        }
    }

    public Double sum(List allobjs, Expression exp, String saveValueName) throws QueryExecutionException {
        Object o;
        if (saveValueName != null && (o = this.q.getSaveValue(saveValueName)) != null) {
            return (Double)o;
        }
        if (allobjs == null || allobjs.size() == 0) {
            return new Double(0.0);
        }
        double total = this.getTotal(allobjs, exp);
        Double d = new Double(total);
        if (saveValueName != null && this.q != null) {
            this.q.setSaveValue(saveValueName, d);
        }
        return d;
    }

    public Double sum(Expression exp) throws QueryExecutionException {
        return this.sum((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public Double sum(List objs, Expression exp) throws QueryExecutionException {
        Class c = null;
        try {
            c = exp.getExpectedReturnType(this.q);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to determine expected return type for expression: " + exp, e);
        }
        boolean dyn = false;
        if (!c.getName().equals(Object.class.getName())) {
            if (!Utilities.isNumber(c)) {
                throw new QueryExecutionException("This function expects the expression: " + exp + " to return a number (sub-class of: " + Number.class.getName() + ") but evaluation of the expression will return an instance of: " + c.getName());
            }
        } else {
            dyn = true;
        }
        Object co = this.q.getCurrentObject();
        int s = objs.size() - 1;
        double d = 0.0;
        for (int i = s; i > -1; --i) {
            Object o = objs.get(i);
            this.q.setCurrentObject(o);
            Object v = null;
            try {
                v = exp.getValue(o, this.q);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to evaluate expression: " + exp + " on item: " + i, e);
            }
            if (v == null) continue;
            if (dyn && !Utilities.isNumber(v)) {
                throw new QueryExecutionException("Expected expression: " + exp + " to return a number (sub-class of: " + Number.class.getName() + ") but returns instance of: " + o.getClass().getName() + " for item: " + i + " (class: " + v.getClass().getName() + ")");
            }
            d += ((Number)v).doubleValue();
        }
        this.q.setCurrentObject(co);
        return new Double(d);
    }

    public Double sum(List objs, String acc) throws QueryExecutionException {
        if (objs == null || objs.size() == 0) {
            return new Double(0.0);
        }
        Object o = objs.get(0);
        Getter get = null;
        try {
            get = new Getter(acc, o.getClass());
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to create accessor for: " + acc + " with class: " + o.getClass().getName(), e);
        }
        if (!get.getType().getName().equals(Object.class.getName()) && !Utilities.isNumber(get.getType())) {
            throw new QueryExecutionException("This function expects the accessor (second parm): " + acc + " to return a number (sub-class of: " + Number.class.getName() + ") but evaluation of the accessor will return an instance of: " + get.getType().getName());
        }
        int s = objs.size() - 1;
        double d = 0.0;
        for (int i = s; i > -1; --i) {
            o = objs.get(i);
            Object v = null;
            try {
                v = get.getValue(o);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to evaluate accessor: " + acc + " on item: " + i, e);
            }
            if (v == null) continue;
            d += ((Number)v).doubleValue();
        }
        return new Double(d);
    }

    public String concat(List allobjs, Expression exp, String sep, String saveValueName) throws QueryExecutionException {
        Object o;
        if (saveValueName != null && (o = this.q.getSaveValue(saveValueName)) != null) {
            return (String)o;
        }
        StringBuffer buf = new StringBuffer();
        int size = allobjs.size();
        int size1 = size - 1;
        for (int i = 0; i < size; ++i) {
            Object o2 = allobjs.get(i);
            Object v = null;
            try {
                v = exp.getValue(o2, this.q);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from expression: " + exp + " for item: " + i + " from the list of objects.", e);
            }
            buf.append(v);
            if (sep == null || i >= size1) continue;
            buf.append(sep);
        }
        String r = buf.toString();
        if (saveValueName != null && this.q != null) {
            this.q.setSaveValue(saveValueName, r);
        }
        return r;
    }

    public String concat(List allobjs, Expression exp, String sep) throws QueryExecutionException {
        return this.concat(allobjs, exp, sep, null);
    }

    public String concat(Expression exp) throws QueryExecutionException {
        return this.concat((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public String concat(List allobjs, Expression exp) throws QueryExecutionException {
        return this.concat(allobjs, exp, null, null);
    }

    public Double avg(List allobjs, Expression exp, String saveValueName) throws QueryExecutionException {
        Object o;
        if (saveValueName != null && (o = this.q.getSaveValue(saveValueName)) != null) {
            return (Double)o;
        }
        if (allobjs == null || allobjs.size() == 0) {
            return new Double(0.0);
        }
        double total = this.getTotal(allobjs, exp);
        double avg = total / (double)allobjs.size();
        Double d = new Double(avg);
        if (saveValueName != null) {
            this.q.setSaveValue(saveValueName, d);
        }
        return d;
    }

    public Double avg(Expression exp) throws QueryExecutionException {
        return this.avg((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public Double avg(List allobjs, Expression exp) throws QueryExecutionException {
        return this.avg(allobjs, exp, null);
    }

    public Map occurrence(List objs) throws QueryExecutionException {
        return this.occurrence(objs, null);
    }

    public Map occurrence(List objs, Expression exp) throws QueryExecutionException {
        HashMap occs = new HashMap();
        if (objs == null) {
            return occs;
        }
        int s = objs.size();
        for (int i = 0; i < s; ++i) {
            Object o = objs.get(i);
            if (exp != null) {
                try {
                    o = exp.getValue(o, this.q);
                }
                catch (Exception e) {
                    throw new QueryExecutionException("Unable to get value for expression: " + exp + " for object: " + i + " from the list of objects.", e);
                }
            }
            Integer c = (Integer)occs.get(o);
            int co = 1;
            if (c != null) {
                co = c;
                ++co;
            }
            occs.put(o, new Integer(co));
        }
        return occs;
    }

    public Map occurrence(List objs, Expression exp, Expression limitExp) throws QueryExecutionException {
        Map rs = this.occurrence(objs, exp);
        Object o = limitExp.getValue(this.q.getCurrentObject(), this.q);
        if (!(o instanceof Number)) {
            throw new QueryExecutionException("Limit expression: " + limitExp + " does not evaluate to a number");
        }
        int i = ((Number)o).intValue();
        HashMap ret = new HashMap();
        Iterator iter = rs.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            Integer c = (Integer)rs.get(k);
            if (c < i) continue;
            ret.put(k, c);
        }
        return ret;
    }
}

