/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.net.URI;
import org.apache.activemq.transport.TransportThreadSupport;
import org.apache.activemq.transport.util.TextWireFormat;

public abstract class HttpTransportSupport
extends TransportThreadSupport {
    private static final int DEFAULT_PROXY_PORT = 8080;
    private static final String PROPERTY_PROXY_HOST = "proxyHost";
    private static final String PROPERTY_NON_PROXY_HOST = "nonProxyHosts";
    private static final String PROPERTY_PROXY_PORT = "proxyPort";
    private static final String PROPERTY_PROXY_USER = "proxyUser";
    private static final String PROPERTY_PROXY_PASSWORD = "proxyPassword";
    private TextWireFormat textWireFormat;
    private URI remoteUrl;
    private String proxyHost;
    private String nonProxyHosts;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;

    public HttpTransportSupport(TextWireFormat textWireFormat, URI remoteUrl) {
        this.textWireFormat = textWireFormat;
        this.remoteUrl = remoteUrl;
    }

    public String toString() {
        return "HTTP Reader " + this.getRemoteUrl();
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteUrl.toString();
    }

    public URI getRemoteUrl() {
        return this.remoteUrl;
    }

    public TextWireFormat getTextWireFormat() {
        return this.textWireFormat;
    }

    public void setTextWireFormat(TextWireFormat textWireFormat) {
        this.textWireFormat = textWireFormat;
    }

    public String getProxyHost() {
        return this.proxyHost != null ? this.proxyHost : this.getSystemProperty(PROPERTY_PROXY_HOST);
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts != null ? this.nonProxyHosts : this.getSystemProperty(PROPERTY_NON_PROXY_HOST);
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public int getProxyPort() {
        return this.proxyPort != null ? this.proxyPort : (this.getSystemProperty(PROPERTY_PROXY_PORT) != null ? Integer.parseInt(this.getSystemProperty(PROPERTY_PROXY_PORT)) : 8080);
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser != null ? this.proxyUser : this.getSystemProperty(PROPERTY_PROXY_USER);
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword != null ? this.proxyPassword : this.getSystemProperty(PROPERTY_PROXY_PASSWORD);
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    protected abstract String getSystemPropertyPrefix();

    private String getSystemProperty(String propertyName) {
        return System.getProperty(this.getSystemPropertyPrefix() + propertyName);
    }
}

