/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.request.JmxRequest;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ServerHandle {
    private String product;
    private String version;
    private Map<String, String> extraInfo;
    private String vendor;

    public ServerHandle(String vendor, String product, String version, Map<String, String> extraInfo) {
        this.product = product;
        this.version = version;
        this.extraInfo = extraInfo;
        this.vendor = vendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getExtraInfo(MBeanServerExecutor pServerManager) {
        return this.extraInfo;
    }

    public void preDispatch(MBeanServerExecutor pMBeanServerExecutor, JmxRequest pJmxReq) {
    }

    public void postDetect(MBeanServerExecutor pServerManager, Configuration pConfig, LogHandler pLoghandler) {
    }

    public ObjectName registerMBeanAtServer(MBeanServer pServer, Object pMBean, String pName) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException, MalformedObjectNameException {
        if (pName != null) {
            ObjectName oName = new ObjectName(pName);
            return pServer.registerMBean(pMBean, oName).getObjectName();
        }
        return pServer.registerMBean(pMBean, null).getObjectName();
    }

    public JSONObject toJSONObject(MBeanServerExecutor pServerManager) {
        JSONObject ret = new JSONObject();
        this.addNullSafe(ret, "vendor", this.vendor);
        this.addNullSafe(ret, "product", this.product);
        this.addNullSafe(ret, "version", this.version);
        Map<String, String> extra = this.getExtraInfo(pServerManager);
        if (extra != null) {
            JSONObject jsonExtra = new JSONObject();
            for (Map.Entry<String, String> entry : extra.entrySet()) {
                jsonExtra.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            ret.put((Object)"extraInfo", (Object)jsonExtra);
        }
        return ret;
    }

    private void addNullSafe(JSONObject pRet, String pKey, Object pValue) {
        if (pValue != null) {
            pRet.put((Object)pKey, pValue);
        }
    }

    protected JSONObject getDetectorOptions(Configuration pConfig, LogHandler pLogHandler) {
        String options = pConfig.get(ConfigKey.DETECTOR_OPTIONS);
        try {
            if (options != null) {
                JSONObject opts = (JSONObject)new JSONParser().parse(options);
                return (JSONObject)opts.get((Object)this.getProduct());
            }
            return null;
        }
        catch (ParseException e) {
            pLogHandler.error("Could not parse detector options '" + options + "' as JSON object: " + (Object)((Object)e), e);
            return null;
        }
    }
}

