/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;

public class WeblogicDetector
extends AbstractServerDetector {
    @Override
    public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
        String domainConfigMBean = this.getSingleStringAttribute(pMBeanServerExecutor, "*:Name=RuntimeService,*", "DomainConfiguration");
        if (domainConfigMBean != null) {
            String version = this.getSingleStringAttribute(pMBeanServerExecutor, domainConfigMBean, "ConfigurationVersion");
            return new ServerHandle("Oracle", "weblogic", version, null);
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServerConnection> servers) {
        if (!this.isJBoss()) {
            try {
                InitialContext ctx = new InitialContext();
                MBeanServer server = (MBeanServer)ctx.lookup("java:comp/env/jmx/runtime");
                if (server != null) {
                    servers.add(server);
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private boolean isJBoss() {
        try {
            return Class.forName("org.jboss.mx.util.MBeanServerLocator") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

