/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import org.springframework.lang.Nullable;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.support.AbstractTransactionStatus;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.util.Assert;

public class DefaultTransactionStatus
extends AbstractTransactionStatus {
    @Nullable
    private final String transactionName;
    @Nullable
    private final Object transaction;
    private final boolean newTransaction;
    private final boolean newSynchronization;
    private final boolean nested;
    private final boolean readOnly;
    private final boolean debug;
    @Nullable
    private final Object suspendedResources;

    public DefaultTransactionStatus(@Nullable String transactionName, @Nullable Object transaction, boolean newTransaction, boolean newSynchronization, boolean nested, boolean readOnly, boolean debug, @Nullable Object suspendedResources) {
        this.transactionName = transactionName;
        this.transaction = transaction;
        this.newTransaction = newTransaction;
        this.newSynchronization = newSynchronization;
        this.nested = nested;
        this.readOnly = readOnly;
        this.debug = debug;
        this.suspendedResources = suspendedResources;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public DefaultTransactionStatus(@Nullable Object transaction, boolean newTransaction, boolean newSynchronization, boolean readOnly, boolean debug, @Nullable Object suspendedResources) {
        this(null, transaction, newTransaction, newSynchronization, false, readOnly, debug, suspendedResources);
    }

    @Override
    public String getTransactionName() {
        return this.transactionName != null ? this.transactionName : "";
    }

    public Object getTransaction() {
        Assert.state(this.transaction != null, "No transaction active");
        return this.transaction;
    }

    @Override
    public boolean hasTransaction() {
        return this.transaction != null;
    }

    @Override
    public boolean isNewTransaction() {
        return this.hasTransaction() && this.newTransaction;
    }

    public boolean isNewSynchronization() {
        return this.newSynchronization;
    }

    @Override
    public boolean isNested() {
        return this.nested;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    @Nullable
    public Object getSuspendedResources() {
        return this.suspendedResources;
    }

    @Override
    public boolean isGlobalRollbackOnly() {
        SmartTransactionObject smartTransactionObject;
        Object object = this.transaction;
        return object instanceof SmartTransactionObject && (smartTransactionObject = (SmartTransactionObject)object).isRollbackOnly();
    }

    @Override
    protected SavepointManager getSavepointManager() {
        Object transaction = this.transaction;
        if (!(transaction instanceof SavepointManager)) {
            throw new NestedTransactionNotSupportedException("Transaction object [" + this.transaction + "] does not support savepoints");
        }
        SavepointManager savepointManager = (SavepointManager)transaction;
        return savepointManager;
    }

    public boolean isTransactionSavepointManager() {
        return this.transaction instanceof SavepointManager;
    }

    @Override
    public void flush() {
        Object object = this.transaction;
        if (object instanceof SmartTransactionObject) {
            SmartTransactionObject smartTransactionObject = (SmartTransactionObject)object;
            smartTransactionObject.flush();
        }
    }
}

