/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.LineNumberAware;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.PollDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.PollProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LanguageSupport;

public class PollReifier
extends ProcessorReifier<PollDefinition> {
    public PollReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (PollDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Endpoint endpoint = this.resolveEndpoint();
        String uri = endpoint.getEndpointUri();
        boolean simple = LanguageSupport.hasSimpleFunction((String)uri);
        Expression exp = simple ? this.camelContext.resolveLanguage("simple").createExpression(uri) : this.camelContext.resolveLanguage("constant").createExpression(uri);
        long timeout = this.parseDuration(((PollDefinition)this.definition).getTimeout(), 20000L);
        PollProcessor answer = new PollProcessor(exp, uri, timeout);
        answer.setVariableReceive(this.parseString(((PollDefinition)this.definition).getVariableReceive()));
        return answer;
    }

    public Endpoint resolveEndpoint() {
        Endpoint answer = ((PollDefinition)this.definition).getEndpoint() == null ? (((PollDefinition)this.definition).getEndpointConsumerBuilder() == null ? CamelContextHelper.resolveEndpoint((CamelContext)this.camelContext, (String)((PollDefinition)this.definition).getEndpointUri(), null) : ((PollDefinition)this.definition).getEndpointConsumerBuilder().resolve(this.camelContext)) : ((PollDefinition)this.definition).getEndpoint();
        LineNumberAware.trySetLineNumberAware((Object)answer, (LineNumberAware)this.definition);
        return answer;
    }
}

