/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.proton.engine.impl.ssl.ProtonSslEngine;

class DefaultSslEngineFacade
implements ProtonSslEngine {
    private final SSLEngine _sslEngine;
    private static final int APPLICATION_BUFFER_EXTRA = 50;

    DefaultSslEngineFacade(SSLEngine sslEngine) {
        this._sslEngine = sslEngine;
    }

    @Override
    public SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this._sslEngine.wrap(src, dst);
    }

    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        return this._sslEngine.unwrap(src, dst);
    }

    @Override
    public int getEffectiveApplicationBufferSize() {
        return this.getApplicationBufferSize() + 50;
    }

    private int getApplicationBufferSize() {
        return this._sslEngine.getSession().getApplicationBufferSize();
    }

    @Override
    public int getPacketBufferSize() {
        return this._sslEngine.getSession().getPacketBufferSize();
    }

    @Override
    public String getCipherSuite() {
        return this._sslEngine.getSession().getCipherSuite();
    }

    @Override
    public String getProtocol() {
        return this._sslEngine.getSession().getProtocol();
    }

    @Override
    public Runnable getDelegatedTask() {
        return this._sslEngine.getDelegatedTask();
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this._sslEngine.getHandshakeStatus();
    }

    @Override
    public boolean getUseClientMode() {
        return this._sslEngine.getUseClientMode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefaultSslEngineFacade [_sslEngine=").append(this._sslEngine).append("]");
        return builder.toString();
    }
}

