/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util.jmx;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;

public final class JmxUtil {
    private JmxUtil() {
    }

    public static ObjectName newObjectName(String pName) {
        try {
            return new ObjectName(pName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name " + pName, e);
        }
    }

    public static void addMBeanRegistrationListener(MBeanServerConnection pServer, NotificationListener pListener, ObjectName pObjectNameToFilter) {
        MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
        if (pObjectNameToFilter == null) {
            filter.enableAllObjectNames();
        } else {
            filter.enableObjectName(pObjectNameToFilter);
        }
        try {
            pServer.addNotificationListener(JmxUtil.getMBeanServerDelegateName(), pListener, (NotificationFilter)filter, null);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Cannot find " + JmxUtil.getMBeanServerDelegateName() + " in server " + pServer, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException while registering notification listener for " + JmxUtil.getMBeanServerDelegateName(), e);
        }
    }

    public static void removeMBeanRegistrationListener(MBeanServerConnection pServer, NotificationListener pListener) {
        try {
            pServer.removeNotificationListener(JmxUtil.getMBeanServerDelegateName(), pListener);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException("Cannot find " + JmxUtil.getMBeanServerDelegateName() + " in server " + pServer, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException while registering notification listener for " + JmxUtil.getMBeanServerDelegateName(), e);
        }
    }

    private static ObjectName getMBeanServerDelegateName() {
        try {
            return MBeanServerDelegate.DELEGATE_NAME;
        }
        catch (NoSuchFieldError error) {
            return JmxUtil.newObjectName("JMImplementation:type=MBeanServerDelegate");
        }
    }
}

