/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.processor.ClaimCheckAggregationStrategy;
import org.apache.camel.processor.DefaultClaimCheckRepository;
import org.apache.camel.spi.ClaimCheckRepository;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaimCheckProcessor
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ClaimCheckProcessor.class);
    private CamelContext camelContext;
    private String id;
    private String routeId;
    private String operation;
    private AggregationStrategy aggregationStrategy;
    private String key;
    private Expression keyExpression;
    private String filter;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        ClaimCheckRepository repo = ClaimCheckProcessor.getClaimCheckRepository(exchange);
        try {
            String claimKey = (String)this.keyExpression.evaluate(exchange, String.class);
            switch (this.operation) {
                case "Set": {
                    ClaimCheckProcessor.operationSetHandler(exchange, claimKey, repo);
                    break;
                }
                case "Get": {
                    this.operationGetHandler(exchange, claimKey, repo);
                    break;
                }
                case "GetAndRemove": {
                    this.operationGetAndRemoveHandler(exchange, claimKey, repo);
                    break;
                }
                case "Push": {
                    ClaimCheckProcessor.operationPushHandler(exchange, claimKey, repo);
                    break;
                }
                case "Pop": {
                    this.operationPopHandler(exchange, claimKey, repo);
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    private void operationPopHandler(Exchange exchange, String claimKey, ClaimCheckRepository repo) {
        Exchange copy = repo.pop();
        LOG.debug("Pop: {} -> {}", (Object)claimKey, (Object)exchange);
        if (copy != null) {
            ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)copy);
            Exchange result = this.aggregationStrategy.aggregate(exchange, copy);
            if (result != null) {
                ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)result);
            }
        }
    }

    private static void operationPushHandler(Exchange exchange, String claimKey, ClaimCheckRepository repo) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
        LOG.debug("Push: {} -> {}", (Object)claimKey, (Object)copy);
        repo.push(copy);
    }

    private void operationGetAndRemoveHandler(Exchange exchange, String claimKey, ClaimCheckRepository repo) {
        Exchange copy = repo.getAndRemove(claimKey);
        LOG.debug("GetAndRemove: {} -> {}", (Object)claimKey, (Object)exchange);
        if (copy != null) {
            ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)copy);
            Exchange result = this.aggregationStrategy.aggregate(exchange, copy);
            if (result != null) {
                ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)result);
            }
        }
    }

    private void operationGetHandler(Exchange exchange, String claimKey, ClaimCheckRepository repo) {
        Exchange result;
        Exchange copy = repo.get(claimKey);
        LOG.debug("Get: {} -> {}", (Object)claimKey, (Object)exchange);
        if (copy != null && (result = this.aggregationStrategy.aggregate(exchange, copy)) != null) {
            ExchangeHelper.copyResultsPreservePattern((Exchange)exchange, (Exchange)result);
        }
    }

    private static void operationSetHandler(Exchange exchange, String claimKey, ClaimCheckRepository repo) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
        boolean addedNew = repo.add(claimKey, copy);
        if (addedNew) {
            LOG.debug("Add: {} -> {}", (Object)claimKey, (Object)copy);
        } else {
            LOG.debug("Override: {} -> {}", (Object)claimKey, (Object)copy);
        }
    }

    private static ClaimCheckRepository getClaimCheckRepository(Exchange exchange) {
        ClaimCheckRepository repo = (ClaimCheckRepository)exchange.getProperty(ExchangePropertyKey.CLAIM_CHECK_REPOSITORY, ClaimCheckRepository.class);
        if (repo == null) {
            repo = new DefaultClaimCheckRepository();
            exchange.setProperty(ExchangePropertyKey.CLAIM_CHECK_REPOSITORY, (Object)repo);
        }
        return repo;
    }

    protected void doInit() throws Exception {
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = this.createAggregationStrategy();
        }
        CamelContextAware.trySetCamelContext((Object)this.aggregationStrategy, (CamelContext)this.camelContext);
        this.keyExpression = LanguageSupport.hasSimpleFunction((String)this.key) ? this.camelContext.resolveLanguage("simple").createExpression(this.key) : this.camelContext.resolveLanguage("constant").createExpression(this.key);
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.operation, (String)"operation", (Object)((Object)this));
        ServiceHelper.startService((Object)this.aggregationStrategy);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.aggregationStrategy);
    }

    public String toString() {
        return this.id;
    }

    protected AggregationStrategy createAggregationStrategy() {
        ClaimCheckAggregationStrategy answer = new ClaimCheckAggregationStrategy();
        answer.setFilter(this.filter);
        return answer;
    }
}

