/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;

public class RemoveHeaderProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private final String headerName;
    private String id;
    private String routeId;

    public RemoveHeaderProcessor(String headerName) {
        this.headerName = headerName;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            exchange.getMessage().removeHeader(this.headerName);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "removeHeader[" + this.headerName + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getHeaderName() {
        return this.headerName;
    }
}

