/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageSymbolSearch;
import org.apache.activemq.artemis.protocol.amqp.broker.KMPNeedle;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.AmqpCoreConverter;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.DroppingWritableBuffer;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;
import org.jboss.logging.Logger;

public abstract class AMQPMessage
extends RefCountMessage
implements Message {
    protected static final Logger logger = Logger.getLogger(AMQPMessage.class);
    public static final SimpleString ADDRESS_PROPERTY = SimpleString.toSimpleString((String)"_AMQ_AD");
    private static final Symbol[] SCHEDULED_DELIVERY_SYMBOLS = new Symbol[]{AMQPMessageSupport.SCHEDULED_DELIVERY_TIME, AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY};
    private static final KMPNeedle[] SCHEDULED_DELIVERY_NEEDLES = new KMPNeedle[]{AMQPMessageSymbolSearch.kmpNeedleOf(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME), AMQPMessageSymbolSearch.kmpNeedleOf(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY)};
    public static final int DEFAULT_MESSAGE_FORMAT = 0;
    public static final int DEFAULT_MESSAGE_PRIORITY = 4;
    public static final int MAX_MESSAGE_PRIORITY = 9;
    protected static final int VALUE_NOT_PRESENT = -1;
    protected byte messageDataScanned;
    protected boolean modified;
    protected int headerPosition;
    protected int encodedHeaderSize;
    protected int deliveryAnnotationsPosition;
    protected int encodedDeliveryAnnotationsSize;
    protected int messageAnnotationsPosition;
    protected int propertiesPosition;
    protected int applicationPropertiesPosition;
    protected int remainingBodyPosition;
    protected final long messageFormat;
    protected long messageID;
    protected SimpleString address;
    protected volatile int memoryEstimate;
    protected long expiration;
    protected long scheduledTime;
    protected Header header;
    protected MessageAnnotations messageAnnotations;
    protected Properties properties;
    protected ApplicationProperties applicationProperties;
    protected String connectionID;
    protected final CoreMessageObjectPools coreMessageObjectPools;
    protected Set<Object> rejectedConsumers;
    protected DeliveryAnnotations deliveryAnnotationsForSendBuffer;
    protected volatile TypedProperties extraProperties;

    public AMQPMessage(long messageFormat, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        this.messageDataScanned = MessageDataScanningStatus.NOT_SCANNED.code;
        this.headerPosition = -1;
        this.deliveryAnnotationsPosition = -1;
        this.messageAnnotationsPosition = -1;
        this.propertiesPosition = -1;
        this.applicationPropertiesPosition = -1;
        this.remainingBodyPosition = -1;
        this.memoryEstimate = -1;
        this.scheduledTime = -1L;
        this.messageFormat = messageFormat;
        this.coreMessageObjectPools = coreMessageObjectPools;
        this.extraProperties = extraProperties == null ? null : new TypedProperties(extraProperties);
    }

    protected AMQPMessage(AMQPMessage copy) {
        this(copy.messageFormat, copy.extraProperties, copy.coreMessageObjectPools);
    }

    protected AMQPMessage(long messageFormat) {
        this.messageDataScanned = MessageDataScanningStatus.NOT_SCANNED.code;
        this.headerPosition = -1;
        this.deliveryAnnotationsPosition = -1;
        this.messageAnnotationsPosition = -1;
        this.propertiesPosition = -1;
        this.applicationPropertiesPosition = -1;
        this.remainingBodyPosition = -1;
        this.memoryEstimate = -1;
        this.scheduledTime = -1L;
        this.messageFormat = messageFormat;
        this.coreMessageObjectPools = null;
    }

    public final MessageDataScanningStatus messageDataScanned() {
        return MessageDataScanningStatus.valueOf(this.messageDataScanned);
    }

    public ApplicationProperties getDecodedApplicationProperties() {
        return this.applicationProperties;
    }

    protected abstract ReadableBuffer getData();

    public final MessageImpl getProtonMessage() {
        if (this.getData() == null) {
            throw new NullPointerException("Data is not initialized");
        }
        this.ensureScanning();
        MessageImpl protonMessage = null;
        if (this.getData() != null) {
            protonMessage = (MessageImpl)Message.Factory.create();
            this.getData().rewind();
            protonMessage.decode(this.getData().duplicate());
        }
        return protonMessage;
    }

    public final Header getHeader() {
        this.ensureScanning();
        return (Header)this.scanForMessageSection(this.headerPosition, Header.class);
    }

    protected void ensureScanning() {
        this.ensureDataIsValid();
        this.ensureMessageDataScanned();
    }

    public final DeliveryAnnotations getDeliveryAnnotations() {
        this.ensureScanning();
        return (DeliveryAnnotations)this.scanForMessageSection(this.deliveryAnnotationsPosition, DeliveryAnnotations.class);
    }

    public final void setDeliveryAnnotationsForSendBuffer(DeliveryAnnotations deliveryAnnotations) {
        this.deliveryAnnotationsForSendBuffer = deliveryAnnotations;
    }

    public final MessageAnnotations getMessageAnnotations() {
        this.ensureScanning();
        return (MessageAnnotations)this.scanForMessageSection(this.messageAnnotationsPosition, MessageAnnotations.class);
    }

    public final Properties getProperties() {
        this.ensureScanning();
        return (Properties)this.scanForMessageSection(this.propertiesPosition, Properties.class);
    }

    public final ApplicationProperties getApplicationProperties() {
        this.ensureScanning();
        return (ApplicationProperties)this.scanForMessageSection(this.applicationPropertiesPosition, ApplicationProperties.class);
    }

    public final String toDebugString() {
        return ByteUtil.debugByteArray((byte[])this.getData().array());
    }

    public final Section getBody() {
        this.ensureScanning();
        return (Section)this.scanForMessageSection(Math.max(0, this.remainingBodyPosition), AmqpSequence.class, AmqpValue.class, Data.class);
    }

    public final Footer getFooter() {
        this.ensureScanning();
        return (Footer)this.scanForMessageSection(Math.max(0, this.remainingBodyPosition), Footer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T scanForMessageSection(int scanStartPosition, Class ... targetTypes) {
        this.ensureMessageDataScanned();
        if (scanStartPosition == -1) {
            return null;
        }
        ReadableBuffer buffer = this.getData().duplicate().position(0);
        DecoderImpl decoder = TLSEncode.getDecoder();
        buffer.position(scanStartPosition);
        Object section = null;
        decoder.setBuffer(buffer);
        try {
            while (buffer.hasRemaining()) {
                TypeConstructor constructor = decoder.readConstructor();
                for (Class type : targetTypes) {
                    if (!type.equals(constructor.getTypeClass())) continue;
                    Object object = section = constructor.readValue();
                    return (T)object;
                }
                constructor.skipValue();
            }
        }
        finally {
            decoder.setBuffer(null);
        }
        return (T)section;
    }

    protected ApplicationProperties lazyDecodeApplicationProperties() {
        if (this.applicationProperties == null && this.applicationPropertiesPosition != -1) {
            this.applicationProperties = (ApplicationProperties)this.scanForMessageSection(this.applicationPropertiesPosition, ApplicationProperties.class);
        }
        return this.applicationProperties;
    }

    protected Map<String, Object> getApplicationPropertiesMap(boolean createIfAbsent) {
        ApplicationProperties appMap = this.lazyDecodeApplicationProperties();
        HashMap map = null;
        if (appMap != null) {
            map = appMap.getValue();
        }
        if (map == null) {
            if (createIfAbsent) {
                map = new HashMap();
                this.applicationProperties = new ApplicationProperties(map);
            } else {
                map = Collections.EMPTY_MAP;
            }
        }
        return map;
    }

    protected Map<Symbol, Object> getMessageAnnotationsMap(boolean createIfAbsent) {
        HashMap map = null;
        if (this.messageAnnotations != null) {
            map = this.messageAnnotations.getValue();
        }
        if (map == null) {
            if (createIfAbsent) {
                map = new HashMap();
                this.messageAnnotations = new MessageAnnotations(map);
            } else {
                map = Collections.EMPTY_MAP;
            }
        }
        return map;
    }

    protected Object getMessageAnnotation(String annotation) {
        return this.getMessageAnnotation(Symbol.getSymbol((String)annotation));
    }

    protected Object getMessageAnnotation(Symbol annotation) {
        return this.getMessageAnnotationsMap(false).get(annotation);
    }

    protected Object removeMessageAnnotation(Symbol annotation) {
        return this.getMessageAnnotationsMap(false).remove(annotation);
    }

    protected void setMessageAnnotation(String annotation, Object value) {
        this.setMessageAnnotation(Symbol.getSymbol((String)annotation), value);
    }

    protected void setMessageAnnotation(Symbol annotation, Object value) {
        this.getMessageAnnotationsMap(true).put(annotation, value);
    }

    protected synchronized void ensureMessageDataScanned() {
        MessageDataScanningStatus state = MessageDataScanningStatus.valueOf(this.messageDataScanned);
        switch (state) {
            case NOT_SCANNED: {
                this.scanMessageData();
                break;
            }
            case RELOAD_PERSISTENCE: {
                this.lazyScanAfterReloadPersistence();
                break;
            }
        }
    }

    protected int getEstimateSavedEncode() {
        return this.remainingBodyPosition > 0 ? this.remainingBodyPosition : 1024;
    }

    protected void saveEncoding(ByteBuf buf) {
        WritableBuffer oldBuffer = TLSEncode.getEncoder().getBuffer();
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(buf));
        try {
            buf.writeInt(this.headerPosition);
            buf.writeInt(this.encodedHeaderSize);
            TLSEncode.getEncoder().writeObject((Object)this.header);
            buf.writeInt(this.deliveryAnnotationsPosition);
            buf.writeInt(this.encodedDeliveryAnnotationsSize);
            buf.writeInt(this.messageAnnotationsPosition);
            TLSEncode.getEncoder().writeObject((Object)this.messageAnnotations);
            buf.writeInt(this.propertiesPosition);
            TLSEncode.getEncoder().writeObject((Object)this.properties);
            buf.writeInt(this.applicationPropertiesPosition);
            buf.writeInt(this.remainingBodyPosition);
            TLSEncode.getEncoder().writeObject((Object)this.applicationProperties);
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer(oldBuffer);
        }
    }

    protected void readSavedEncoding(ByteBuf buf) {
        ReadableBuffer oldBuffer = TLSEncode.getDecoder().getBuffer();
        TLSEncode.getDecoder().setBuffer((ReadableBuffer)new NettyReadable(buf));
        try {
            this.messageDataScanned = MessageDataScanningStatus.SCANNED.code;
            this.headerPosition = buf.readInt();
            this.encodedHeaderSize = buf.readInt();
            this.header = (Header)TLSEncode.getDecoder().readObject();
            this.deliveryAnnotationsPosition = buf.readInt();
            this.encodedDeliveryAnnotationsSize = buf.readInt();
            this.messageAnnotationsPosition = buf.readInt();
            this.messageAnnotations = (MessageAnnotations)TLSEncode.getDecoder().readObject();
            this.propertiesPosition = buf.readInt();
            this.properties = (Properties)TLSEncode.getDecoder().readObject();
            this.applicationPropertiesPosition = buf.readInt();
            this.remainingBodyPosition = buf.readInt();
            this.applicationProperties = (ApplicationProperties)TLSEncode.getDecoder().readObject();
        }
        finally {
            TLSEncode.getDecoder().setBuffer(oldBuffer);
        }
    }

    protected synchronized void resetMessageData() {
        this.header = null;
        this.messageAnnotations = null;
        this.properties = null;
        this.applicationProperties = null;
        this.expiration = 0L;
        this.encodedHeaderSize = 0;
        this.memoryEstimate = -1;
        this.scheduledTime = -1L;
        this.encodedDeliveryAnnotationsSize = 0;
        this.headerPosition = -1;
        this.deliveryAnnotationsPosition = -1;
        this.propertiesPosition = -1;
        this.applicationPropertiesPosition = -1;
        this.remainingBodyPosition = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void scanMessageData() {
        this.messageDataScanned = MessageDataScanningStatus.SCANNED.code;
        DecoderImpl decoder = TLSEncode.getDecoder();
        decoder.setBuffer(this.getData().rewind());
        this.resetMessageData();
        ReadableBuffer data = this.getData();
        try {
            while (data.hasRemaining()) {
                int constructorPos = data.position();
                TypeConstructor constructor = decoder.readConstructor();
                if (Header.class.equals((Object)constructor.getTypeClass())) {
                    this.header = (Header)constructor.readValue();
                    this.headerPosition = constructorPos;
                    this.encodedHeaderSize = data.position();
                    if (this.header.getTtl() == null) continue;
                    this.expiration = System.currentTimeMillis() + (long)this.header.getTtl().intValue();
                    continue;
                }
                if (DeliveryAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    constructor.skipValue();
                    this.deliveryAnnotationsPosition = constructorPos;
                    this.encodedDeliveryAnnotationsSize = data.position() - constructorPos;
                    continue;
                }
                if (MessageAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    this.messageAnnotationsPosition = constructorPos;
                    this.messageAnnotations = (MessageAnnotations)constructor.readValue();
                    continue;
                }
                if (Properties.class.equals((Object)constructor.getTypeClass())) {
                    this.propertiesPosition = constructorPos;
                    this.properties = (Properties)constructor.readValue();
                    if (this.properties.getAbsoluteExpiryTime() == null || this.properties.getAbsoluteExpiryTime().getTime() <= 0L) continue;
                    this.expiration = this.properties.getAbsoluteExpiryTime().getTime();
                    continue;
                }
                if (ApplicationProperties.class.equals((Object)constructor.getTypeClass())) {
                    this.applicationPropertiesPosition = constructorPos;
                    constructor.skipValue();
                    this.remainingBodyPosition = data.hasRemaining() ? data.position() : -1;
                } else {
                    this.remainingBodyPosition = constructorPos;
                }
                break;
            }
        }
        finally {
            decoder.setByteBuffer(null);
            data.rewind();
        }
    }

    public abstract Message copy();

    public final void sendBuffer(ByteBuf buffer, int deliveryCount) {
        this.ensureDataIsValid();
        NettyWritable writable = new NettyWritable(buffer);
        writable.put(this.getSendBuffer(deliveryCount));
    }

    public ReadableBuffer getSendBuffer(int deliveryCount) {
        this.ensureDataIsValid();
        if (deliveryCount > 1) {
            return this.createCopyWithNewDeliveryCount(deliveryCount);
        }
        if (this.deliveryAnnotationsPosition != -1 || this.deliveryAnnotationsForSendBuffer != null && !this.deliveryAnnotationsForSendBuffer.getValue().isEmpty()) {
            return this.createCopyWithSkippedOrExplicitlySetDeliveryAnnotations();
        }
        return this.getData().duplicate();
    }

    protected ReadableBuffer createCopyWithSkippedOrExplicitlySetDeliveryAnnotations() {
        ReadableBuffer duplicate = this.getData().duplicate();
        ByteBuf result = PooledByteBufAllocator.DEFAULT.heapBuffer(this.getEncodeSize());
        result.writeBytes(duplicate.limit(this.encodedHeaderSize).byteBuffer());
        this.writeDeliveryAnnotationsForSendBuffer(result);
        duplicate.clear();
        duplicate.position(this.encodedHeaderSize + this.encodedDeliveryAnnotationsSize);
        result.writeBytes(duplicate.byteBuffer());
        return new NettyReadable(result);
    }

    protected ReadableBuffer createCopyWithNewDeliveryCount(int deliveryCount) {
        assert (deliveryCount > 1);
        int amqpDeliveryCount = deliveryCount - 1;
        ByteBuf result = PooledByteBufAllocator.DEFAULT.heapBuffer(this.getEncodeSize());
        Header header = this.header;
        header = header == null ? new Header() : new Header(header);
        header.setDeliveryCount(UnsignedInteger.valueOf((int)amqpDeliveryCount));
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(result));
        TLSEncode.getEncoder().writeObject((Object)header);
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        this.writeDeliveryAnnotationsForSendBuffer(result);
        this.getData().position(this.encodedHeaderSize + this.encodedDeliveryAnnotationsSize);
        result.writeBytes(this.getData().byteBuffer());
        this.getData().position(0);
        return new NettyReadable(result);
    }

    protected void writeDeliveryAnnotationsForSendBuffer(ByteBuf result) {
        if (this.deliveryAnnotationsForSendBuffer != null && !this.deliveryAnnotationsForSendBuffer.getValue().isEmpty()) {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(result));
            TLSEncode.getEncoder().writeObject((Object)this.deliveryAnnotationsForSendBuffer);
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        }
    }

    protected int getDeliveryAnnotationsForSendBufferSize() {
        if (this.deliveryAnnotationsForSendBuffer == null || this.deliveryAnnotationsForSendBuffer.getValue().isEmpty()) {
            return 0;
        }
        DroppingWritableBuffer droppingWritableBuffer = new DroppingWritableBuffer();
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)droppingWritableBuffer);
        TLSEncode.getEncoder().writeObject((Object)this.deliveryAnnotationsForSendBuffer);
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        return droppingWritableBuffer.position() + 1;
    }

    public void messageChanged() {
        this.modified = true;
    }

    public final ByteBuf getBuffer() {
        if (this.getData() == null) {
            return null;
        }
        if (this.getData() instanceof NettyReadable) {
            return ((NettyReadable)this.getData()).getByteBuf();
        }
        return Unpooled.wrappedBuffer((ByteBuffer)this.getData().byteBuffer());
    }

    public final AMQPMessage setBuffer(ByteBuf buffer) {
        return this;
    }

    public abstract int getEncodeSize();

    public final void receiveBuffer(ByteBuf buffer) {
    }

    public abstract int getMemoryEstimate();

    public ICoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
        try {
            return AmqpCoreConverter.toCore(this, coreMessageObjectPools, this.header, this.messageAnnotations, this.properties, this.lazyDecodeApplicationProperties(), this.getBody(), this.getFooter());
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ICoreMessage toCore() {
        return this.toCore(this.coreMessageObjectPools);
    }

    public abstract void persist(ActiveMQBuffer var1);

    public abstract int getPersistSize();

    protected int internalPersistSize() {
        return this.getData().remaining();
    }

    public abstract void reloadPersistence(ActiveMQBuffer var1, CoreMessageObjectPools var2);

    protected synchronized void lazyScanAfterReloadPersistence() {
        assert (this.messageDataScanned == MessageDataScanningStatus.RELOAD_PERSISTENCE.code);
        this.scanMessageData();
        this.messageDataScanned = MessageDataScanningStatus.SCANNED.code;
        this.modified = false;
    }

    public abstract long getPersistentSize() throws ActiveMQException;

    public abstract Persister<Message> getPersister();

    public abstract void reencode();

    protected abstract void ensureDataIsValid();

    protected abstract void encodeMessage();

    public final TypedProperties createExtraProperties() {
        if (this.extraProperties == null) {
            this.extraProperties = new TypedProperties(INTERNAL_PROPERTY_NAMES_PREDICATE);
        }
        return this.extraProperties;
    }

    public final TypedProperties getExtraProperties() {
        return this.extraProperties;
    }

    public final AMQPMessage setExtraProperties(TypedProperties extraProperties) {
        this.extraProperties = extraProperties;
        return this;
    }

    public final Message putExtraBytesProperty(SimpleString key, byte[] value) {
        this.createExtraProperties().putBytesProperty(key, value);
        return this;
    }

    public final byte[] getExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        if (this.extraProperties == null) {
            return null;
        }
        return this.extraProperties.getBytesProperty(key);
    }

    public void clearInternalProperties() {
        if (this.extraProperties != null) {
            this.extraProperties.clearInternalProperties();
        }
    }

    public final byte[] removeExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        if (this.extraProperties == null) {
            return null;
        }
        return (byte[])this.extraProperties.removeProperty(key);
    }

    public final Message setConnectionID(String connectionID) {
        this.connectionID = connectionID;
        return this;
    }

    public final String getConnectionID() {
        return this.connectionID;
    }

    public final long getMessageFormat() {
        return this.messageFormat;
    }

    public final long getMessageID() {
        return this.messageID;
    }

    public final Message setMessageID(long id) {
        this.messageID = id;
        return this;
    }

    public final long getExpiration() {
        return this.expiration;
    }

    public final AMQPMessage setExpiration(long expiration) {
        if (this.properties != null) {
            if (expiration <= 0L) {
                this.properties.setAbsoluteExpiryTime(null);
            } else {
                this.properties.setAbsoluteExpiryTime(new Date(expiration));
            }
        } else if (expiration > 0L) {
            this.properties = new Properties();
            this.properties.setAbsoluteExpiryTime(new Date(expiration));
        }
        if (this.header != null) {
            this.header.setTtl(null);
        }
        this.expiration = Math.max(0L, expiration);
        return this;
    }

    public final Object getUserID() {
        if (this.properties != null && this.properties.getMessageId() != null) {
            return this.properties.getMessageId();
        }
        return null;
    }

    public final Object getAMQPUserID() {
        if (this.properties != null && this.properties.getUserId() != null) {
            Binary binary = this.properties.getUserId();
            return new String(binary.getArray(), binary.getArrayOffset(), binary.getLength(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public final Message setUserID(Object userID) {
        return this;
    }

    public final Object getDuplicateProperty() {
        return this.getObjectProperty(Message.HDR_DUPLICATE_DETECTION_ID);
    }

    public boolean isDurable() {
        if (this.header != null && this.header.getDurable() != null) {
            return this.header.getDurable();
        }
        return false;
    }

    public final Message setDurable(boolean durable) {
        if (this.header == null) {
            this.header = new Header();
        }
        this.header.setDurable(Boolean.valueOf(durable));
        return this;
    }

    public final String getAddress() {
        SimpleString addressSimpleString = this.getAddressSimpleString();
        return addressSimpleString == null ? null : addressSimpleString.toString();
    }

    public final AMQPMessage setAddress(String address) {
        this.setAddress(this.cachedAddressSimpleString(address));
        return this;
    }

    public final AMQPMessage setAddress(SimpleString address) {
        this.address = address;
        this.createExtraProperties().putSimpleStringProperty(ADDRESS_PROPERTY, address);
        return this;
    }

    public final SimpleString getAddressSimpleString() {
        if (this.address == null) {
            TypedProperties extraProperties = this.getExtraProperties();
            if (extraProperties != null) {
                this.address = extraProperties.getSimpleStringProperty(ADDRESS_PROPERTY);
            }
            if (this.address == null && this.properties != null && this.properties.getTo() != null) {
                this.address = this.cachedAddressSimpleString(this.properties.getTo());
            }
        }
        return this.address;
    }

    protected SimpleString cachedAddressSimpleString(String address) {
        return CoreMessageObjectPools.cachedAddressSimpleString((String)address, (CoreMessageObjectPools)this.coreMessageObjectPools);
    }

    public final long getTimestamp() {
        if (this.properties != null && this.properties.getCreationTime() != null) {
            return this.properties.getCreationTime().getTime();
        }
        return 0L;
    }

    public final Message setTimestamp(long timestamp) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setCreationTime(new Date(timestamp));
        return this;
    }

    public final byte getPriority() {
        if (this.header != null && this.header.getPriority() != null) {
            return (byte)Math.min(this.header.getPriority().intValue(), 9);
        }
        return 4;
    }

    public final Message setPriority(byte priority) {
        if (this.header == null) {
            this.header = new Header();
        }
        this.header.setPriority(UnsignedByte.valueOf((byte)priority));
        return this;
    }

    public final SimpleString getReplyTo() {
        if (this.properties != null) {
            return SimpleString.toSimpleString((String)this.properties.getReplyTo());
        }
        return null;
    }

    public final AMQPMessage setReplyTo(SimpleString address) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setReplyTo(address != null ? address.toString() : null);
        return this;
    }

    public final RoutingType getRoutingType() {
        this.ensureMessageDataScanned();
        Object routingType = this.getMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE);
        if (routingType != null) {
            return RoutingType.getType((byte)((Number)routingType).byteValue());
        }
        routingType = this.getMessageAnnotation(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION);
        if (routingType != null) {
            if (0 == ((Number)routingType).byteValue() || 2 == ((Number)routingType).byteValue()) {
                return RoutingType.ANYCAST;
            }
            if (1 == ((Number)routingType).byteValue() || 3 == ((Number)routingType).byteValue()) {
                return RoutingType.MULTICAST;
            }
        } else {
            return null;
        }
        return null;
    }

    public final Message setRoutingType(RoutingType routingType) {
        if (routingType == null) {
            this.removeMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE);
        } else {
            this.setMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE, (Object)routingType.getType());
        }
        return this;
    }

    public final SimpleString getGroupID() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.properties.getGroupId() != null) {
            return SimpleString.toSimpleString((String)this.properties.getGroupId(), this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getGroupIdStringSimpleStringPool());
        }
        return null;
    }

    public final int getGroupSequence() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.properties.getGroupSequence() != null) {
            return this.properties.getGroupSequence().intValue();
        }
        return 0;
    }

    public final Object getCorrelationID() {
        return this.properties != null ? this.properties.getCorrelationId() : null;
    }

    public final Message setCorrelationID(Object correlationID) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setCorrelationId(correlationID);
        return this;
    }

    public boolean hasScheduledDeliveryTime() {
        if (this.scheduledTime >= 0L) {
            return true;
        }
        return this.anyMessageAnnotations(SCHEDULED_DELIVERY_SYMBOLS, SCHEDULED_DELIVERY_NEEDLES);
    }

    private boolean anyMessageAnnotations(Symbol[] symbols, KMPNeedle[] symbolNeedles) {
        assert (symbols.length == symbolNeedles.length);
        int count = symbols.length;
        if (this.messageDataScanned == MessageDataScanningStatus.SCANNED.code) {
            MessageAnnotations messageAnnotations = this.messageAnnotations;
            if (messageAnnotations == null) {
                return false;
            }
            Map map = messageAnnotations.getValue();
            if (map == null) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                if (!map.containsKey(symbols[i])) continue;
                return true;
            }
            return false;
        }
        return AMQPMessageSymbolSearch.anyMessageAnnotations(this.getData(), symbolNeedles);
    }

    public final Long getScheduledDeliveryTime() {
        this.ensureMessageDataScanned();
        if (this.scheduledTime < 0L) {
            Object objscheduledTime = this.getMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME);
            Object objdelay = this.getMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY);
            this.scheduledTime = objscheduledTime != null && objscheduledTime instanceof Number ? ((Number)objscheduledTime).longValue() : (objdelay != null && objdelay instanceof Number ? System.currentTimeMillis() + ((Number)objdelay).longValue() : 0L);
        }
        return this.scheduledTime;
    }

    public final AMQPMessage setScheduledDeliveryTime(Long time) {
        if (time != null && time > 0L) {
            this.setMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME, (Object)time);
            this.removeMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY);
            this.scheduledTime = time;
        } else {
            this.removeMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME);
            this.removeMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY);
            this.scheduledTime = 0L;
        }
        return this;
    }

    public final Object removeAnnotation(SimpleString key) {
        return this.removeMessageAnnotation(Symbol.getSymbol((String)key.toString()));
    }

    public final Object getAnnotation(SimpleString key) {
        return this.getMessageAnnotation(key.toString());
    }

    public final AMQPMessage setAnnotation(SimpleString key, Object value) {
        this.setMessageAnnotation(key.toString(), value);
        return this;
    }

    public final Object removeProperty(SimpleString key) {
        return this.removeProperty(key.toString());
    }

    public final Object removeProperty(String key) {
        return this.getApplicationPropertiesMap(false).remove(key);
    }

    public final boolean containsProperty(SimpleString key) {
        return this.containsProperty(key.toString());
    }

    public final boolean containsProperty(String key) {
        return this.getApplicationPropertiesMap(false).containsKey(key);
    }

    public final Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
        return (Boolean)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
        return (Byte)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
        return (Double)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
        return (Integer)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
        return (Long)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Object getObjectProperty(String key) {
        if (key.equals(MessageUtil.TYPE_HEADER_NAME.toString())) {
            if (this.properties != null) {
                return this.properties.getSubject();
            }
        } else {
            if (key.equals(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString())) {
                return this.getConnectionID();
            }
            if (key.equals("JMSXGroupID")) {
                return this.getGroupID();
            }
            if (key.equals("JMSXGroupSeq")) {
                return this.getGroupSequence();
            }
            if (key.equals("JMSXUserID")) {
                return this.getAMQPUserID();
            }
            if (key.equals(MessageUtil.CORRELATIONID_HEADER_NAME.toString())) {
                if (this.properties != null && this.properties.getCorrelationId() != null) {
                    return AMQPMessageIdHelper.INSTANCE.toCorrelationIdString(this.properties.getCorrelationId());
                }
            } else {
                Object value = this.getApplicationPropertiesMap(false).get(key);
                if (value instanceof UnsignedInteger || value instanceof UnsignedByte || value instanceof UnsignedLong || value instanceof UnsignedShort) {
                    return ((Number)value).longValue();
                }
                return value;
            }
        }
        return null;
    }

    public final Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
        return (Short)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
        return (Float)this.getApplicationPropertiesMap(false).get(key);
    }

    public final String getStringProperty(String key) throws ActiveMQPropertyConversionException {
        if (key.equals(MessageUtil.TYPE_HEADER_NAME.toString())) {
            return this.properties.getSubject();
        }
        if (key.equals(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString())) {
            return this.getConnectionID();
        }
        return (String)this.getApplicationPropertiesMap(false).get(key);
    }

    public final Set<SimpleString> getPropertyNames() {
        HashSet<SimpleString> values = new HashSet<SimpleString>();
        for (String k : this.getApplicationPropertiesMap(false).keySet()) {
            values.add(SimpleString.toSimpleString((String)k.toString(), (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
        }
        return values;
    }

    public final Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBooleanProperty(key.toString());
    }

    public final Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getByteProperty(key.toString());
    }

    public final byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
        return (byte[])this.getApplicationPropertiesMap(false).get(key);
    }

    public final Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getDoubleProperty(key.toString());
    }

    public final Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getIntProperty(key.toString());
    }

    public final Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getLongProperty(key.toString());
    }

    public final Object getObjectProperty(SimpleString key) {
        return this.getObjectProperty(key.toString());
    }

    public final Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getShortProperty(key.toString());
    }

    public final Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getFloatProperty(key.toString());
    }

    public final String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getStringProperty(key.toString());
    }

    public final SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getSimpleStringProperty(key.toString());
    }

    public final byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(key.toString());
    }

    public final SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
        return SimpleString.toSimpleString((String)((String)this.getApplicationPropertiesMap(false).get(key)), (SimpleString.StringSimpleStringPool)this.getPropertyValuesPool());
    }

    public final Message putBooleanProperty(String key, boolean value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putByteProperty(String key, byte value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putBytesProperty(String key, byte[] value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putShortProperty(String key, short value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putCharProperty(String key, char value) {
        this.getApplicationPropertiesMap(true).put(key, Character.valueOf(value));
        return this;
    }

    public final Message putIntProperty(String key, int value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putLongProperty(String key, long value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putFloatProperty(String key, float value) {
        this.getApplicationPropertiesMap(true).put(key, Float.valueOf(value));
        return this;
    }

    public final Message putDoubleProperty(String key, double value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putBooleanProperty(SimpleString key, boolean value) {
        this.getApplicationPropertiesMap(true).put(key.toString(), value);
        return this;
    }

    public final Message putByteProperty(SimpleString key, byte value) {
        return this.putByteProperty(key.toString(), value);
    }

    public final Message putBytesProperty(SimpleString key, byte[] value) {
        return this.putBytesProperty(key.toString(), value);
    }

    public final Message putShortProperty(SimpleString key, short value) {
        return this.putShortProperty(key.toString(), value);
    }

    public final Message putCharProperty(SimpleString key, char value) {
        return this.putCharProperty(key.toString(), value);
    }

    public final Message putIntProperty(SimpleString key, int value) {
        return this.putIntProperty(key.toString(), value);
    }

    public final Message putLongProperty(SimpleString key, long value) {
        return this.putLongProperty(key.toString(), value);
    }

    public final Message putFloatProperty(SimpleString key, float value) {
        return this.putFloatProperty(key.toString(), value);
    }

    public final Message putDoubleProperty(SimpleString key, double value) {
        return this.putDoubleProperty(key.toString(), value);
    }

    public final Message putStringProperty(String key, String value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public final Message putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        return this.putObjectProperty(key.toString(), value);
    }

    public final Message putStringProperty(SimpleString key, SimpleString value) {
        return this.putStringProperty(key.toString(), value.toString());
    }

    public final Message putStringProperty(SimpleString key, String value) {
        return this.putStringProperty(key.toString(), value);
    }

    public final SimpleString getLastValueProperty() {
        return this.getSimpleStringProperty(HDR_LAST_VALUE_NAME);
    }

    public final Message setLastValueProperty(SimpleString lastValueName) {
        return this.putStringProperty(HDR_LAST_VALUE_NAME, lastValueName);
    }

    public String toString() {
        return super.toString();
    }

    public final synchronized boolean acceptsConsumer(long consumer) {
        if (this.rejectedConsumers == null) {
            return true;
        }
        return !this.rejectedConsumers.contains(consumer);
    }

    public final synchronized void rejectConsumer(long consumer) {
        if (this.rejectedConsumers == null) {
            this.rejectedConsumers = new HashSet<Object>();
        }
        this.rejectedConsumers.add(consumer);
    }

    protected SimpleString.StringSimpleStringPool getPropertyKeysPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyKeysPool();
    }

    protected SimpleString.StringSimpleStringPool getPropertyValuesPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyValuesPool();
    }

    public static final class MessageDataScanningStatus
    extends Enum<MessageDataScanningStatus> {
        public static final /* enum */ MessageDataScanningStatus NOT_SCANNED = new MessageDataScanningStatus(0);
        public static final /* enum */ MessageDataScanningStatus RELOAD_PERSISTENCE = new MessageDataScanningStatus(1);
        public static final /* enum */ MessageDataScanningStatus SCANNED = new MessageDataScanningStatus(2);
        private static final MessageDataScanningStatus[] STATES;
        final byte code;
        private static final /* synthetic */ MessageDataScanningStatus[] $VALUES;

        public static MessageDataScanningStatus[] values() {
            return (MessageDataScanningStatus[])$VALUES.clone();
        }

        public static MessageDataScanningStatus valueOf(String name) {
            return Enum.valueOf(MessageDataScanningStatus.class, name);
        }

        private MessageDataScanningStatus(int code) {
            assert (code >= 0 && code <= 127);
            this.code = (byte)code;
        }

        static MessageDataScanningStatus valueOf(int code) {
            MessageDataScanningStatus.checkCode(code);
            return STATES[code];
        }

        private static void checkCode(int code) {
            if (code < 0 || code > STATES.length - 1) {
                throw new IllegalArgumentException("invalid status code: " + code);
            }
        }

        static {
            $VALUES = new MessageDataScanningStatus[]{NOT_SCANNED, RELOAD_PERSISTENCE, SCANNED};
            MessageDataScanningStatus[] states = MessageDataScanningStatus.values();
            STATES = new MessageDataScanningStatus[states.length];
            for (MessageDataScanningStatus state : states) {
                byte code = state.code;
                if (STATES[code] != null) {
                    throw new AssertionError((Object)("code already in use: " + code));
                }
                MessageDataScanningStatus.STATES[code] = state;
            }
        }
    }
}

