/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import java.util.Objects;
import org.apache.qpid.proton.codec.ReadableBuffer;

final class KMPNeedle {
    private final int[] jumpTable;
    private final byte[] needle;

    private KMPNeedle(byte[] needle) {
        Objects.requireNonNull(needle);
        this.needle = needle;
        this.jumpTable = KMPNeedle.createJumpTable(needle);
    }

    private static int[] createJumpTable(byte[] needle) {
        int i;
        int[] jumpTable = new int[needle.length + 1];
        int j = 0;
        for (i = 1; i < needle.length; ++i) {
            while (j > 0 && needle[j] != needle[i]) {
                j = jumpTable[j];
            }
            if (needle[j] == needle[i]) {
                // empty if block
            }
            jumpTable[i + 1] = ++j;
        }
        for (i = 1; i < jumpTable.length; ++i) {
            if (jumpTable[i] == 0) continue;
            return jumpTable;
        }
        return null;
    }

    public int searchInto(ReadableBuffer haystack, int start, int end) {
        int needleLength;
        if (end < 0 || start < 0 || end < start) {
            return -1;
        }
        int length = end - start;
        int j = 0;
        int remainingNeedle = needleLength = this.needle.length;
        for (int i = 0; i < length; ++i) {
            int remainingHayStack = length - i;
            if (remainingNeedle > remainingHayStack) {
                return -1;
            }
            int index = start + i;
            byte value = haystack.get(index);
            while (j > 0 && this.needle[j] != value) {
                j = this.jumpTable == null ? 0 : this.jumpTable[j];
                remainingNeedle = needleLength - j;
            }
            if (this.needle[j] == value) {
                ++j;
                assert (--remainingNeedle >= 0);
            }
            if (j != needleLength) continue;
            int startMatch = index - needleLength + 1;
            return startMatch;
        }
        return -1;
    }

    public static KMPNeedle of(byte[] needle) {
        return new KMPNeedle(needle);
    }
}

