/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationQueueConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationGenericConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationQueuePolicyManager;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationQueuePolicyManager
extends FederationQueuePolicyManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final AMQPFederation federation;
    protected final AMQPFederationConsumerConfiguration configuration;

    public AMQPFederationQueuePolicyManager(AMQPFederation federation, FederationReceiveFromQueuePolicy queuePolicy) throws ActiveMQException {
        super(federation, queuePolicy);
        this.federation = federation;
        this.configuration = new AMQPFederationConsumerConfiguration(federation, this.policy.getProperties());
    }

    @Override
    protected FederationConsumerInfo createConsumerInfo(ServerConsumer consumer) {
        Queue queue = consumer.getQueue();
        String queueName = queue.getName().toString();
        String address = queue.getAddress().toString();
        int priority = this.configuration.isIgnoreSubscriptionPriorities() ? ActiveMQDefaultConfiguration.getDefaultConsumerPriority() + this.policy.getPriorityAjustment() : consumer.getPriority() + this.policy.getPriorityAjustment();
        String filterString = AMQPFederationQueuePolicyManager.selectFilter(queue.getFilter(), this.configuration.isIgnoreSubscriptionFilters() ? null : consumer.getFilter());
        return new FederationGenericConsumerInfo(FederationConsumerInfo.Role.QUEUE_CONSUMER, address, queueName, queue.getRoutingType(), filterString, CompositeAddress.toFullyQualified((String)address, (String)queueName), priority);
    }

    @Override
    protected FederationConsumerInternal createFederationConsumer(FederationConsumerInfo consumerInfo) {
        Objects.requireNonNull(consumerInfo, "Federation Queue consumer information object was null");
        if (logger.isTraceEnabled()) {
            logger.trace("AMQP Federation {} creating queue consumer: {} for policy: {}", new Object[]{this.federation.getName(), consumerInfo, this.policy.getPolicyName()});
        }
        return new AMQPFederationQueueConsumer(this.federation, this.configuration, this.federation.getSessionContext(), consumerInfo, this.policy);
    }

    @Override
    protected void signalBeforeCreateFederationConsumer(FederationConsumerInfo info) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).beforeCreateFederationConsumer(info);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("beforeCreateFederationConsumer", (Throwable)t);
        }
    }

    @Override
    protected void signalAfterCreateFederationConsumer(FederationConsumer consumer) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).afterCreateFederationConsumer(consumer);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("afterCreateFederationConsumer", (Throwable)t);
        }
    }

    @Override
    protected void signalBeforeCloseFederationConsumer(FederationConsumer consumer) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).beforeCloseFederationConsumer(consumer);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("beforeCloseFederationConsumer", (Throwable)t);
        }
    }

    @Override
    protected void signalAfterCloseFederationConsumer(FederationConsumer consumer) {
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin) {
                    ((ActiveMQServerAMQPFederationPlugin)plugin).afterCloseFederationConsumer(consumer);
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("afterCloseFederationConsumer", (Throwable)t);
        }
    }

    @Override
    protected final boolean isPluginBlockingFederationConsumerCreate(Queue queue) {
        AtomicBoolean canCreate = new AtomicBoolean(true);
        try {
            this.server.callBrokerAMQPFederationPlugins(plugin -> {
                if (plugin instanceof ActiveMQServerAMQPFederationPlugin && canCreate.get()) {
                    canCreate.set(((ActiveMQServerAMQPFederationPlugin)plugin).shouldCreateFederationConsumerForQueue(queue));
                }
            });
        }
        catch (ActiveMQException t) {
            ActiveMQServerLogger.LOGGER.federationPluginExecutionError("shouldCreateFederationConsumerForQueue", (Throwable)t);
        }
        return !canCreate.get();
    }

    private static String selectFilter(Filter queueFilter, Filter consumerFilter) {
        if (consumerFilter != null) {
            return consumerFilter.getFilterString().toString();
        }
        return queueFilter != null ? queueFilter.getFilterString().toString() : null;
    }
}

