/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import io.netty.util.collection.LongObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.collections.AbstractHashMapPersister;
import org.apache.activemq.artemis.core.journal.collections.JournalHashMap;
import org.apache.activemq.artemis.core.journal.collections.JournalHashMapProvider;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.AckRetry;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerTarget;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AckManagerProvider;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceIDSupplier;
import org.apache.activemq.artemis.utils.collections.NodeStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckManager
implements ActiveMQComponent {
    private static final short MIN_QUEUE_ATTEMPTS = Short.parseShort(System.getProperty(AckRetry.class.getName() + ".MIN_QUEUE_ATTEMPTS", "5"));
    private static final short MAX_PAGE_ATTEMPTS = Short.parseShort(System.getProperty(AckRetry.class.getName() + ".MAX_PAGE_ATTEMPT", "2"));
    public static final int RETRY_DELAY = Integer.parseInt(System.getProperty(AckRetry.class.getName() + ".RETRY_DELAY", "100"));
    private static DisabledAckMirrorController disabledAckMirrorController = new DisabledAckMirrorController();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final Journal journal;
    final LongSupplier sequenceGenerator;
    final JournalHashMapProvider<AckRetry, AckRetry, Queue> journalHashMapProvider;
    final ActiveMQServer server;
    final ReferenceIDSupplier referenceIDSupplier;
    final IOCriticalErrorListener ioCriticalErrorListener;
    volatile MultiStepProgress progress;
    ActiveMQScheduledComponent scheduledComponent;

    public AckManager(ActiveMQServer server) {
        this.server = server;
        this.ioCriticalErrorListener = server.getIoCriticalErrorListener();
        this.journal = server.getStorageManager().getMessageJournal();
        this.sequenceGenerator = () -> ((StorageManager)server.getStorageManager()).generateID();
        this.journalHashMapProvider = new JournalHashMapProvider(this.sequenceGenerator, this.journal, (AbstractHashMapPersister)AckRetry.getPersister(), 53, OperationContextImpl::getContext, arg_0 -> ((PostOffice)server.getPostOffice()).findQueue(arg_0), server.getIoCriticalErrorListener());
        this.referenceIDSupplier = new ReferenceIDSupplier(server);
    }

    public void reload(RecordInfo recordInfo) {
        this.journalHashMapProvider.reload(recordInfo);
    }

    public synchronized void stop() {
        if (this.scheduledComponent != null) {
            this.scheduledComponent.stop();
            this.scheduledComponent = null;
        }
        AckManagerProvider.remove(this.server);
        logger.debug("Stopping ackmanager on server {}", (Object)this.server);
    }

    public synchronized boolean isStarted() {
        return this.scheduledComponent != null && this.scheduledComponent.isStarted();
    }

    public synchronized void start() {
        logger.debug("Starting ACKManager on {} with period = {}", (Object)this.server, (Object)RETRY_DELAY);
        if (!this.isStarted()) {
            this.scheduledComponent = new ActiveMQScheduledComponent(this.server.getScheduledPool(), (Executor)this.server.getExecutorFactory().getExecutor(), RETRY_DELAY, RETRY_DELAY, TimeUnit.MILLISECONDS, true){

                public void run() {
                    AckManager.this.beginRetry();
                }
            };
            this.scheduledComponent.start();
            this.scheduledComponent.delay();
        } else {
            logger.debug("Starting ignored on server {}", (Object)this.server);
        }
    }

    public void beginRetry() {
        logger.trace("being retry server {}", (Object)this.server);
        if (this.initRetry()) {
            logger.trace("Starting process to retry, server={}", (Object)this.server);
            this.progress.nextStep();
        } else {
            logger.trace("Retry already happened");
        }
    }

    public void endRetry() {
        logger.trace("Retry done on server {}", (Object)this.server);
        this.progress = null;
        if (!this.sortRetries().isEmpty()) {
            this.scheduledComponent.delay();
        }
    }

    public boolean initRetry() {
        if (this.progress != null) {
            logger.trace("Retry already in progress, we will wait next time, server={}", (Object)this.server);
            return false;
        }
        HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> retries = this.sortRetries();
        if (retries.isEmpty()) {
            logger.trace("Nothing to retry!, server={}", (Object)this.server);
            return false;
        }
        this.progress = new MultiStepProgress(this.sortRetries());
        return true;
    }

    public HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> sortRetries() {
        HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> retriesByAddress = new HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>>();
        for (JournalHashMap ackRetries : this.journalHashMapProvider.getMaps()) {
            Queue queue;
            if (ackRetries.isEmpty() || (queue = (Queue)ackRetries.getContext()) == null) continue;
            SimpleString address = queue.getAddress();
            LongObjectHashMap queueRetriesOnAddress = retriesByAddress.get(address);
            if (queueRetriesOnAddress == null) {
                queueRetriesOnAddress = new LongObjectHashMap();
                retriesByAddress.put(address, (LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>)queueRetriesOnAddress);
            }
            queueRetriesOnAddress.put(queue.getID(), (Object)ackRetries);
        }
        return retriesByAddress;
    }

    private boolean isEmpty(LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> queuesToRetry) {
        AtomicBoolean empty = new AtomicBoolean(true);
        queuesToRetry.forEach((id, journalHashMap) -> {
            if (!journalHashMap.isEmpty()) {
                empty.set(false);
            }
        });
        return empty.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryAddress(SimpleString address, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> queuesToRetry) {
        MirrorController previousController = AMQPMirrorControllerTarget.getControllerInUse();
        boolean retriedPaging = false;
        logger.debug("retrying address {} on server {}", (Object)address, (Object)this.server);
        try {
            AMQPMirrorControllerTarget.setControllerInUse(disabledAckMirrorController);
            if (this.checkRetriesAndPaging(queuesToRetry)) {
                logger.debug("scanning paging for {}", (Object)address);
                AckRetry key = new AckRetry();
                PagingStore store = this.server.getPagingManager().getPageStore(address);
                for (long pageId = store.getFirstPage(); pageId <= store.getCurrentWritingPage(); ++pageId) {
                    if (this.isEmpty(queuesToRetry)) {
                        logger.trace("Retry stopped while reading page {} on address {} as the outcome is now empty, server={}", new Object[]{pageId, address, this.server});
                        break;
                    }
                    Page page = store.usePage(pageId, true, false);
                    if (page == null) continue;
                    try {
                        if (!this.retryPage(queuesToRetry, page, key)) continue;
                        retriedPaging = true;
                        continue;
                    }
                    finally {
                        page.usageDown();
                    }
                }
                this.validateExpiredSet(queuesToRetry);
            } else {
                logger.debug("Page Scan not required for address {}", (Object)address);
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        finally {
            AMQPMirrorControllerTarget.setControllerInUse(previousController);
        }
        return retriedPaging;
    }

    private void validateExpiredSet(LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> queuesToRetry) {
        queuesToRetry.forEach(this::validateExpireSet);
    }

    private void validateExpireSet(long queueID, JournalHashMap<AckRetry, AckRetry, Queue> retries) {
        for (AckRetry retry : retries.valuesCopy()) {
            if (retry.getQueueAttempts() < MIN_QUEUE_ATTEMPTS) continue;
            if (retry.attemptedPage() >= MAX_PAGE_ATTEMPTS) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Retried {} {} times, giving up on the entry now", (Object)retry, (Object)retry.getPageAttempts());
                }
                retries.remove((Object)retry);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Retry {} attempted {} times on paging", (Object)retry, (Object)retry.getPageAttempts());
        }
    }

    private boolean retryPage(LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> queuesToRetry, Page page, AckRetry key) throws Exception {
        AtomicBoolean retriedPaging;
        block2: {
            retriedPaging = new AtomicBoolean(false);
            TransactionImpl transaction = new TransactionImpl(this.server.getStorageManager()).setAsync(true);
            page.getMessages().forEach(pagedMessage -> {
                for (int i = 0; i < pagedMessage.getQueueIDs().length; ++i) {
                    long queueID = pagedMessage.getQueueIDs()[i];
                    JournalHashMap retries = (JournalHashMap)queuesToRetry.get(queueID);
                    if (retries != null) {
                        AckRetry foundRetry;
                        block6: {
                            Queue queue;
                            String serverID = this.referenceIDSupplier.getServerID(pagedMessage.getMessage());
                            if (serverID == null) {
                                serverID = this.referenceIDSupplier.getDefaultNodeID();
                            }
                            long id = this.referenceIDSupplier.getID(pagedMessage.getMessage());
                            logger.debug("Looking for retry on serverID={}, id={} on server={}", new Object[]{serverID, id, this.server});
                            key.setNodeID(serverID).setMessageID(id);
                            foundRetry = (AckRetry)retries.get((Object)key);
                            if (foundRetry == null || foundRetry.getQueueAttempts() <= MIN_QUEUE_ATTEMPTS || (queue = (Queue)retries.getContext()) == null) continue;
                            PageSubscription subscription = queue.getPageSubscription();
                            if (!subscription.isAcked(pagedMessage)) {
                                PagedReference reference = ((Queue)retries.getContext()).getPagingStore().getCursorProvider().newReference(pagedMessage, subscription);
                                try {
                                    subscription.ackTx((Transaction)transaction, reference);
                                    retriedPaging.set(true);
                                }
                                catch (Exception e) {
                                    logger.warn(e.getMessage(), (Throwable)e);
                                    if (this.ioCriticalErrorListener == null) break block6;
                                    this.ioCriticalErrorListener.onIOException((Throwable)e, e.getMessage(), null);
                                }
                            }
                        }
                        retries.remove((Object)foundRetry, transaction.getID());
                        transaction.setContainsPersistent();
                        logger.debug("retry found = {} for message={} on queue", (Object)foundRetry, pagedMessage);
                        continue;
                    }
                    logger.trace("Retry key={} not found server={}", (Object)key, (Object)this.server);
                }
            });
            try {
                transaction.commit();
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                if (this.ioCriticalErrorListener == null) break block2;
                this.ioCriticalErrorListener.onIOException((Throwable)e, e.getMessage(), null);
            }
        }
        return retriedPaging.get();
    }

    private boolean checkRetriesAndPaging(LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>> queuesToRetry) {
        boolean needScanOnPaging = false;
        for (Map.Entry entry : queuesToRetry.entrySet()) {
            JournalHashMap queueRetries = (JournalHashMap)entry.getValue();
            Queue queue = (Queue)queueRetries.getContext();
            for (AckRetry retry : queueRetries.valuesCopy()) {
                if (this.ack(retry.getNodeID(), queue, retry.getMessageID(), retry.getReason(), false)) {
                    logger.debug("Removing retry {} as the retry went ok", (Object)retry);
                    queueRetries.remove((Object)retry);
                    continue;
                }
                short retried = retry.attemptedQueue();
                if (logger.isDebugEnabled()) {
                    logger.debug("retry {} attempted {} times on the queue", (Object)retry, (Object)retried);
                }
                if (retried < MIN_QUEUE_ATTEMPTS) continue;
                needScanOnPaging = true;
            }
        }
        return needScanOnPaging;
    }

    public synchronized void addRetry(String nodeID, Queue queue, long messageID, AckReason reason) {
        if (nodeID == null) {
            nodeID = this.referenceIDSupplier.getDefaultNodeID();
        }
        AckRetry retry = new AckRetry(nodeID, messageID, reason);
        this.journalHashMapProvider.getMap(queue.getID().longValue(), (Object)queue).put((Object)retry, (Object)retry);
        if (this.scheduledComponent != null) {
            this.scheduledComponent.delay();
        }
    }

    public boolean ack(String nodeID, Queue targetQueue, long messageID, AckReason reason, boolean allowRetry) {
        MessageReference reference;
        if (logger.isTraceEnabled()) {
            logger.trace("performAck (nodeID={}, messageID={}), targetQueue={}, allowRetry={})", new Object[]{nodeID, messageID, targetQueue.getName(), allowRetry});
        }
        if ((reference = targetQueue.removeWithSuppliedID(nodeID, messageID, (NodeStoreFactory)this.referenceIDSupplier)) == null) {
            logger.debug("Could not find retry on reference nodeID={} (while localID={}), messageID={} on queue {}, server={}", new Object[]{nodeID, this.referenceIDSupplier.getDefaultNodeID(), messageID, targetQueue.getName(), this.server});
            if (allowRetry) {
                this.addRetry(nodeID, targetQueue, messageID, reason);
            }
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ack {} worked well for messageID={} nodeID={} queue={}, targetQueue={}", new Object[]{this.server, messageID, nodeID, reference.getQueue(), targetQueue});
        }
        this.doACK(targetQueue, reference, reason);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doACK(Queue targetQueue, MessageReference reference, AckReason reason) {
        try {
            switch (reason) {
                case EXPIRED: {
                    targetQueue.expire(reference, null, false);
                    return;
                }
                default: {
                    TransactionImpl transaction = new TransactionImpl(this.server.getStorageManager()).setAsync(true);
                    targetQueue.acknowledge((Transaction)transaction, reference, reason, null, false);
                    transaction.commit();
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            targetQueue.deliverAsync();
        }
    }

    private static class DisabledAckMirrorController
    implements MirrorController {
        private DisabledAckMirrorController() {
        }

        public boolean isRetryACK() {
            return true;
        }

        public void addAddress(AddressInfo addressInfo) throws Exception {
        }

        public void deleteAddress(AddressInfo addressInfo) throws Exception {
        }

        public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        }

        public void deleteQueue(SimpleString addressName, SimpleString queueName) throws Exception {
        }

        public void sendMessage(Transaction tx, Message message, RoutingContext context) {
        }

        public void postAcknowledge(MessageReference ref, AckReason reason) throws Exception {
        }

        public void preAcknowledge(Transaction tx, MessageReference ref, AckReason reason) throws Exception {
        }

        public String getRemoteMirrorId() {
            return null;
        }
    }

    class MultiStepProgress {
        HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> retryList;
        Iterator<Map.Entry<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>>> retryIterator;
        boolean retriedPaging = false;

        MultiStepProgress(HashMap<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> retryList) {
            this.retryList = retryList;
            this.retryIterator = retryList.entrySet().iterator();
        }

        public void nextStep() {
            try {
                if (!this.retryIterator.hasNext()) {
                    if (this.retriedPaging) {
                        logger.debug("Retried acks on paging, better to rebuild the page counters");
                        AckManager.this.server.getPagingManager().rebuildCounters(null);
                    }
                    logger.trace("Iterator is done on retry, server={}", (Object)AckManager.this.server);
                    AckManager.this.endRetry();
                } else {
                    Map.Entry<SimpleString, LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>> entry = this.retryIterator.next();
                    entry.getValue().values().forEach(this::deliveryAsync);
                    PagingStore pagingStore = AckManager.this.server.getPagingManager().getPageStore(entry.getKey());
                    pagingStore.execute(() -> {
                        if (AckManager.this.retryAddress((SimpleString)entry.getKey(), (LongObjectHashMap<JournalHashMap<AckRetry, AckRetry, Queue>>)((LongObjectHashMap)entry.getValue()))) {
                            this.retriedPaging = true;
                        }
                        this.nextStep();
                    });
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
                AckManager.this.endRetry();
            }
        }

        private void deliveryAsync(JournalHashMap<AckRetry, AckRetry, Queue> map) {
            Queue queue = (Queue)map.getContext();
            if (queue != null) {
                queue.deliverAsync();
            }
        }
    }
}

