/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.ConversionException;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMessageWrapper;
import org.apache.activemq.artemis.reader.BytesMessageUtil;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;

public class CoreBytesMessageWrapper
extends CoreMessageWrapper {
    public CoreBytesMessageWrapper(ICoreMessage message) {
        super(message);
    }

    protected static Binary getBinaryFromMessageBody(CoreBytesMessageWrapper message) {
        byte[] data = new byte[(int)message.getBodyLength()];
        message.readBytes(data);
        message.reset();
        return new Binary(data);
    }

    @Override
    public Section createAMQPSection(Map<Symbol, Object> maMap, Properties properties) {
        short orignalEncoding = this.getOrignalEncoding();
        Binary payload = CoreBytesMessageWrapper.getBinaryFromMessageBody(this);
        maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)3);
        if (payload == null) {
            payload = AMQPMessageSupport.EMPTY_BINARY;
        }
        switch (orignalEncoding) {
            case 1: {
                return null;
            }
            case 6: {
                return new AmqpValue((Object)payload);
            }
        }
        return new Data(payload);
    }

    public long getBodyLength() {
        return this.message.getBodyBufferSize();
    }

    public boolean readBoolean() {
        return BytesMessageUtil.bytesReadBoolean((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public byte readByte() {
        return BytesMessageUtil.bytesReadByte((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public int readUnsignedByte() {
        return BytesMessageUtil.bytesReadUnsignedByte((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public short readShort() {
        return BytesMessageUtil.bytesReadShort((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public int readUnsignedShort() {
        return BytesMessageUtil.bytesReadUnsignedShort((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public char readChar() {
        return BytesMessageUtil.bytesReadChar((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public int readInt() {
        return BytesMessageUtil.bytesReadInt((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public long readLong() {
        return BytesMessageUtil.bytesReadLong((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public float readFloat() {
        return BytesMessageUtil.bytesReadFloat((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public double readDouble() {
        return BytesMessageUtil.bytesReadDouble((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public String readUTF() {
        return BytesMessageUtil.bytesReadUTF((ActiveMQBuffer)this.getReadBodyBuffer());
    }

    public int readBytes(byte[] value) {
        return BytesMessageUtil.bytesReadBytes((ActiveMQBuffer)this.getReadBodyBuffer(), (byte[])value);
    }

    public int readBytes(byte[] value, int length) {
        return BytesMessageUtil.bytesReadBytes((ActiveMQBuffer)this.getReadBodyBuffer(), (byte[])value, (int)length);
    }

    public void writeBoolean(boolean value) {
        BytesMessageUtil.bytesWriteBoolean((ActiveMQBuffer)this.getWriteBodyBuffer(), (boolean)value);
    }

    public void writeByte(byte value) {
        BytesMessageUtil.bytesWriteByte((ActiveMQBuffer)this.getWriteBodyBuffer(), (byte)value);
    }

    public void writeShort(short value) {
        BytesMessageUtil.bytesWriteShort((ActiveMQBuffer)this.getWriteBodyBuffer(), (short)value);
    }

    public void writeChar(char value) {
        BytesMessageUtil.bytesWriteChar((ActiveMQBuffer)this.getWriteBodyBuffer(), (char)value);
    }

    public void writeInt(int value) {
        BytesMessageUtil.bytesWriteInt((ActiveMQBuffer)this.getWriteBodyBuffer(), (int)value);
    }

    public void writeLong(long value) {
        BytesMessageUtil.bytesWriteLong((ActiveMQBuffer)this.getWriteBodyBuffer(), (long)value);
    }

    public void writeFloat(float value) {
        BytesMessageUtil.bytesWriteFloat((ActiveMQBuffer)this.getWriteBodyBuffer(), (float)value);
    }

    public void writeDouble(double value) {
        BytesMessageUtil.bytesWriteDouble((ActiveMQBuffer)this.getWriteBodyBuffer(), (double)value);
    }

    public void writeUTF(String value) {
        BytesMessageUtil.bytesWriteUTF((ActiveMQBuffer)this.getWriteBodyBuffer(), (String)value);
    }

    public void writeBytes(byte[] value) {
        BytesMessageUtil.bytesWriteBytes((ActiveMQBuffer)this.getWriteBodyBuffer(), (byte[])value);
    }

    public void writeBytes(byte[] value, int offset, int length) {
        BytesMessageUtil.bytesWriteBytes((ActiveMQBuffer)this.getWriteBodyBuffer(), (byte[])value, (int)offset, (int)length);
    }

    public void writeObject(Object value) throws ConversionException {
        if (!BytesMessageUtil.bytesWriteObject((ActiveMQBuffer)this.getWriteBodyBuffer(), (Object)value)) {
            throw new ConversionException("Can't make conversion of " + value + " to any known type");
        }
    }

    @Override
    public void encode() {
        super.encode();
        this.getBodyLength();
    }

    @Override
    public void decode() {
        super.decode();
    }

    public void reset() {
        if (!this.message.isLargeMessage()) {
            BytesMessageUtil.bytesMessageReset((ActiveMQBuffer)this.getReadBodyBuffer());
            BytesMessageUtil.bytesMessageReset((ActiveMQBuffer)this.getWriteBodyBuffer());
        }
    }
}

