/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation.internal;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationAddressEntry;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationPolicyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FederationAddressPolicyManager
extends FederationPolicyManager
implements ActiveMQServerBindingPlugin,
ActiveMQServerAddressPlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final FederationReceiveFromAddressPolicy policy;
    protected final Map<String, FederationAddressEntry> demandTracking = new HashMap<String, FederationAddressEntry>();
    protected final Map<DivertBinding, Set<QueueBinding>> divertsTracking = new HashMap<DivertBinding, Set<QueueBinding>>();

    public FederationAddressPolicyManager(FederationInternal federation, FederationReceiveFromAddressPolicy addressPolicy) throws ActiveMQException {
        super(federation);
        Objects.requireNonNull(addressPolicy, "The Address match policy cannot be null");
        this.policy = addressPolicy;
    }

    @Override
    public FederationReceiveFromAddressPolicy getPolicy() {
        return this.policy;
    }

    public synchronized void start() {
        if (!this.federation.isStarted()) {
            throw new IllegalStateException("Cannot start a federation policy manager when the federation is stopped.");
        }
        if (!this.started) {
            this.started = true;
            this.handlePolicyManagerStarted(this.policy);
            this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)this);
            this.scanAllBindings();
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            this.server.unRegisterBrokerPlugin((ActiveMQServerBasePlugin)this);
            this.demandTracking.forEach((k, v) -> {
                if (v.hasConsumer()) {
                    v.getConsumer().close();
                }
            });
            this.demandTracking.clear();
            this.divertsTracking.clear();
        }
    }

    public synchronized void afterRemoveAddress(SimpleString address, AddressInfo addressInfo) throws ActiveMQException {
        FederationAddressEntry entry;
        if (this.started && (entry = this.demandTracking.remove(address.toString())) != null && entry.hasConsumer()) {
            entry.getConsumer().close();
        }
    }

    public synchronized void afterRemoveBinding(Binding binding, Transaction tx, boolean deleteData) throws ActiveMQException {
        if (this.started) {
            DivertBinding divert;
            if (binding instanceof QueueBinding) {
                FederationAddressEntry entry = this.demandTracking.get(binding.getAddress().toString());
                if (entry != null) {
                    this.tryRemoveDemandOnAddress(entry, binding);
                } else if (this.policy.isEnableDivertBindings()) {
                    this.divertsTracking.entrySet().forEach(divertEntry -> {
                        String sourceAddress = ((DivertBinding)divertEntry.getKey()).getAddress().toString();
                        SimpleString forwardAddress = ((DivertBinding)divertEntry.getKey()).getDivert().getForwardAddress();
                        if (FederationAddressPolicyManager.isAddressInDivertForwards(binding.getAddress(), forwardAddress)) {
                            ((Set)divertEntry.getValue()).remove(binding);
                            if (((Set)divertEntry.getValue()).isEmpty()) {
                                this.tryRemoveDemandOnAddress(this.demandTracking.get(sourceAddress), (Binding)divertEntry.getKey());
                            }
                        }
                    });
                }
            } else if (this.policy.isEnableDivertBindings() && binding instanceof DivertBinding && this.divertsTracking.remove(divert = (DivertBinding)binding) != null) {
                try {
                    this.tryRemoveDemandOnAddress(this.demandTracking.get(divert.getAddress().toString()), (Binding)divert);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.federationBindingsLookupError(divert.getDivert().getForwardAddress(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void tryRemoveDemandOnAddress(FederationAddressEntry entry, Binding binding) {
        if (entry != null) {
            entry.removeDemand(binding);
            logger.trace("Reducing demand on federated address {}, remaining demand? {}", (Object)entry.getAddress(), (Object)entry.hasDemand());
            if (!entry.hasDemand() && entry.hasConsumer()) {
                FederationConsumerInternal federationConsuner = entry.getConsumer();
                try {
                    this.signalBeforeCloseFederationConsumer(federationConsuner);
                    federationConsuner.close();
                    this.signalAfterCloseFederationConsumer(federationConsuner);
                }
                finally {
                    this.demandTracking.remove(entry.getAddress());
                }
            }
        }
    }

    protected final void scanAllBindings() {
        this.server.getPostOffice().getAllBindings().filter(binding -> binding instanceof QueueBinding || this.policy.isEnableDivertBindings() && binding instanceof DivertBinding).forEach(binding -> this.afterAddBinding((Binding)binding));
    }

    public synchronized void afterAddAddress(AddressInfo addressInfo, boolean reload) {
        if (this.started && this.policy.isEnableDivertBindings() && this.policy.test(addressInfo)) {
            try {
                this.server.getPostOffice().getDirectBindings(addressInfo.getName()).stream().filter(binding -> binding instanceof DivertBinding).forEach(this::checkBindingForMatch);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationBindingsLookupError(addressInfo.getName(), (Throwable)e);
            }
        }
    }

    public synchronized void afterAddBinding(Binding binding) {
        if (this.started) {
            this.checkBindingForMatch(binding);
        }
    }

    protected final void checkBindingForMatch(Binding binding) {
        if (binding instanceof QueueBinding) {
            QueueBinding queueBinding = (QueueBinding)binding;
            AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(binding.getAddress());
            if (this.testIfAddressMatchesPolicy(addressInfo)) {
                if (this.isPluginBlockingFederationConsumerCreate(queueBinding.getQueue())) {
                    return;
                }
                this.createOrUpdateFederatedAddressConsumerForBinding(addressInfo, (Binding)queueBinding);
            } else {
                this.reactIfQueueBindingMatchesAnyDivertTarget(queueBinding);
            }
        } else if (binding instanceof DivertBinding) {
            this.reactIfAnyQueueBindingMatchesDivertTarget((DivertBinding)binding);
        }
    }

    protected final void reactIfAnyQueueBindingMatchesDivertTarget(DivertBinding divertBinding) {
        if (!this.policy.isEnableDivertBindings()) {
            return;
        }
        AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
        if (!this.testIfAddressMatchesPolicy(addressInfo)) {
            return;
        }
        if (this.divertsTracking.get(divertBinding) == null) {
            HashSet matchingQueues = new HashSet();
            this.divertsTracking.put(divertBinding, matchingQueues);
            SimpleString forwardAddress = divertBinding.getDivert().getForwardAddress();
            SimpleString[] forwardAddresses = forwardAddress.split(',');
            try {
                for (SimpleString forward : forwardAddresses) {
                    this.server.getPostOffice().getBindingsForAddress(forward).getBindings().stream().filter(b -> b instanceof QueueBinding).map(b -> (QueueBinding)b).forEach(queueBinding -> {
                        if (this.isPluginBlockingFederationConsumerCreate(divertBinding.getDivert(), queueBinding.getQueue())) {
                            return;
                        }
                        if (this.isPluginBlockingFederationConsumerCreate(queueBinding.getQueue())) {
                            return;
                        }
                        matchingQueues.add(queueBinding);
                        this.createOrUpdateFederatedAddressConsumerForBinding(addressInfo, (Binding)divertBinding);
                    });
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.federationBindingsLookupError(forwardAddress, (Throwable)e);
            }
        }
    }

    protected final void reactIfQueueBindingMatchesAnyDivertTarget(QueueBinding queueBinding) {
        if (!this.policy.isEnableDivertBindings()) {
            return;
        }
        SimpleString queueAddress = queueBinding.getAddress();
        this.divertsTracking.entrySet().forEach(e -> {
            SimpleString forwardAddress = ((DivertBinding)e.getKey()).getDivert().getForwardAddress();
            DivertBinding divertBinding = (DivertBinding)e.getKey();
            if (!((Set)e.getValue()).contains(queueBinding) && FederationAddressPolicyManager.isAddressInDivertForwards(queueAddress, forwardAddress)) {
                if (this.isPluginBlockingFederationConsumerCreate(divertBinding.getDivert(), queueBinding.getQueue())) {
                    return;
                }
                if (this.isPluginBlockingFederationConsumerCreate(queueBinding.getQueue())) {
                    return;
                }
                ((Set)e.getValue()).add(queueBinding);
                AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(divertBinding.getAddress());
                this.createOrUpdateFederatedAddressConsumerForBinding(addressInfo, (Binding)divertBinding);
            }
        });
    }

    private static boolean isAddressInDivertForwards(SimpleString targetAddress, SimpleString forwardAddress) {
        SimpleString[] forwardAddresses;
        for (SimpleString forward : forwardAddresses = forwardAddress.split(',')) {
            if (!targetAddress.equals((Object)forward)) continue;
            return true;
        }
        return false;
    }

    protected final void createOrUpdateFederatedAddressConsumerForBinding(AddressInfo addressInfo, Binding binding) {
        FederationAddressEntry entry;
        logger.trace("Federation Address Policy matched on for demand on address: {} : binding: {}", (Object)addressInfo, (Object)binding);
        String addressName = addressInfo.getName().toString();
        if (this.demandTracking.containsKey(addressName)) {
            entry = this.demandTracking.get(addressName);
        } else {
            entry = new FederationAddressEntry(addressInfo);
            this.demandTracking.put(addressName, entry);
        }
        entry.addDemand(binding);
        this.tryCreateFederationConsumerForAddress(entry);
    }

    private void tryCreateFederationConsumerForAddress(FederationAddressEntry addressEntry) {
        AddressInfo addressInfo = addressEntry.getAddressInfo();
        if (addressEntry.hasDemand() && !addressEntry.hasConsumer() && !this.isPluginBlockingFederationConsumerCreate(addressInfo)) {
            logger.trace("Federation Address Policy manager creating remote consumer for address: {}", (Object)addressInfo);
            FederationConsumerInfo consumerInfo = this.createConsumerInfo(addressInfo);
            FederationConsumerInternal addressConsumer = this.createFederationConsumer(consumerInfo);
            this.signalBeforeCreateFederationConsumer(consumerInfo);
            addressConsumer.setRemoteClosedHandler(closedConsumer -> {
                FederationAddressPolicyManager federationAddressPolicyManager = this;
                synchronized (federationAddressPolicyManager) {
                    try {
                        FederationAddressEntry tracked = this.demandTracking.get(closedConsumer.getConsumerInfo().getAddress());
                        if (tracked != null) {
                            tracked.clearConsumer();
                        }
                    }
                    finally {
                        closedConsumer.close();
                    }
                }
            });
            addressEntry.setConsumer(addressConsumer);
            addressConsumer.start();
            this.signalAfterCreateFederationConsumer(addressConsumer);
        }
    }

    public synchronized void afterRemoteAddressAdded(String addressName) throws Exception {
        if (this.started && this.testIfAddressMatchesPolicy(addressName, RoutingType.MULTICAST) && this.demandTracking.containsKey(addressName)) {
            this.tryCreateFederationConsumerForAddress(this.demandTracking.get(addressName));
        }
    }

    protected boolean testIfAddressMatchesPolicy(AddressInfo addressInfo) {
        return this.policy.test(addressInfo);
    }

    protected boolean testIfAddressMatchesPolicy(String address, RoutingType type) {
        return this.policy.test(address, type);
    }

    protected abstract FederationConsumerInfo createConsumerInfo(AddressInfo var1);

    protected FederationAddressEntry createConsumerEntry(AddressInfo addressInfo) {
        return new FederationAddressEntry(addressInfo);
    }

    protected abstract boolean isPluginBlockingFederationConsumerCreate(AddressInfo var1);

    protected abstract boolean isPluginBlockingFederationConsumerCreate(Divert var1, Queue var2);

    protected abstract boolean isPluginBlockingFederationConsumerCreate(Queue var1);
}

