/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.qpid.proton.engine.Link;

public final class AMQPFederationCapabilities {
    private boolean initialized;
    private int localVersion = 1;
    private int remoteVersion = 1;
    private boolean fqqnAddressSubscriptions;

    public AMQPFederationCapabilities initialize(Link controlLink) {
        if (!this.initialized) {
            this.initialized = true;
            Map localProperties = Objects.requireNonNullElseGet(controlLink.getProperties(), () -> Collections.emptyMap());
            Map remoteProperties = Objects.requireNonNullElseGet(controlLink.getRemoteProperties(), () -> Collections.emptyMap());
            Integer local = localProperties.getOrDefault(AMQPFederationConstants.FEDERATION_VERSION, 1);
            Integer remote = remoteProperties.getOrDefault(AMQPFederationConstants.FEDERATION_VERSION, 1);
            if (!(local instanceof Integer)) {
                throw new IllegalArgumentException("Invalid value set on federation local version number: " + String.valueOf(local));
            }
            Integer localVersionNo = local;
            this.localVersion = localVersionNo;
            if (!(remote instanceof Integer)) {
                throw new IllegalArgumentException("Invalid value sent in federation remote version number: " + String.valueOf(local));
            }
            Integer remoteVersionNo = remote;
            this.remoteVersion = remoteVersionNo;
            if (this.remoteVersion >= 2) {
                this.fqqnAddressSubscriptions = true;
            }
        }
        return this;
    }

    public int getLocalVersion() {
        return this.localVersion;
    }

    public int getRemoteVersion() {
        return this.remoteVersion;
    }

    public boolean isUseFQQNAddressSubscriptions() {
        this.checkIsInitialized();
        return this.fqqnAddressSubscriptions;
    }

    private void checkIsInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot check capabilities until this instance is initialized");
        }
    }
}

