/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.IllegalStateException;
import java.util.Arrays;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.slf4j.Logger;

public class ActiveMQRALogger_impl
implements ActiveMQRALogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQRALogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void awaitingTopicQueueCreation(String destination) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ151000: awaiting topic/queue creation {}", (Object)destination);
        }
    }

    @Override
    public void attemptingReconnect(ActiveMQActivationSpec spec) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ151001: Attempting to reconnect {}", (Object)spec);
        }
    }

    @Override
    public void reconnected() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ151002: Reconnected with broker");
        }
    }

    @Override
    public void raStopped() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ151003: resource adaptor stopped");
        }
    }

    @Override
    public void instantiatingDestination(String destinationType, String destination) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ151004: Instantiating {} \"{}\" directly since UseJNDI=false.", (Object)destinationType, (Object)destination);
        }
    }

    @Override
    public void awaitingJMSServerCreation() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ151005: awaiting server availability");
        }
    }

    @Override
    public void rebalancingConnections(String event) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ151006: Cluster topology change detected. Re-balancing connections on even {}.", (Object)event);
        }
    }

    @Override
    public void resourceAdaptorStarted() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ151007: Resource adaptor started");
        }
    }

    @Override
    public void problemResettingXASession(Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152001: problem resetting xa session after failure", t);
        }
    }

    @Override
    public void unableToRollbackTX() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152002: Unable to roll local transaction back");
        }
    }

    @Override
    public void unableToResetSession(String spec, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152003: unable to reset session after failure, we will place the MDB Inflow now in setup mode for activation={}", (Object)spec, (Object)e);
        }
    }

    @Override
    public void handlingJMSFailure(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152004: Handling JMS exception failure", (Throwable)e);
        }
    }

    @Override
    public void failureInActivation(ActiveMQActivationSpec spec, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152005: Failure in broker activation {}", (Object)spec, (Object)t);
        }
    }

    @Override
    public void unableToCallAfterDelivery(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152006: Unable to call after delivery", (Throwable)e);
        }
    }

    @Override
    public void threadCouldNotFinish(String thread) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152007: Thread {} could not be finished", (Object)thread);
        }
    }

    @Override
    public void errorInterruptingHandler(String endpoint, String handler, Throwable cause) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152008: Error interrupting handler on endpoint {} handler = {}", new Object[]{endpoint, handler, cause});
        }
    }

    @Override
    public void unableToValidateProperties(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152009: Unable to validate properties", (Throwable)e);
        }
    }

    @Override
    public void unableToClearTheTransaction(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152010: Unable to clear the transaction", (Throwable)e);
        }
    }

    @Override
    public void unableToCloseFactory(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ152011: Unable to close the factory", e);
        }
    }

    @Override
    public void errorCreatingReference(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ154000: Error while creating object Reference.", (Throwable)e);
        }
    }

    @Override
    public void errorStoppingRA(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ154001: Unable to stop resource adapter.", (Throwable)e);
        }
    }

    @Override
    public void errorReconnecting(ActiveMQActivationSpec spec, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ154003: Unable to reconnect {}", (Object)spec, (Object)t);
        }
    }

    @Override
    public void errorDeliveringMessage(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ154004: Failed to deliver message", t);
        }
    }

    @Override
    public void warnDifferentConnectionfactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ153001: using different ActiveMQRAConnectionFactory");
        }
    }

    @Override
    public IllegalStateException canNotCreatedNonSharedSubscriber() {
        String returnString = "AMQ153002: Cannot create a subscriber on the durable subscription since it already has subscriber(s)";
        IllegalStateException objReturn_canNotCreatedNonSharedSubscriber = new IllegalStateException(returnString);
        ActiveMQRALogger_impl._copyStackTraceMinusOne((Throwable)objReturn_canNotCreatedNonSharedSubscriber);
        return objReturn_canNotCreatedNonSharedSubscriber;
    }

    @Override
    public void invalidAcknowledgementMode(String mode) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ153003: Unsupported acknowledgement mode {}", (Object)mode);
        }
    }

    @Override
    public void invalidNumberOfMaxSession(int value, int defaultValue) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ153004: Invalid number of session (negative) {}, defaulting to {}.", (Object)value, (Object)defaultValue);
        }
    }

    @Override
    public void unableToRetrieveDestinationName(String destinationName, String name, String calculatedDestinationName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ153005: Unable to retrieve \"{}\" from JNDI. Creating a new \"{}\" named \"{}\" to be used by the MDB.", new Object[]{destinationName, name, calculatedDestinationName});
        }
    }
}

