/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import org.apache.activemq.artemis.core.version.Version;

public class ActiveMQConnectionMetaData
implements ConnectionMetaData {
    public static final String DEFAULT_PROP_FILE_NAME = "jms-version.properties";
    private static final String JMS_VERSION_NAME;
    private static final int JMS_MAJOR_VERSION;
    private static final int JMS_MINOR_VERSION;
    private static final String ACTIVEMQ = "ActiveMQ";
    private final Version serverVersion;

    public ActiveMQConnectionMetaData(Version serverVersion) {
        this.serverVersion = serverVersion;
    }

    public String getJMSVersion() throws JMSException {
        return JMS_VERSION_NAME;
    }

    public int getJMSMajorVersion() throws JMSException {
        return JMS_MAJOR_VERSION;
    }

    public int getJMSMinorVersion() throws JMSException {
        return JMS_MINOR_VERSION;
    }

    public String getJMSProviderName() throws JMSException {
        return ACTIVEMQ;
    }

    public String getProviderVersion() throws JMSException {
        return this.serverVersion.getFullVersion();
    }

    public int getProviderMajorVersion() throws JMSException {
        return this.serverVersion.getMajorVersion();
    }

    public int getProviderMinorVersion() throws JMSException {
        return this.serverVersion.getMinorVersion();
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        Vector<String> v = new Vector<String>();
        v.add("JMSXGroupID");
        v.add("JMSXGroupSeq");
        v.add("JMSXDeliveryCount");
        return v.elements();
    }

    static {
        Properties versionProps = new Properties();
        try (InputStream in = ActiveMQConnectionMetaData.class.getClassLoader().getResourceAsStream(DEFAULT_PROP_FILE_NAME);){
            if (in != null) {
                versionProps.load(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JMS_VERSION_NAME = versionProps.getProperty("activemq.version.implementation.versionName", "2.0");
        JMS_MAJOR_VERSION = Integer.valueOf(versionProps.getProperty("activemq.version.implementation.majorVersion", "2"));
        JMS_MINOR_VERSION = Integer.valueOf(versionProps.getProperty("activemq.version.implementation.minorVersion", "0"));
    }
}

