/* This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
   and it inherits whatever license is declared at org.apache.activemq.artemis.jms.client.ActiveMQJMSClientLogger */

package org.apache.activemq.artemis.jms.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(retiredIDs={}, regexID="13[0-8][0-9]{3}", projectCode="AMQ")
public class ActiveMQJMSClientLogger_impl implements ActiveMQJMSClientLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQJMSClientLogger_impl(Logger logger) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=132000, value=\"I\'m closing a JMS connection you left open. Please make sure you close all JMS connections explicitly before letting them go out of scope! see stacktrace to find out where it was created\", level=WARN)
   @Override
   public void connectionLeftOpen(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ132000: I'm closing a JMS connection you left open. Please make sure you close all JMS connections explicitly before letting them go out of scope! see stacktrace to find out where it was created", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=132001, value=\"Unhandled exception thrown from onMessage\", level=WARN)
   @Override
   public void onMessageError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ132001: Unhandled exception thrown from onMessage", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=134000, value=\"Failed to call JMS exception listener\", level=ERROR)
   @Override
   public void errorCallingExcListener(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ134000: Failed to call JMS exception listener", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=134002, value=\"Queue Browser failed to create message {}\", level=ERROR)
   @Override
   public void errorCreatingMessage(java.lang.String messageToString, java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ134002: Queue Browser failed to create message {}", messageToString, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=134003, value=\"Message Listener failed to prepare message for receipt, message={}\", level=ERROR)
   @Override
   public void errorPreparingMessageForReceipt(java.lang.String messagetoString, java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ134003: Message Listener failed to prepare message for receipt, message={}", messagetoString, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=134004, value=\"Message Listener failed to process message\", level=ERROR)
   @Override
   public void errorProcessingMessage(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ134004: Message Listener failed to process message", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=134005, value=\"Message Listener failed to recover session\", level=ERROR)
   @Override
   public void errorRecoveringSession(java.lang.Throwable e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ134005: Message Listener failed to recover session", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=134006, value=\"Failed to call Failover listener\", level=ERROR)
   @Override
   public void errorCallingFailoverListener(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ134006: Failed to call Failover listener", e);
      }
   }

}
