/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms;

import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQQueueConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQTopicConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAQueueConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXATopicConnectionFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum JMSFactoryType {
    CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQJMSConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQJMSConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQJMSConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQJMSConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return ConnectionFactory.class;
        }
    }
    ,
    QUEUE_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQQueueConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQQueueConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQQueueConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQQueueConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return QueueConnectionFactory.class;
        }
    }
    ,
    TOPIC_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQTopicConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQTopicConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQTopicConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQTopicConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return TopicConnectionFactory.class;
        }
    }
    ,
    XA_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXAConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXAConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQXAConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQXAConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return XAConnectionFactory.class;
        }
    }
    ,
    QUEUE_XA_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXAQueueConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXAQueueConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQXAQueueConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQXAQueueConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return XAQueueConnectionFactory.class;
        }
    }
    ,
    TOPIC_XA_CF{

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXATopicConnectionFactory(true, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
            return new ActiveMQXATopicConnectionFactory(false, groupConfiguration);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... initialServers) {
            return new ActiveMQXATopicConnectionFactory(true, initialServers);
        }

        @Override
        public ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... transportConfigurations) {
            return new ActiveMQXATopicConnectionFactory(false, transportConfigurations);
        }

        @Override
        public Class connectionFactoryInterface() {
            return XATopicConnectionFactory.class;
        }
    };


    public int intValue() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case CF -> 0;
            case QUEUE_CF -> 1;
            case TOPIC_CF -> 2;
            case XA_CF -> 3;
            case QUEUE_XA_CF -> 4;
            case TOPIC_XA_CF -> 5;
        };
    }

    public static JMSFactoryType valueOf(int val) {
        return switch (val) {
            case 0 -> CF;
            case 1 -> QUEUE_CF;
            case 2 -> TOPIC_CF;
            case 3 -> XA_CF;
            case 4 -> QUEUE_XA_CF;
            case 5 -> TOPIC_XA_CF;
            default -> XA_CF;
        };
    }

    public abstract ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration var1);

    public abstract ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration var1);

    public abstract ActiveMQConnectionFactory createConnectionFactoryWithHA(TransportConfiguration ... var1);

    public abstract ActiveMQConnectionFactory createConnectionFactoryWithoutHA(TransportConfiguration ... var1);

    public abstract Class connectionFactoryInterface();
}

