/** This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
    and it inherits whatever license is declared at org.apache.activemq.artemis.jms.bridge.ActiveMQJMSBridgeLogger */

package org.apache.activemq.artemis.jms.bridge;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(regexID="34[0-9]{4}", projectCode="AMQ")
public class ActiveMQJMSBridgeLogger_impl implements ActiveMQJMSBridgeLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQJMSBridgeLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=341000, value=\"Failed to set up JMS bridge {}} connections. Most probably the source or target servers are unavailable. Will retry after a pause of {} ms\", level=INFO)
   @Override
   public void failedToSetUpBridge(java.lang.String bridgeName, long failureRetryInterval) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ341000: Failed to set up JMS bridge {}} connections. Most probably the source or target servers are unavailable. Will retry after a pause of {} ms", bridgeName, failureRetryInterval);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=341001, value=\"JMS Bridge {} succeeded in reconnecting to servers\", level=INFO)
   @Override
   public void bridgeReconnected(java.lang.String bridgeName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ341001: JMS Bridge {} succeeded in reconnecting to servers", bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=341002, value=\"JMSBridge {} succeeded in connecting to servers\", level=INFO)
   @Override
   public void bridgeConnected(java.lang.String bridgeName) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ341002: JMSBridge {} succeeded in connecting to servers", bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342000, value=\"Attempt to start JMS Bridge {}, but is already started\", level=WARN)
   @Override
   public void errorBridgeAlreadyStarted(java.lang.String bridgeName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342000: Attempt to start JMS Bridge {}, but is already started", bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342001, value=\"Failed to start JMS Bridge {}\", level=WARN)
   @Override
   public void errorStartingBridge(java.lang.String bridgeName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342001: Failed to start JMS Bridge {}", bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342002, value=\"Failed to unregisted JMS Bridge {} - {}\", level=WARN)
   @Override
   public void errorUnregisteringBridge(javax.management.ObjectName objectName, java.lang.String bridgeName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342002: Failed to unregisted JMS Bridge {} - {}", objectName, bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342003, value=\"JMS Bridge {} unable to set up connections, bridge will be stopped\", level=WARN)
   @Override
   public void errorConnectingBridge(java.lang.String bridgeName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342003: JMS Bridge {} unable to set up connections, bridge will be stopped", bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342004, value=\"JMS Bridge {}, will retry after a pause of {} ms\", level=WARN)
   @Override
   public void bridgeRetry(java.lang.String bridgeName, long failureRetryInterval) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342004: JMS Bridge {}, will retry after a pause of {} ms", bridgeName, failureRetryInterval);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342005, value=\"JMS Bridge {} unable to set up connections, bridge will not be started\", level=WARN)
   @Override
   public void bridgeNotStarted(java.lang.String bridgeName) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342005: JMS Bridge {} unable to set up connections, bridge will not be started", bridgeName);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342006, value=\"JMS Bridge {}, detected failure on bridge connection\", level=WARN)
   @Override
   public void bridgeFailure(java.lang.String bridgeName, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342006: JMS Bridge {}, detected failure on bridge connection", bridgeName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342009, value=\"JMS Bridge {} failed to send + acknowledge batch, closing JMS objects\", level=WARN)
   @Override
   public void bridgeAckError(java.lang.String bridgeName, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342009: JMS Bridge {} failed to send + acknowledge batch, closing JMS objects", bridgeName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342010, value=\"Failed to connect JMS Bridge {}\", level=WARN)
   @Override
   public void bridgeConnectError(java.lang.String bridgeName, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342010: Failed to connect JMS Bridge {}", bridgeName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=342011, value=\"Transaction rolled back, retrying TX\", level=WARN)
   @Override
   public void transactionRolledBack(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ342011: Transaction rolled back, retrying TX", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=344001, value=\"JMS Bridge {}, failed to start source connection\", level=ERROR)
   @Override
   public void jmsBridgeSrcConnectError(java.lang.String bridgeName, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ344001: JMS Bridge {}, failed to start source connection", bridgeName, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=344002, value=\"Failed to start JMS Bridge {}.  QoS Mode: {} requires a Transaction Manager, none found\", level=ERROR)
   @Override
   public void jmsBridgeTransactionManagerMissing(java.lang.String bridgeName, org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode qosMode) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ344002: Failed to start JMS Bridge {}.  QoS Mode: {} requires a Transaction Manager, none found", bridgeName, qosMode);
      }
   }

}
