/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.junit.AbstractActiveMQClientDelegate;
import org.apache.activemq.artemis.junit.ActiveMQConsumerDelegate;
import org.apache.activemq.artemis.junit.ActiveMQConsumerOperations;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ActiveMQConsumerExtension
implements BeforeAllCallback,
AfterAllCallback,
ActiveMQConsumerOperations {
    private final ActiveMQConsumerDelegate activeMQConsumerDelegate;

    public ActiveMQConsumerExtension(String url, String queueName) {
        this.activeMQConsumerDelegate = new ActiveMQConsumerDelegate(url, queueName);
    }

    public ActiveMQConsumerExtension(String url, String queueName, String username, String password) {
        this.activeMQConsumerDelegate = new ActiveMQConsumerDelegate(url, queueName, username, password);
    }

    public ActiveMQConsumerExtension(String url, SimpleString queueName, String username, String password) {
        this.activeMQConsumerDelegate = new ActiveMQConsumerDelegate(url, queueName, username, password);
    }

    public ActiveMQConsumerExtension(String url, SimpleString queueName) {
        this.activeMQConsumerDelegate = new ActiveMQConsumerDelegate(url, queueName);
    }

    public ActiveMQConsumerExtension(ServerLocator serverLocator, String queueName, String username, String password) {
        this.activeMQConsumerDelegate = new ActiveMQConsumerDelegate(serverLocator, queueName, username, password);
    }

    public ActiveMQConsumerExtension(ServerLocator serverLocator, String queueName) {
        this.activeMQConsumerDelegate = new ActiveMQConsumerDelegate(serverLocator, queueName);
    }

    public ActiveMQConsumerExtension(ServerLocator serverLocator, SimpleString queueName, String username, String password) {
        this.activeMQConsumerDelegate = new ActiveMQConsumerDelegate(serverLocator, queueName, username, password);
    }

    public ActiveMQConsumerExtension(ServerLocator serverLocator, SimpleString queueName) {
        this.activeMQConsumerDelegate = new ActiveMQConsumerDelegate(serverLocator, queueName);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.activeMQConsumerDelegate.start();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.activeMQConsumerDelegate.stop();
    }

    public long getDefaultReceiveTimeout() {
        return this.activeMQConsumerDelegate.getDefaultReceiveTimeout();
    }

    public void setDefaultReceiveTimeout(long defaultReceiveTimeout) {
        this.activeMQConsumerDelegate.setDefaultReceiveTimeout(defaultReceiveTimeout);
    }

    protected void createClient() {
        this.activeMQConsumerDelegate.createClient();
    }

    protected void stopClient() {
        this.activeMQConsumerDelegate.stopClient();
    }

    public boolean isAutoCreateQueue() {
        return this.activeMQConsumerDelegate.isAutoCreateQueue();
    }

    public void setAutoCreateQueue(boolean autoCreateQueue) {
        this.activeMQConsumerDelegate.setAutoCreateQueue(autoCreateQueue);
    }

    public ClientMessage receiveMessage() {
        return this.activeMQConsumerDelegate.receiveMessage();
    }

    public ClientMessage receiveMessage(long timeout) {
        return this.activeMQConsumerDelegate.receiveMessage(timeout);
    }

    public static void addMessageProperties(ClientMessage message, Map<String, Object> properties) {
        AbstractActiveMQClientDelegate.addMessageProperties((ClientMessage)message, properties);
    }
}

