/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.junit.AbstractActiveMQClientDelegate;
import org.apache.activemq.artemis.junit.ActiveMQDynamicProducerOperations;
import org.apache.activemq.artemis.junit.ActiveMQProducerDelegate;

public class ActiveMQDynamicProducerDelegate
extends ActiveMQProducerDelegate
implements ActiveMQDynamicProducerOperations {
    public ActiveMQDynamicProducerDelegate(String url, String username, String password) {
        super(url, username, password);
    }

    public ActiveMQDynamicProducerDelegate(String url) {
        super(url);
    }

    public ActiveMQDynamicProducerDelegate(ServerLocator serverLocator, String username, String password) {
        super(serverLocator, username, password);
    }

    public ActiveMQDynamicProducerDelegate(ServerLocator serverLocator) {
        super(serverLocator);
    }

    public ActiveMQDynamicProducerDelegate(String url, SimpleString address, String username, String password) {
        super(url, address, username, password);
    }

    public ActiveMQDynamicProducerDelegate(String url, SimpleString address) {
        super(url, address);
    }

    public ActiveMQDynamicProducerDelegate(ServerLocator serverLocator, SimpleString address, String username, String password) {
        super(serverLocator, address, username, password);
    }

    public ActiveMQDynamicProducerDelegate(ServerLocator serverLocator, SimpleString address) {
        super(serverLocator, address);
    }

    @Override
    protected void createClient() {
        try {
            if (this.address != null && !this.session.addressQuery(this.address).isExists() && this.autoCreateQueue) {
                this.log.warn("queue does not exist - creating queue: address = {}, name = {}", (Object)this.address.toString(), (Object)this.address.toString());
                this.session.createQueue(new QueueConfiguration(this.address));
            }
            this.producer = this.session.createProducer((SimpleString)null);
        }
        catch (ActiveMQException amqEx) {
            if (this.address == null) {
                throw new AbstractActiveMQClientDelegate.ActiveMQClientResourceException(String.format("Error creating producer for address %s", this.address.toString()), (Exception)((Object)amqEx));
            }
            throw new AbstractActiveMQClientDelegate.ActiveMQClientResourceException("Error creating producer", (Exception)((Object)amqEx));
        }
    }

    @Override
    public void sendMessage(ClientMessage message) {
        this.sendMessage(this.address, message);
    }

    @Override
    public void sendMessage(SimpleString targetAddress, ClientMessage message) {
        if (targetAddress == null) {
            throw new IllegalArgumentException(String.format("%s error - address cannot be null", this.getClass().getSimpleName()));
        }
        try {
            if (this.autoCreateQueue && !this.session.addressQuery(targetAddress).isExists()) {
                this.log.warn("queue does not exist - creating queue: address = {}, name = {}", (Object)this.address.toString(), (Object)this.address.toString());
                this.session.createQueue(new QueueConfiguration(targetAddress));
            }
        }
        catch (ActiveMQException amqEx) {
            throw new AbstractActiveMQClientDelegate.ActiveMQClientResourceException(String.format("Queue creation failed for queue: address = %s, name = %s", this.address.toString(), this.address.toString()));
        }
        try {
            this.producer.send(targetAddress, (Message)message);
        }
        catch (ActiveMQException amqEx) {
            throw new AbstractActiveMQClientDelegate.ActiveMQClientResourceException(String.format("Failed to send message to %s", targetAddress.toString()), (Exception)((Object)amqEx));
        }
    }

    @Override
    public ClientMessage sendMessage(SimpleString targetAddress, byte[] body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(targetAddress, message);
        return message;
    }

    @Override
    public ClientMessage sendMessage(SimpleString targetAddress, String body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(targetAddress, message);
        return message;
    }

    @Override
    public ClientMessage sendMessage(SimpleString targetAddress, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(properties);
        this.sendMessage(targetAddress, message);
        return message;
    }

    @Override
    public ClientMessage sendMessage(SimpleString targetAddress, byte[] body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body, properties);
        this.sendMessage(targetAddress, message);
        return message;
    }

    @Override
    public ClientMessage sendMessage(SimpleString targetAddress, String body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body, properties);
        this.sendMessage(targetAddress, message);
        return message;
    }
}

