/** This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
    and it inherits whatever license is declared at org.apache.activemq.artemis.core.protocol.mqtt.MQTTLogger */

package org.apache.activemq.artemis.core.protocol.mqtt;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(regexID="83[0-9]{4}", projectCode="AMQ")
public class MQTTLogger_impl implements MQTTLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public MQTTLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=832000, value=\"Unable to send message: {}\", level=WARN)
   @Override
   public void unableToSendMessage(org.apache.activemq.artemis.core.server.MessageReference message, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ832000: Unable to send message: {}", message, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=832001, value=\"MQTT client({}) attempted to ack already ack'd message: \", level=WARN)
   @Override
   public void failedToAckMessage(java.lang.String clientId, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ832001: MQTT client({}) attempted to ack already ack'd message: ", clientId, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834000, value=\"Error removing subscription.\", level=ERROR)
   @Override
   public void errorRemovingSubscription(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834000: Error removing subscription.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834001, value=\"Error disconnecting client.\", level=ERROR)
   @Override
   public void errorDisconnectingClient(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834001: Error disconnecting client.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834002, value=\"Error processing control packet: {}\", level=ERROR)
   @Override
   public void errorProcessingControlPacket(java.lang.String packet, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834002: Error processing control packet: {}", packet, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834003, value=\"Error sending will message.\", level=ERROR)
   @Override
   public void errorSendingWillMessage(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834003: Error sending will message.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834004, value=\"Error disconnecting consumer.\", level=ERROR)
   @Override
   public void errorDisconnectingConsumer(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834004: Error disconnecting consumer.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834005, value=\"Failed to cast property {}.\", level=ERROR)
   @Override
   public void failedToCastProperty(java.lang.String property) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834005: Failed to cast property {}.", property);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834006, value=\"Failed to publish MQTT message: {}.\", level=ERROR)
   @Override
   public void failedToPublishMqttMessage(java.lang.String exceptionMessage, java.lang.Throwable t) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834006: Failed to publish MQTT message: {}.", exceptionMessage, t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834007, value=\"Authorization failure sending will message: {}\", level=ERROR)
   @Override
   public void authorizationFailureSendingWillMessage(java.lang.String message) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834007: Authorization failure sending will message: {}", message);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834008, value=\"Failed to remove session state for client with ID: {}\", level=ERROR)
   @Override
   public void failedToRemoveSessionState(java.lang.String clientID, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834008: Failed to remove session state for client with ID: {}", clientID, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834009, value=\"Ignoring duplicate MQTT QoS2 PUBLISH packet for packet ID {} from client with ID {}.\", level=WARN)
   @Override
   public void ignoringQoS2Publish(java.lang.String clientId, long packetId) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ834009: Ignoring duplicate MQTT QoS2 PUBLISH packet for packet ID {} from client with ID {}.", clientId, packetId);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834010, value=\"Unable to scan MQTT sessions\", level=ERROR)
   @Override
   public void unableToScanSessions(java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ834010: Unable to scan MQTT sessions", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834011, value=\"Invalid MQTT session state message. Type is incorrect: {}. Will not load this state into memory.\", level=WARN)
   @Override
   public void sessionStateMessageIncorrectType(java.lang.String type) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ834011: Invalid MQTT session state message. Type is incorrect: {}. Will not load this state into memory.", type);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834012, value=\"Invalid MQTT session state message. Client ID is empty or null. Will not load this state into memory.\", level=WARN)
   @Override
   public void sessionStateMessageBadClientId() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ834012: Invalid MQTT session state message. Client ID is empty or null. Will not load this state into memory.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=834013, value=\"Invalid MQTT session state message. Will not load this state into memory.\", level=WARN)
   @Override
   public void errorDeserializingStateMessage(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ834013: Invalid MQTT session state message. Will not load this state into memory.", e);
      }
   }

}
