/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttProperties;
import java.util.Map;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTRoutingContext;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSession;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.routing.RoutingHandler;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public class MQTTRoutingHandler
extends RoutingHandler<MQTTRoutingContext> {
    protected MQTTRoutingHandler(ActiveMQServer server) {
        super(server);
    }

    public boolean route(MQTTConnection mqttConnection, MQTTSession mqttSession, MqttConnectMessage connect) throws Exception {
        return this.route(new MQTTRoutingContext(mqttConnection, mqttSession, connect));
    }

    protected void refuse(MQTTRoutingContext context) {
        switch (context.getResult().getStatus()) {
            case REFUSED_USE_ANOTHER: {
                context.getMQTTSession().getProtocolHandler().sendConnack((byte)-100);
                break;
            }
            case REFUSED_UNAVAILABLE: {
                context.getMQTTSession().getProtocolHandler().sendConnack((byte)-120);
            }
        }
        context.getMQTTSession().getProtocolHandler().disconnect(true);
    }

    protected void redirect(MQTTRoutingContext context) {
        String host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)context.getTarget().getConnector().getParams());
        int port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)context.getTarget().getConnector().getParams());
        MqttProperties mqttProperties = new MqttProperties();
        mqttProperties.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.SERVER_REFERENCE.value(), String.format("%s:%d", host, port)));
        context.getMQTTSession().getProtocolHandler().sendConnack((byte)-100, mqttProperties);
        context.getMQTTSession().getProtocolHandler().disconnect(true);
    }
}

