/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.qourum;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.Quorum;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.jboss.logging.Logger;

public class SharedNothingBackupQuorum
implements Quorum,
SessionFailureListener {
    private static final Logger LOGGER = Logger.getLogger(SharedNothingBackupQuorum.class);
    private QuorumManager quorumManager;
    private String targetServerID = "";
    private final NodeManager nodeManager;
    private final ScheduledExecutorService scheduledPool;
    private final int quorumSize;
    private final int voteRetries;
    private final long voteRetryWait;
    private final Object voteGuard = new Object();
    private ClientSessionFactoryInternal sessionFactory;
    private CoreRemotingConnection connection;
    private final NetworkHealthCheck networkHealthCheck;
    private volatile boolean stopped = false;
    private final int quorumVoteWait;
    private volatile BACKUP_ACTIVATION signal;
    private ScheduledFuture<?> decisionGuard;
    private CountDownLatch latch;
    private final Object onConnectionFailureGuard = new Object();
    private final boolean failback;
    public static final int WAIT_TIME_AFTER_FIRST_LIVE_STOPPING_MSG = 60;

    public SharedNothingBackupQuorum(NodeManager nodeManager, ScheduledExecutorService scheduledPool, NetworkHealthCheck networkHealthCheck, int quorumSize, int voteRetries, long voteRetryWait, int quorumVoteWait, boolean failback) {
        this.scheduledPool = scheduledPool;
        this.quorumSize = quorumSize;
        this.latch = new CountDownLatch(1);
        this.nodeManager = nodeManager;
        this.networkHealthCheck = networkHealthCheck;
        this.voteRetries = voteRetries;
        this.voteRetryWait = voteRetryWait;
        this.quorumVoteWait = quorumVoteWait;
        this.failback = failback;
    }

    @Override
    public String getName() {
        return "SharedNothingBackupQuorum";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionFailure() {
        Object object = this.onConnectionFailureGuard;
        synchronized (object) {
            if (this.signal == BACKUP_ACTIVATION.FAIL_OVER) {
                LOGGER.debug((Object)"Replication connection failure with signal == FAIL_OVER: no need to take any action");
                if (this.networkHealthCheck != null && !this.networkHealthCheck.check()) {
                    this.signal = BACKUP_ACTIVATION.FAILURE_RETRY;
                }
                return;
            }
            this.stopForcedFailoverAfterDelay();
            if (!this.isLiveDown()) {
                ActiveMQServerLogger.LOGGER.restartingAsBackupBasedOnQuorumVoteResults();
                this.signal = BACKUP_ACTIVATION.FAILURE_RETRY;
            } else {
                ActiveMQServerLogger.LOGGER.failingOverBasedOnQuorumVoteResults();
                this.signal = BACKUP_ACTIVATION.FAIL_OVER;
            }
            if (this.networkHealthCheck != null && !this.networkHealthCheck.isEmpty()) {
                if (this.networkHealthCheck.check()) {
                    this.signal = BACKUP_ACTIVATION.FAIL_OVER;
                } else {
                    ActiveMQServerLogger.LOGGER.serverIsolatedOnNetwork();
                    this.signal = BACKUP_ACTIVATION.FAILURE_RETRY;
                }
            }
            this.latch.countDown();
        }
    }

    public void liveIDSet(String liveID) {
        this.targetServerID = liveID;
        this.nodeManager.setNodeID(liveID);
    }

    @Override
    public void setQuorumManager(QuorumManager quorumManager) {
        this.quorumManager = quorumManager;
    }

    @Override
    public void nodeDown(Topology topology, long eventUID, String nodeID) {
        if (!this.failback && this.targetServerID.equals(nodeID)) {
            this.onConnectionFailure();
        }
    }

    @Override
    public void nodeUp(Topology topology) {
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        this.onConnectionFailure();
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    public void beforeReconnect(ActiveMQException exception) {
    }

    @Override
    public void close() {
        this.causeExit(BACKUP_ACTIVATION.STOP);
    }

    public void setSessionFactory(ClientSessionFactoryInternal sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.sessionFactory.addFailureListener((SessionFailureListener)this);
        this.connection = (CoreRemotingConnection)sessionFactory.getConnection();
        this.connection.addFailureListener((FailureListener)this);
    }

    public synchronized void failOver(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) {
        this.removeListeners();
        this.signal = BACKUP_ACTIVATION.FAIL_OVER;
        switch (finalMessage) {
            case STOP_CALLED: {
                this.scheduleForcedFailoverAfterDelay(this.latch);
                break;
            }
            case FAIL_OVER: {
                this.stopForcedFailoverAfterDelay();
                this.latch.countDown();
                break;
            }
            default: {
                LOGGER.errorf("unsupported LiveStopping type: %s", (Object)finalMessage);
            }
        }
    }

    public void notifyRegistrationFailed() {
        this.signal = BACKUP_ACTIVATION.FAILURE_REPLICATING;
        this.latch.countDown();
    }

    public void notifyAlreadyReplicating() {
        this.signal = BACKUP_ACTIVATION.ALREADY_REPLICATING;
        this.latch.countDown();
    }

    private void removeListeners() {
        if (this.connection != null) {
            this.connection.removeFailureListener((FailureListener)this);
        }
        if (this.sessionFactory != null) {
            this.sessionFactory.removeFailureListener((SessionFailureListener)this);
        }
    }

    public BACKUP_ACTIVATION waitForStatusChange() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            return BACKUP_ACTIVATION.STOP;
        }
        return this.signal;
    }

    public synchronized void causeExit(BACKUP_ACTIVATION explicitSignal) {
        this.stopForcedFailoverAfterDelay();
        this.stopped = true;
        this.removeListeners();
        this.signal = explicitSignal;
        this.latch.countDown();
    }

    private synchronized void scheduleForcedFailoverAfterDelay(CountDownLatch signalChanged) {
        if (this.decisionGuard != null) {
            if (this.decisionGuard.isDone()) {
                LOGGER.warn((Object)"A completed force failover task wasn't cleaned-up: a new one will be scheduled");
            } else if (!this.decisionGuard.cancel(false)) {
                LOGGER.warn((Object)"Failed to cancel an existing uncompleted force failover task: a new one will be scheduled anyway");
            } else {
                LOGGER.warn((Object)"Cancelled an existing uncompleted force failover task: a new one will be scheduled in its place");
            }
        }
        this.decisionGuard = this.scheduledPool.schedule(signalChanged::countDown, 60L, TimeUnit.SECONDS);
    }

    private synchronized boolean stopForcedFailoverAfterDelay() {
        if (this.decisionGuard == null) {
            return false;
        }
        boolean stopped = this.decisionGuard.cancel(false);
        this.decisionGuard = null;
        return stopped;
    }

    public synchronized void reset() {
        this.stopForcedFailoverAfterDelay();
        this.latch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLiveDown() {
        if (this.stopped) {
            return false;
        }
        int size = this.quorumSize == -1 ? this.quorumManager.getMaxClusterSize() : this.quorumSize;
        Object object = this.voteGuard;
        synchronized (object) {
            for (int voteAttempts = 0; voteAttempts < this.voteRetries && !this.stopped; ++voteAttempts) {
                if (voteAttempts > 0) {
                    try {
                        this.voteGuard.wait(this.voteRetryWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.quorumManager.hasLive(this.targetServerID, size, this.quorumVoteWait, TimeUnit.SECONDS)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum BACKUP_ACTIVATION {
        FAIL_OVER,
        FAILURE_RETRY,
        FAILURE_REPLICATING,
        ALREADY_REPLICATING,
        STOP;

    }
}

