/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.policies;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.activemq.artemis.core.server.balancing.BrokerBalancer;
import org.apache.activemq.artemis.core.server.balancing.policies.DefaultPolicyFactory;
import org.apache.activemq.artemis.core.server.balancing.policies.PolicyFactory;

public class PolicyFactoryResolver {
    private static PolicyFactoryResolver instance;
    private final Map<String, PolicyFactory> policyFactories = new HashMap<String, PolicyFactory>();

    public static PolicyFactoryResolver getInstance() {
        if (instance == null) {
            instance = new PolicyFactoryResolver();
        }
        return instance;
    }

    private PolicyFactoryResolver() {
        this.registerPolicyFactory(new DefaultPolicyFactory());
        this.loadPolicyFactories();
    }

    public PolicyFactory resolve(String policyName) throws ClassNotFoundException {
        PolicyFactory policyFactory = this.policyFactories.get(policyName);
        if (policyFactory == null) {
            throw new ClassNotFoundException("No PolicyFactory found for the policy " + policyName);
        }
        return policyFactory;
    }

    private void loadPolicyFactories() {
        ServiceLoader<PolicyFactory> serviceLoader = ServiceLoader.load(PolicyFactory.class, BrokerBalancer.class.getClassLoader());
        for (PolicyFactory policyFactory : serviceLoader) {
            this.registerPolicyFactory(policyFactory);
        }
    }

    public void registerPolicyFactory(PolicyFactory policyFactory) {
        for (String policyName : policyFactory.getSupportedPolicies()) {
            this.policyFactories.put(policyName, policyFactory);
        }
    }

    public void unregisterPolicyFactory(PolicyFactory policyFactory) {
        for (String policyName : policyFactory.getSupportedPolicies()) {
            this.policyFactories.remove(policyName, policyFactory);
        }
    }
}

