/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQLockAcquisitionTimeoutException;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreBackupPolicy;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.BackupRecoveryJournalLoader;
import org.apache.activemq.artemis.core.server.impl.BackupTopologyListener;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SharedStoreBackupActivation
extends Activation {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SharedStoreBackupPolicy sharedStoreBackupPolicy;
    private final ActiveMQServerImpl activeMQServer;
    private final Object failbackCheckerGuard = new Object();
    private boolean cancelFailBackChecker;
    private NodeManager.LockListener activeLockListener;
    private final IOCriticalErrorListener ioCriticalErrorListener;
    private final AtomicBoolean restarting = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedStoreBackupActivation(ActiveMQServerImpl server, SharedStoreBackupPolicy sharedStoreBackupPolicy, IOCriticalErrorListener ioCriticalErrorListener) {
        this.activeMQServer = server;
        this.sharedStoreBackupPolicy = sharedStoreBackupPolicy;
        this.ioCriticalErrorListener = ioCriticalErrorListener;
        Object object = this.failbackCheckerGuard;
        synchronized (object) {
            this.cancelFailBackChecker = false;
        }
    }

    @Override
    public void run() {
        try {
            boolean scalingDown;
            this.registerActiveLockListener(this.activeMQServer.getNodeManager());
            this.activeMQServer.getNodeManager().startBackup();
            ScaleDownPolicy scaleDownPolicy = this.sharedStoreBackupPolicy.getScaleDownPolicy();
            boolean bl = scalingDown = scaleDownPolicy != null && scaleDownPolicy.isEnabled();
            if (!this.activeMQServer.initialisePart1(scalingDown)) {
                return;
            }
            this.activeMQServer.getBackupManager().start();
            this.activeMQServer.setState(ActiveMQServer.SERVER_STATE.STARTED);
            ActiveMQServerLogger.LOGGER.backupServerStarted(this.activeMQServer.getVersion().getFullVersion(), this.activeMQServer.getNodeManager().getNodeId());
            this.activeMQServer.getNodeManager().awaitPrimaryNode();
            this.sharedStoreBackupPolicy.getSharedStorePrimaryPolicy().setSharedStoreBackupPolicy(this.sharedStoreBackupPolicy);
            this.activeMQServer.setHAPolicy(this.sharedStoreBackupPolicy.getSharedStorePrimaryPolicy());
            this.activeMQServer.getBackupManager().activated();
            if (this.activeMQServer.getState() != ActiveMQServer.SERVER_STATE.STARTED) {
                return;
            }
            this.activeMQServer.initialisePart2(scalingDown);
            this.activeMQServer.completeActivation(false);
            if (scalingDown) {
                if (!this.restarting.compareAndSet(false, true)) {
                    return;
                }
                this.unregisterActiveLockListener(this.activeMQServer.getNodeManager());
                ActiveMQServerLogger.LOGGER.backupServerScaledDown();
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SharedStoreBackupActivation.this.activeMQServer.stop();
                            if (SharedStoreBackupActivation.this.sharedStoreBackupPolicy.isRestartBackup()) {
                                SharedStoreBackupActivation.this.activeMQServer.start();
                            }
                        }
                        catch (Exception e) {
                            ActiveMQServerLogger.LOGGER.serverRestartWarning(e);
                        }
                    }
                });
                t.start();
                return;
            }
            ActiveMQServerLogger.LOGGER.backupServerIsActive();
            this.activeMQServer.getNodeManager().releaseBackup();
            if (this.sharedStoreBackupPolicy.isAllowAutoFailBack() && ActiveMQServer.SERVER_STATE.STOPPING != this.activeMQServer.getState() && ActiveMQServer.SERVER_STATE.STOPPED != this.activeMQServer.getState()) {
                this.startFailbackChecker();
            }
        }
        catch (NodeManager.NodeManagerException nodeManagerException) {
            if (nodeManagerException.getCause() instanceof ClosedChannelException) {
                return;
            }
            if (nodeManagerException.getCause() instanceof ActiveMQLockAcquisitionTimeoutException) {
                ActiveMQServerLogger.LOGGER.initializationError(nodeManagerException.getCause());
                return;
            }
            this.unregisterActiveLockListener(this.activeMQServer.getNodeManager());
            this.ioCriticalErrorListener.onIOException((Throwable)nodeManagerException, nodeManagerException.getMessage(), null);
        }
        catch (InterruptedException | ClosedChannelException nodeManagerException) {
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof InterruptedException)) {
                ActiveMQServerLogger.LOGGER.initializationError(e);
            }
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.initializationError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        if (!restarting) {
            Object object = this.failbackCheckerGuard;
            synchronized (object) {
                this.cancelFailBackChecker = true;
            }
        }
        NodeManager nodeManagerInUse = this.activeMQServer.getNodeManager();
        if (this.activeMQServer.getHAPolicy().isBackup()) {
            this.activeMQServer.interruptActivationThread(nodeManagerInUse);
            if (nodeManagerInUse != null) {
                this.unregisterActiveLockListener(nodeManagerInUse);
                nodeManagerInUse.stopBackup();
            }
        } else if (nodeManagerInUse != null) {
            this.unregisterActiveLockListener(nodeManagerInUse);
            if (this.sharedStoreBackupPolicy.isFailoverOnServerShutdown() || permanently) {
                try {
                    nodeManagerInUse.crashPrimaryServer();
                }
                catch (Throwable t) {
                    if (!permanently) {
                        throw t;
                    }
                    logger.warn("Errored while closing activation: can be ignored because of permanent close", t);
                }
            } else {
                nodeManagerInUse.pausePrimaryServer();
            }
        }
    }

    private void registerActiveLockListener(NodeManager nodeManager) {
        NodeManager.LockListener lockListener;
        this.activeLockListener = lockListener = () -> {
            if (!this.restarting.compareAndSet(false, true)) {
                logger.warn("Restarting already happening on lost lock");
                return;
            }
            this.unregisterActiveLockListener(nodeManager);
            this.ioCriticalErrorListener.onIOException((Throwable)new IOException("lost lock"), "Lost NodeManager lock", null);
        };
        nodeManager.registerLockListener(lockListener);
    }

    private void unregisterActiveLockListener(NodeManager nodeManager) {
        NodeManager.LockListener activeLockListener = this.activeLockListener;
        if (activeLockListener != null) {
            nodeManager.unregisterLockListener(activeLockListener);
            this.activeLockListener = null;
        }
    }

    @Override
    public JournalLoader createJournalLoader(PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, QueueFactory queueFactory, NodeManager nodeManager, ManagementService managementService, GroupingHandler groupingHandler, Configuration configuration, ActiveMQServer parentServer) throws ActiveMQException {
        if (this.sharedStoreBackupPolicy.getScaleDownPolicy() != null && this.sharedStoreBackupPolicy.getScaleDownPolicy().isEnabled()) {
            return new BackupRecoveryJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer, ScaleDownPolicy.getScaleDownConnector(this.sharedStoreBackupPolicy.getScaleDownPolicy(), this.activeMQServer), this.activeMQServer.getClusterManager().getClusterController());
        }
        return super.createJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer);
    }

    private void startFailbackChecker() {
        this.activeMQServer.getScheduledPool().scheduleAtFixedRate(new FailbackChecker(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private class FailbackChecker
    implements Runnable {
        BackupTopologyListener backupListener;

        FailbackChecker() {
            ClusterManager clusterManager = SharedStoreBackupActivation.this.activeMQServer.getClusterManager();
            if (clusterManager != null) {
                ClusterConnection clusterConnection = clusterManager.getDefaultConnection(null);
                if (clusterConnection != null) {
                    TransportConfiguration connector = clusterConnection.getConnector();
                    if (connector != null) {
                        this.backupListener = new BackupTopologyListener(SharedStoreBackupActivation.this.activeMQServer.getNodeID().toString(), connector);
                        clusterConnection.addClusterTopologyListener(this.backupListener);
                    } else {
                        ActiveMQServerLogger.LOGGER.failBackCheckerFailure("connector");
                    }
                } else {
                    ActiveMQServerLogger.LOGGER.failBackCheckerFailure("cluster connection");
                }
            } else {
                ActiveMQServerLogger.LOGGER.failBackCheckerFailure("cluster manager");
            }
        }

        @Override
        public void run() {
            try {
                if (!SharedStoreBackupActivation.this.restarting.get() && SharedStoreBackupActivation.this.activeMQServer.getNodeManager().isAwaitingFailback() && this.backupListener != null && this.backupListener.waitForBackup()) {
                    if (!SharedStoreBackupActivation.this.restarting.compareAndSet(false, true)) {
                        return;
                    }
                    ActiveMQServerLogger.LOGGER.awaitFailBack();
                    Thread t = new Thread(() -> {
                        try {
                            logger.debug("{}::Stopping active node in favor of failback", (Object)SharedStoreBackupActivation.this.activeMQServer);
                            NodeManager nodeManager = SharedStoreBackupActivation.this.activeMQServer.getNodeManager();
                            SharedStoreBackupActivation.this.activeMQServer.stop(true, false, true);
                            nodeManager.start();
                            try {
                                nodeManager.awaitActiveStatus();
                            }
                            finally {
                                nodeManager.stop();
                            }
                            Object object = SharedStoreBackupActivation.this.failbackCheckerGuard;
                            synchronized (object) {
                                if (SharedStoreBackupActivation.this.cancelFailBackChecker || !SharedStoreBackupActivation.this.sharedStoreBackupPolicy.isRestartBackup()) {
                                    return;
                                }
                                SharedStoreBackupActivation.this.activeMQServer.setHAPolicy(SharedStoreBackupActivation.this.sharedStoreBackupPolicy);
                                logger.debug("{}::Starting backup node now after failback", (Object)SharedStoreBackupActivation.this.activeMQServer);
                                SharedStoreBackupActivation.this.activeMQServer.start();
                                NodeManager.LockListener lockListener = SharedStoreBackupActivation.this.activeLockListener;
                                if (lockListener != null) {
                                    SharedStoreBackupActivation.this.activeMQServer.getNodeManager().registerLockListener(lockListener);
                                }
                            }
                        }
                        catch (Exception e) {
                            ActiveMQServerLogger.LOGGER.serverRestartWarning(e);
                        }
                    });
                    t.start();
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.serverRestartWarning(e);
            }
        }
    }
}

