/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.impl.AddressMapVisitor;
import org.apache.activemq.artemis.core.postoffice.impl.AddressPartNode;

public class AddressMap<T> {
    private final AddressPartNode<T> rootNode;
    private final char DELIMITER;

    public AddressMap(String any, String single, char delimiter) {
        this.rootNode = new AddressPartNode(any, single);
        this.DELIMITER = delimiter;
    }

    public void put(SimpleString key, T value) {
        this.rootNode.add(this.getPaths(key), 0, value);
    }

    public void remove(SimpleString key, T value) {
        this.rootNode.remove(this.getPaths(key), 0, value);
    }

    public void reset() {
        this.rootNode.reset();
    }

    public String[] getPaths(SimpleString address) {
        return address.getPaths(this.DELIMITER);
    }

    public void visitMatchingWildcards(SimpleString address, AddressMapVisitor<T> collector) throws Exception {
        String[] paths = this.getPaths(address);
        this.rootNode.visitMatchingWildcards(paths, 0, collector);
    }

    public void visitMatching(SimpleString wildcardAddress, AddressMapVisitor<T> collector) throws Exception {
        String[] paths = this.getPaths(wildcardAddress);
        this.rootNode.visitNonWildcard(paths, 0, collector);
    }
}

