/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.service.extensions.xa;

import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.service.extensions.xa.ActiveMQXAResourceWrapper;

public class ActiveMQXAResourceWrapperImpl
implements ActiveMQXAResourceWrapper {
    private final XAResource xaResource;
    private final String productName;
    private final String productVersion;
    private final String jndiNameNodeId;

    public ActiveMQXAResourceWrapperImpl(XAResource xaResource, Map<String, Object> properties) {
        this.xaResource = xaResource;
        this.productName = (String)properties.get("ACTIVEMQ_PRODUCT_NAME");
        this.productVersion = (String)properties.get("ACTIVEMQ_PRODUCT_VERSION");
        String jndiName = (String)properties.get("ACTIVEMQ_JNDI_ID");
        String nodeId = "NodeId:" + String.valueOf(properties.get("ACTIVEMQ_NODE_ID"));
        this.jndiNameNodeId = jndiName == null ? nodeId : jndiName + " " + nodeId;
    }

    public XAResource getResource() {
        return this.xaResource;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getJndiName() {
        return this.jndiNameNodeId;
    }

    @Override
    public void commit(Xid xid, boolean b) throws XAException {
        this.getResource().commit(xid, b);
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        this.getResource().end(xid, i);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.getResource().forget(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.getResource().getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this.getResource().isSameRM(xaResource);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.getResource().prepare(xid);
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        return this.getResource().recover(i);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.getResource().rollback(xid);
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        return this.getResource().setTransactionTimeout(i);
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        this.getResource().start(xid, i);
    }
}

