
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Reservation",
    "BulkSubmission",
    "TotalPhysicalCPUs",
    "TotalLogicalCPUs",
    "TotalSlots",
    "SlotsUsedByLocalJobs",
    "SlotsUsedByGridJobs",
    "Homogeneous",
    "NetworkInfo",
    "LocalCPUDistribution",
    "WorkingAreaShared",
    "WorkingAreaGuaranteed",
    "WorkingAreaTotal",
    "WorkingAreaFree",
    "WorkingAreaLifeTime",
    "WorkingAreaMultiSlotTotal",
    "WorkingAreaMultiSlotFree",
    "WorkingAreaMultiSlotLifeTime",
    "CacheTotal",
    "CacheFree",
    "TmpDir",
    "ScratchDir",
    "ApplicationDir",
    "ApplicationEnvironmentID",
    "BenchmarkID"
})
public class ComputingManager {

    /**
     * Whether advance reservation is supported (no value implies undefined in ExtendedBoolean_t)
     * 
     */
    @JsonProperty("Reservation")
    private Boolean reservation;
    /**
     * Whether multiple jobs can be submitted at once (no value implies undefined in ExtendedBoolean_t)
     * 
     */
    @JsonProperty("BulkSubmission")
    private Boolean bulkSubmission;
    /**
     * The total number of physical CPUs managed by this ComputingManager
     * 
     */
    @JsonProperty("TotalPhysicalCPUs")
    private Integer totalPhysicalCPUs;
    /**
     * The total number of logical CPUs managed by this ComputingManager
     * 
     */
    @JsonProperty("TotalLogicalCPUs")
    private Integer totalLogicalCPUs;
    /**
     * The total number of slots managed by this ComputingManager
     * 
     */
    @JsonProperty("TotalSlots")
    private Integer totalSlots;
    /**
     * The number of slots currently used by jobs submitted via a non-Grid interface
     * 
     */
    @JsonProperty("SlotsUsedByLocalJobs")
    private Integer slotsUsedByLocalJobs;
    /**
     * The number of slots currently used by jobs submitted via a non-Grid interface
     * 
     */
    @JsonProperty("SlotsUsedByGridJobs")
    private Integer slotsUsedByGridJobs;
    /**
     * Whether this ComputingManager manages only one type of ExecutionEnvironment
     * 
     */
    @JsonProperty("Homogeneous")
    private Boolean homogeneous;
    /**
     * The types of internal network connections between ExecutionEnvironments (NetworkInfo_t)
     * 
     */
    @JsonProperty("NetworkInfo")
    private List<String> networkInfo = new ArrayList<String>();
    /**
     * Classification of the managed ExecutionEnvironments aggregated by the number of logical CPUs
     * 
     */
    @JsonProperty("LocalCPUDistribution")
    private Boolean localCPUDistribution;
    /**
     * True if the working area is shared across different ExecutionEnvironments
     * 
     */
    @JsonProperty("WorkingAreaShared")
    private Boolean workingAreaShared;
    /**
     * True if the job is guaranteed all of WorkingAreaTotal
     * 
     */
    @JsonProperty("WorkingAreaGuaranteed")
    private Boolean workingAreaGuaranteed;
    /**
     * Total size of the working area available to single slot jobs (GB)
     * 
     */
    @JsonProperty("WorkingAreaTotal")
    private Integer workingAreaTotal;
    /**
     * The amount of free space in the working area (GB)
     * 
     */
    @JsonProperty("WorkingAreaFree")
    private Integer workingAreaFree;
    /**
     * The minimum guaranteed lifetime of files created in the working area (seconds)
     * 
     */
    @JsonProperty("WorkingAreaLifeTime")
    private Integer workingAreaLifeTime;
    /**
     * The total size of the working area across all ExecutionEnvironments (GB)
     * 
     */
    @JsonProperty("WorkingAreaMultiSlotTotal")
    private Integer workingAreaMultiSlotTotal;
    /**
     * The available space in the working area across all ExecutionEnvironments (GB)
     * 
     */
    @JsonProperty("WorkingAreaMultiSlotFree")
    private Integer workingAreaMultiSlotFree;
    /**
     * The minimum guaranteed lifetime of files created in the working area (seconds)
     * 
     */
    @JsonProperty("WorkingAreaMultiSlotLifeTime")
    private Integer workingAreaMultiSlotLifeTime;
    /**
     * If local caching of input files is supported, the total size of the area they may be stored in
     * 
     */
    @JsonProperty("CacheTotal")
    private Integer cacheTotal;
    /**
     * If local caching of input files is supported, the available size of the area they may be stored in
     * 
     */
    @JsonProperty("CacheFree")
    private Integer cacheFree;
    /**
     * The absolute path of a temporary directory local to an ExecutionEnvironment
     * 
     */
    @JsonProperty("TmpDir")
    private String tmpDir;
    /**
     * The absolute path of a shared directory available for application data
     * 
     */
    @JsonProperty("ScratchDir")
    private String scratchDir;
    /**
     * The absolute path of a directory available for installation of persistent application software
     * 
     */
    @JsonProperty("ApplicationDir")
    private String applicationDir;
    /**
     * ID(s) of ApplicationEnvironments provided by this ComputingManager
     * 
     */
    @JsonProperty("ApplicationEnvironmentID")
    private List<String> applicationEnvironmentID = new ArrayList<String>();
    /**
     * ID(s) of Benchmarks associated with this ComputingManager
     * 
     */
    @JsonProperty("BenchmarkID")
    private List<String> benchmarkID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Whether advance reservation is supported (no value implies undefined in ExtendedBoolean_t)
     * 
     */
    @JsonProperty("Reservation")
    public Boolean getReservation() {
        return reservation;
    }

    /**
     * Whether advance reservation is supported (no value implies undefined in ExtendedBoolean_t)
     * 
     */
    @JsonProperty("Reservation")
    public void setReservation(Boolean reservation) {
        this.reservation = reservation;
    }

    /**
     * Whether multiple jobs can be submitted at once (no value implies undefined in ExtendedBoolean_t)
     * 
     */
    @JsonProperty("BulkSubmission")
    public Boolean getBulkSubmission() {
        return bulkSubmission;
    }

    /**
     * Whether multiple jobs can be submitted at once (no value implies undefined in ExtendedBoolean_t)
     * 
     */
    @JsonProperty("BulkSubmission")
    public void setBulkSubmission(Boolean bulkSubmission) {
        this.bulkSubmission = bulkSubmission;
    }

    /**
     * The total number of physical CPUs managed by this ComputingManager
     * 
     */
    @JsonProperty("TotalPhysicalCPUs")
    public Integer getTotalPhysicalCPUs() {
        return totalPhysicalCPUs;
    }

    /**
     * The total number of physical CPUs managed by this ComputingManager
     * 
     */
    @JsonProperty("TotalPhysicalCPUs")
    public void setTotalPhysicalCPUs(Integer totalPhysicalCPUs) {
        this.totalPhysicalCPUs = totalPhysicalCPUs;
    }

    /**
     * The total number of logical CPUs managed by this ComputingManager
     * 
     */
    @JsonProperty("TotalLogicalCPUs")
    public Integer getTotalLogicalCPUs() {
        return totalLogicalCPUs;
    }

    /**
     * The total number of logical CPUs managed by this ComputingManager
     * 
     */
    @JsonProperty("TotalLogicalCPUs")
    public void setTotalLogicalCPUs(Integer totalLogicalCPUs) {
        this.totalLogicalCPUs = totalLogicalCPUs;
    }

    /**
     * The total number of slots managed by this ComputingManager
     * 
     */
    @JsonProperty("TotalSlots")
    public Integer getTotalSlots() {
        return totalSlots;
    }

    /**
     * The total number of slots managed by this ComputingManager
     * 
     */
    @JsonProperty("TotalSlots")
    public void setTotalSlots(Integer totalSlots) {
        this.totalSlots = totalSlots;
    }

    /**
     * The number of slots currently used by jobs submitted via a non-Grid interface
     * 
     */
    @JsonProperty("SlotsUsedByLocalJobs")
    public Integer getSlotsUsedByLocalJobs() {
        return slotsUsedByLocalJobs;
    }

    /**
     * The number of slots currently used by jobs submitted via a non-Grid interface
     * 
     */
    @JsonProperty("SlotsUsedByLocalJobs")
    public void setSlotsUsedByLocalJobs(Integer slotsUsedByLocalJobs) {
        this.slotsUsedByLocalJobs = slotsUsedByLocalJobs;
    }

    /**
     * The number of slots currently used by jobs submitted via a non-Grid interface
     * 
     */
    @JsonProperty("SlotsUsedByGridJobs")
    public Integer getSlotsUsedByGridJobs() {
        return slotsUsedByGridJobs;
    }

    /**
     * The number of slots currently used by jobs submitted via a non-Grid interface
     * 
     */
    @JsonProperty("SlotsUsedByGridJobs")
    public void setSlotsUsedByGridJobs(Integer slotsUsedByGridJobs) {
        this.slotsUsedByGridJobs = slotsUsedByGridJobs;
    }

    /**
     * Whether this ComputingManager manages only one type of ExecutionEnvironment
     * 
     */
    @JsonProperty("Homogeneous")
    public Boolean getHomogeneous() {
        return homogeneous;
    }

    /**
     * Whether this ComputingManager manages only one type of ExecutionEnvironment
     * 
     */
    @JsonProperty("Homogeneous")
    public void setHomogeneous(Boolean homogeneous) {
        this.homogeneous = homogeneous;
    }

    /**
     * The types of internal network connections between ExecutionEnvironments (NetworkInfo_t)
     * 
     */
    @JsonProperty("NetworkInfo")
    public List<String> getNetworkInfo() {
        return networkInfo;
    }

    /**
     * The types of internal network connections between ExecutionEnvironments (NetworkInfo_t)
     * 
     */
    @JsonProperty("NetworkInfo")
    public void setNetworkInfo(List<String> networkInfo) {
        this.networkInfo = networkInfo;
    }

    /**
     * Classification of the managed ExecutionEnvironments aggregated by the number of logical CPUs
     * 
     */
    @JsonProperty("LocalCPUDistribution")
    public Boolean getLocalCPUDistribution() {
        return localCPUDistribution;
    }

    /**
     * Classification of the managed ExecutionEnvironments aggregated by the number of logical CPUs
     * 
     */
    @JsonProperty("LocalCPUDistribution")
    public void setLocalCPUDistribution(Boolean localCPUDistribution) {
        this.localCPUDistribution = localCPUDistribution;
    }

    /**
     * True if the working area is shared across different ExecutionEnvironments
     * 
     */
    @JsonProperty("WorkingAreaShared")
    public Boolean getWorkingAreaShared() {
        return workingAreaShared;
    }

    /**
     * True if the working area is shared across different ExecutionEnvironments
     * 
     */
    @JsonProperty("WorkingAreaShared")
    public void setWorkingAreaShared(Boolean workingAreaShared) {
        this.workingAreaShared = workingAreaShared;
    }

    /**
     * True if the job is guaranteed all of WorkingAreaTotal
     * 
     */
    @JsonProperty("WorkingAreaGuaranteed")
    public Boolean getWorkingAreaGuaranteed() {
        return workingAreaGuaranteed;
    }

    /**
     * True if the job is guaranteed all of WorkingAreaTotal
     * 
     */
    @JsonProperty("WorkingAreaGuaranteed")
    public void setWorkingAreaGuaranteed(Boolean workingAreaGuaranteed) {
        this.workingAreaGuaranteed = workingAreaGuaranteed;
    }

    /**
     * Total size of the working area available to single slot jobs (GB)
     * 
     */
    @JsonProperty("WorkingAreaTotal")
    public Integer getWorkingAreaTotal() {
        return workingAreaTotal;
    }

    /**
     * Total size of the working area available to single slot jobs (GB)
     * 
     */
    @JsonProperty("WorkingAreaTotal")
    public void setWorkingAreaTotal(Integer workingAreaTotal) {
        this.workingAreaTotal = workingAreaTotal;
    }

    /**
     * The amount of free space in the working area (GB)
     * 
     */
    @JsonProperty("WorkingAreaFree")
    public Integer getWorkingAreaFree() {
        return workingAreaFree;
    }

    /**
     * The amount of free space in the working area (GB)
     * 
     */
    @JsonProperty("WorkingAreaFree")
    public void setWorkingAreaFree(Integer workingAreaFree) {
        this.workingAreaFree = workingAreaFree;
    }

    /**
     * The minimum guaranteed lifetime of files created in the working area (seconds)
     * 
     */
    @JsonProperty("WorkingAreaLifeTime")
    public Integer getWorkingAreaLifeTime() {
        return workingAreaLifeTime;
    }

    /**
     * The minimum guaranteed lifetime of files created in the working area (seconds)
     * 
     */
    @JsonProperty("WorkingAreaLifeTime")
    public void setWorkingAreaLifeTime(Integer workingAreaLifeTime) {
        this.workingAreaLifeTime = workingAreaLifeTime;
    }

    /**
     * The total size of the working area across all ExecutionEnvironments (GB)
     * 
     */
    @JsonProperty("WorkingAreaMultiSlotTotal")
    public Integer getWorkingAreaMultiSlotTotal() {
        return workingAreaMultiSlotTotal;
    }

    /**
     * The total size of the working area across all ExecutionEnvironments (GB)
     * 
     */
    @JsonProperty("WorkingAreaMultiSlotTotal")
    public void setWorkingAreaMultiSlotTotal(Integer workingAreaMultiSlotTotal) {
        this.workingAreaMultiSlotTotal = workingAreaMultiSlotTotal;
    }

    /**
     * The available space in the working area across all ExecutionEnvironments (GB)
     * 
     */
    @JsonProperty("WorkingAreaMultiSlotFree")
    public Integer getWorkingAreaMultiSlotFree() {
        return workingAreaMultiSlotFree;
    }

    /**
     * The available space in the working area across all ExecutionEnvironments (GB)
     * 
     */
    @JsonProperty("WorkingAreaMultiSlotFree")
    public void setWorkingAreaMultiSlotFree(Integer workingAreaMultiSlotFree) {
        this.workingAreaMultiSlotFree = workingAreaMultiSlotFree;
    }

    /**
     * The minimum guaranteed lifetime of files created in the working area (seconds)
     * 
     */
    @JsonProperty("WorkingAreaMultiSlotLifeTime")
    public Integer getWorkingAreaMultiSlotLifeTime() {
        return workingAreaMultiSlotLifeTime;
    }

    /**
     * The minimum guaranteed lifetime of files created in the working area (seconds)
     * 
     */
    @JsonProperty("WorkingAreaMultiSlotLifeTime")
    public void setWorkingAreaMultiSlotLifeTime(Integer workingAreaMultiSlotLifeTime) {
        this.workingAreaMultiSlotLifeTime = workingAreaMultiSlotLifeTime;
    }

    /**
     * If local caching of input files is supported, the total size of the area they may be stored in
     * 
     */
    @JsonProperty("CacheTotal")
    public Integer getCacheTotal() {
        return cacheTotal;
    }

    /**
     * If local caching of input files is supported, the total size of the area they may be stored in
     * 
     */
    @JsonProperty("CacheTotal")
    public void setCacheTotal(Integer cacheTotal) {
        this.cacheTotal = cacheTotal;
    }

    /**
     * If local caching of input files is supported, the available size of the area they may be stored in
     * 
     */
    @JsonProperty("CacheFree")
    public Integer getCacheFree() {
        return cacheFree;
    }

    /**
     * If local caching of input files is supported, the available size of the area they may be stored in
     * 
     */
    @JsonProperty("CacheFree")
    public void setCacheFree(Integer cacheFree) {
        this.cacheFree = cacheFree;
    }

    /**
     * The absolute path of a temporary directory local to an ExecutionEnvironment
     * 
     */
    @JsonProperty("TmpDir")
    public String getTmpDir() {
        return tmpDir;
    }

    /**
     * The absolute path of a temporary directory local to an ExecutionEnvironment
     * 
     */
    @JsonProperty("TmpDir")
    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    /**
     * The absolute path of a shared directory available for application data
     * 
     */
    @JsonProperty("ScratchDir")
    public String getScratchDir() {
        return scratchDir;
    }

    /**
     * The absolute path of a shared directory available for application data
     * 
     */
    @JsonProperty("ScratchDir")
    public void setScratchDir(String scratchDir) {
        this.scratchDir = scratchDir;
    }

    /**
     * The absolute path of a directory available for installation of persistent application software
     * 
     */
    @JsonProperty("ApplicationDir")
    public String getApplicationDir() {
        return applicationDir;
    }

    /**
     * The absolute path of a directory available for installation of persistent application software
     * 
     */
    @JsonProperty("ApplicationDir")
    public void setApplicationDir(String applicationDir) {
        this.applicationDir = applicationDir;
    }

    /**
     * ID(s) of ApplicationEnvironments provided by this ComputingManager
     * 
     */
    @JsonProperty("ApplicationEnvironmentID")
    public List<String> getApplicationEnvironmentID() {
        return applicationEnvironmentID;
    }

    /**
     * ID(s) of ApplicationEnvironments provided by this ComputingManager
     * 
     */
    @JsonProperty("ApplicationEnvironmentID")
    public void setApplicationEnvironmentID(List<String> applicationEnvironmentID) {
        this.applicationEnvironmentID = applicationEnvironmentID;
    }

    /**
     * ID(s) of Benchmarks associated with this ComputingManager
     * 
     */
    @JsonProperty("BenchmarkID")
    public List<String> getBenchmarkID() {
        return benchmarkID;
    }

    /**
     * ID(s) of Benchmarks associated with this ComputingManager
     * 
     */
    @JsonProperty("BenchmarkID")
    public void setBenchmarkID(List<String> benchmarkID) {
        this.benchmarkID = benchmarkID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
