
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "ProductName",
    "ProductVersion",
    "ServiceID",
    "ResourceID"
})
public class Manager_ {

    /**
     * The name of the software product which implements the Manager
     * 
     */
    @JsonProperty("ProductName")
    private String productName;
    /**
     * The version of the software product which implements the Manager
     * 
     */
    @JsonProperty("ProductVersion")
    private String productVersion;
    /**
     * The ID of the Service this Share participates in
     * 
     */
    @JsonProperty("ServiceID")
    private String serviceID;
    /**
     * ID(s) of Resources associated with this Share
     * 
     */
    @JsonProperty("ResourceID")
    private List<String> resourceID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The name of the software product which implements the Manager
     * 
     */
    @JsonProperty("ProductName")
    public String getProductName() {
        return productName;
    }

    /**
     * The name of the software product which implements the Manager
     * 
     */
    @JsonProperty("ProductName")
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * The version of the software product which implements the Manager
     * 
     */
    @JsonProperty("ProductVersion")
    public String getProductVersion() {
        return productVersion;
    }

    /**
     * The version of the software product which implements the Manager
     * 
     */
    @JsonProperty("ProductVersion")
    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    /**
     * The ID of the Service this Share participates in
     * 
     */
    @JsonProperty("ServiceID")
    public String getServiceID() {
        return serviceID;
    }

    /**
     * The ID of the Service this Share participates in
     * 
     */
    @JsonProperty("ServiceID")
    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }

    /**
     * ID(s) of Resources associated with this Share
     * 
     */
    @JsonProperty("ResourceID")
    public List<String> getResourceID() {
        return resourceID;
    }

    /**
     * ID(s) of Resources associated with this Share
     * 
     */
    @JsonProperty("ResourceID")
    public void setResourceID(List<String> resourceID) {
        this.resourceID = resourceID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
