
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Capability",
    "Type",
    "QualityLevel",
    "StatusInfo",
    "Complexity",
    "EndpointID",
    "ShareID",
    "ManagerID",
    "ContactID",
    "LocationID",
    "ServiceID"
})
public class Service_ {

    /**
     * Capability_t (open enumeration)
     * 
     */
    @JsonProperty("Capability")
    private List<String> capability = new ArrayList<String>();
    /**
     * ServiceType_t (open enumeration)
     * 
     */
    @JsonProperty("Type")
    private String type;
    /**
     * QualityLevel_t
     * 
     */
    @JsonProperty("QualityLevel")
    private Service_.QualityLevel qualityLevel;
    /**
     * URLs of web pages providing additional information
     * 
     */
    @JsonProperty("StatusInfo")
    private List<String> statusInfo = new ArrayList<String>();
    /**
     * A human-readable description of the number of endpoint types, shares, and resources
     * 
     */
    @JsonProperty("Complexity")
    private String complexity;
    /**
     * The IDs of Endpoints for this Service
     * 
     */
    @JsonProperty("EndpointID")
    private List<String> endpointID = new ArrayList<String>();
    /**
     * The IDs of the Shares offered by this Service
     * 
     */
    @JsonProperty("ShareID")
    private List<String> shareID = new ArrayList<String>();
    /**
     * The IDs of the Managers of this Service
     * 
     */
    @JsonProperty("ManagerID")
    private List<String> managerID = new ArrayList<String>();
    /**
     * The IDs of Contacts for this Service
     * 
     */
    @JsonProperty("ContactID")
    private List<String> contactID = new ArrayList<String>();
    /**
     * The ID of the primary Location of this Service
     * 
     */
    @JsonProperty("LocationID")
    private String locationID;
    /**
     * The IDs of Services related to this Service
     * 
     */
    @JsonProperty("ServiceID")
    private List<String> serviceID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Capability_t (open enumeration)
     * 
     */
    @JsonProperty("Capability")
    public List<String> getCapability() {
        return capability;
    }

    /**
     * Capability_t (open enumeration)
     * 
     */
    @JsonProperty("Capability")
    public void setCapability(List<String> capability) {
        this.capability = capability;
    }

    /**
     * ServiceType_t (open enumeration)
     * 
     */
    @JsonProperty("Type")
    public String getType() {
        return type;
    }

    /**
     * ServiceType_t (open enumeration)
     * 
     */
    @JsonProperty("Type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * QualityLevel_t
     * 
     */
    @JsonProperty("QualityLevel")
    public Service_.QualityLevel getQualityLevel() {
        return qualityLevel;
    }

    /**
     * QualityLevel_t
     * 
     */
    @JsonProperty("QualityLevel")
    public void setQualityLevel(Service_.QualityLevel qualityLevel) {
        this.qualityLevel = qualityLevel;
    }

    /**
     * URLs of web pages providing additional information
     * 
     */
    @JsonProperty("StatusInfo")
    public List<String> getStatusInfo() {
        return statusInfo;
    }

    /**
     * URLs of web pages providing additional information
     * 
     */
    @JsonProperty("StatusInfo")
    public void setStatusInfo(List<String> statusInfo) {
        this.statusInfo = statusInfo;
    }

    /**
     * A human-readable description of the number of endpoint types, shares, and resources
     * 
     */
    @JsonProperty("Complexity")
    public String getComplexity() {
        return complexity;
    }

    /**
     * A human-readable description of the number of endpoint types, shares, and resources
     * 
     */
    @JsonProperty("Complexity")
    public void setComplexity(String complexity) {
        this.complexity = complexity;
    }

    /**
     * The IDs of Endpoints for this Service
     * 
     */
    @JsonProperty("EndpointID")
    public List<String> getEndpointID() {
        return endpointID;
    }

    /**
     * The IDs of Endpoints for this Service
     * 
     */
    @JsonProperty("EndpointID")
    public void setEndpointID(List<String> endpointID) {
        this.endpointID = endpointID;
    }

    /**
     * The IDs of the Shares offered by this Service
     * 
     */
    @JsonProperty("ShareID")
    public List<String> getShareID() {
        return shareID;
    }

    /**
     * The IDs of the Shares offered by this Service
     * 
     */
    @JsonProperty("ShareID")
    public void setShareID(List<String> shareID) {
        this.shareID = shareID;
    }

    /**
     * The IDs of the Managers of this Service
     * 
     */
    @JsonProperty("ManagerID")
    public List<String> getManagerID() {
        return managerID;
    }

    /**
     * The IDs of the Managers of this Service
     * 
     */
    @JsonProperty("ManagerID")
    public void setManagerID(List<String> managerID) {
        this.managerID = managerID;
    }

    /**
     * The IDs of Contacts for this Service
     * 
     */
    @JsonProperty("ContactID")
    public List<String> getContactID() {
        return contactID;
    }

    /**
     * The IDs of Contacts for this Service
     * 
     */
    @JsonProperty("ContactID")
    public void setContactID(List<String> contactID) {
        this.contactID = contactID;
    }

    /**
     * The ID of the primary Location of this Service
     * 
     */
    @JsonProperty("LocationID")
    public String getLocationID() {
        return locationID;
    }

    /**
     * The ID of the primary Location of this Service
     * 
     */
    @JsonProperty("LocationID")
    public void setLocationID(String locationID) {
        this.locationID = locationID;
    }

    /**
     * The IDs of Services related to this Service
     * 
     */
    @JsonProperty("ServiceID")
    public List<String> getServiceID() {
        return serviceID;
    }

    /**
     * The IDs of Services related to this Service
     * 
     */
    @JsonProperty("ServiceID")
    public void setServiceID(List<String> serviceID) {
        this.serviceID = serviceID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum QualityLevel {

        DEVELOPMENT("development"),
        PRE_PRODUCTION("pre-production"),
        PRODUCTION("production"),
        TESTING("testing");
        private final String value;
        private static Map<String, Service_.QualityLevel> constants = new HashMap<String, Service_.QualityLevel>();

        static {
            for (Service_.QualityLevel c: Service_.QualityLevel.values()) {
                constants.put(c.value, c);
            }
        }

        private QualityLevel(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Service_.QualityLevel fromValue(String value) {
            Service_.QualityLevel constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
