
package org.apache.airavata;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Type",
    "TotalSize",
    "FreeSize",
    "UsedSize",
    "ReservedSize",
    "StorageServiceID"
})
public class StorageServiceCapacity_ {

    /**
     * The type of storage capacity - StorageCapacity_t
     * 
     */
    @JsonProperty("Type")
    private String type;
    /**
     * The total amount of storage of this type (GB)
     * 
     */
    @JsonProperty("TotalSize")
    private Integer totalSize;
    /**
     * The amount of currently available storage of this type (GB)
     * 
     */
    @JsonProperty("FreeSize")
    private Integer freeSize;
    /**
     * The amount storage of this type in use (GB)
     * 
     */
    @JsonProperty("UsedSize")
    private Integer usedSize;
    /**
     * The amount storage of this type which is not in use, but has been reserved for use in use (GB)
     * 
     */
    @JsonProperty("ReservedSize")
    private Integer reservedSize;
    /**
     * The ID of the StorageService this capacity describes
     * 
     */
    @JsonProperty("StorageServiceID")
    private String storageServiceID;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The type of storage capacity - StorageCapacity_t
     * 
     */
    @JsonProperty("Type")
    public String getType() {
        return type;
    }

    /**
     * The type of storage capacity - StorageCapacity_t
     * 
     */
    @JsonProperty("Type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * The total amount of storage of this type (GB)
     * 
     */
    @JsonProperty("TotalSize")
    public Integer getTotalSize() {
        return totalSize;
    }

    /**
     * The total amount of storage of this type (GB)
     * 
     */
    @JsonProperty("TotalSize")
    public void setTotalSize(Integer totalSize) {
        this.totalSize = totalSize;
    }

    /**
     * The amount of currently available storage of this type (GB)
     * 
     */
    @JsonProperty("FreeSize")
    public Integer getFreeSize() {
        return freeSize;
    }

    /**
     * The amount of currently available storage of this type (GB)
     * 
     */
    @JsonProperty("FreeSize")
    public void setFreeSize(Integer freeSize) {
        this.freeSize = freeSize;
    }

    /**
     * The amount storage of this type in use (GB)
     * 
     */
    @JsonProperty("UsedSize")
    public Integer getUsedSize() {
        return usedSize;
    }

    /**
     * The amount storage of this type in use (GB)
     * 
     */
    @JsonProperty("UsedSize")
    public void setUsedSize(Integer usedSize) {
        this.usedSize = usedSize;
    }

    /**
     * The amount storage of this type which is not in use, but has been reserved for use in use (GB)
     * 
     */
    @JsonProperty("ReservedSize")
    public Integer getReservedSize() {
        return reservedSize;
    }

    /**
     * The amount storage of this type which is not in use, but has been reserved for use in use (GB)
     * 
     */
    @JsonProperty("ReservedSize")
    public void setReservedSize(Integer reservedSize) {
        this.reservedSize = reservedSize;
    }

    /**
     * The ID of the StorageService this capacity describes
     * 
     */
    @JsonProperty("StorageServiceID")
    public String getStorageServiceID() {
        return storageServiceID;
    }

    /**
     * The ID of the StorageService this capacity describes
     * 
     */
    @JsonProperty("StorageServiceID")
    public void setStorageServiceID(String storageServiceID) {
        this.storageServiceID = storageServiceID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
