
package org.apache.airavata;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Type",
    "TotalSize",
    "FreeSize",
    "UsedSize",
    "ReservedSize",
    "StorageShareID"
})
public class StorageShareCapacity_ {

    /**
     * The type of storage capacity - StorageCapacity_t
     * 
     */
    @JsonProperty("Type")
    private String type;
    /**
     * The total amount of storage (GB)
     * 
     */
    @JsonProperty("TotalSize")
    private Integer totalSize;
    /**
     * The amount of available storage (GB)
     * 
     */
    @JsonProperty("FreeSize")
    private Integer freeSize;
    /**
     * The amount of used storage (GB)
     * 
     */
    @JsonProperty("UsedSize")
    private Integer usedSize;
    /**
     * The amount storage which is not occupied, but has been reserved for use (GB)
     * 
     */
    @JsonProperty("ReservedSize")
    private Integer reservedSize;
    /**
     * The ID of the StorageShare related to this capacity
     * 
     */
    @JsonProperty("StorageShareID")
    private String storageShareID;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The type of storage capacity - StorageCapacity_t
     * 
     */
    @JsonProperty("Type")
    public String getType() {
        return type;
    }

    /**
     * The type of storage capacity - StorageCapacity_t
     * 
     */
    @JsonProperty("Type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * The total amount of storage (GB)
     * 
     */
    @JsonProperty("TotalSize")
    public Integer getTotalSize() {
        return totalSize;
    }

    /**
     * The total amount of storage (GB)
     * 
     */
    @JsonProperty("TotalSize")
    public void setTotalSize(Integer totalSize) {
        this.totalSize = totalSize;
    }

    /**
     * The amount of available storage (GB)
     * 
     */
    @JsonProperty("FreeSize")
    public Integer getFreeSize() {
        return freeSize;
    }

    /**
     * The amount of available storage (GB)
     * 
     */
    @JsonProperty("FreeSize")
    public void setFreeSize(Integer freeSize) {
        this.freeSize = freeSize;
    }

    /**
     * The amount of used storage (GB)
     * 
     */
    @JsonProperty("UsedSize")
    public Integer getUsedSize() {
        return usedSize;
    }

    /**
     * The amount of used storage (GB)
     * 
     */
    @JsonProperty("UsedSize")
    public void setUsedSize(Integer usedSize) {
        this.usedSize = usedSize;
    }

    /**
     * The amount storage which is not occupied, but has been reserved for use (GB)
     * 
     */
    @JsonProperty("ReservedSize")
    public Integer getReservedSize() {
        return reservedSize;
    }

    /**
     * The amount storage which is not occupied, but has been reserved for use (GB)
     * 
     */
    @JsonProperty("ReservedSize")
    public void setReservedSize(Integer reservedSize) {
        this.reservedSize = reservedSize;
    }

    /**
     * The ID of the StorageShare related to this capacity
     * 
     */
    @JsonProperty("StorageShareID")
    public String getStorageShareID() {
        return storageShareID;
    }

    /**
     * The ID of the StorageShare related to this capacity
     * 
     */
    @JsonProperty("StorageShareID")
    public void setStorageShareID(String storageShareID) {
        this.storageShareID = storageShareID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
