
package org.apache.airavata;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "LocalPath",
    "RemotePath",
    "ComputingServiceID",
    "StorageServiceID"
})
public class ToStorageService_ {

    /**
     * The path within the ComputingService that is used to access the StorageService
     * 
     */
    @JsonProperty("LocalPath")
    private String localPath;
    /**
     * The path in the StorageService which is associated with the LocalPath
     * 
     */
    @JsonProperty("RemotePath")
    private String remotePath;
    /**
     * The ID of the ComputingService
     * 
     */
    @JsonProperty("ComputingServiceID")
    private String computingServiceID;
    /**
     * The ID of the StorageService
     * 
     */
    @JsonProperty("StorageServiceID")
    private String storageServiceID;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The path within the ComputingService that is used to access the StorageService
     * 
     */
    @JsonProperty("LocalPath")
    public String getLocalPath() {
        return localPath;
    }

    /**
     * The path within the ComputingService that is used to access the StorageService
     * 
     */
    @JsonProperty("LocalPath")
    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    /**
     * The path in the StorageService which is associated with the LocalPath
     * 
     */
    @JsonProperty("RemotePath")
    public String getRemotePath() {
        return remotePath;
    }

    /**
     * The path in the StorageService which is associated with the LocalPath
     * 
     */
    @JsonProperty("RemotePath")
    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    /**
     * The ID of the ComputingService
     * 
     */
    @JsonProperty("ComputingServiceID")
    public String getComputingServiceID() {
        return computingServiceID;
    }

    /**
     * The ID of the ComputingService
     * 
     */
    @JsonProperty("ComputingServiceID")
    public void setComputingServiceID(String computingServiceID) {
        this.computingServiceID = computingServiceID;
    }

    /**
     * The ID of the StorageService
     * 
     */
    @JsonProperty("StorageServiceID")
    public String getStorageServiceID() {
        return storageServiceID;
    }

    /**
     * The ID of the StorageService
     * 
     */
    @JsonProperty("StorageServiceID")
    public void setStorageServiceID(String storageServiceID) {
        this.storageServiceID = storageServiceID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
