
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Level",
    "UserManagerID",
    "Member",
    "PolicyID",
    "ChildDomainID",
    "ParentDomainID",
    "AccessPolicyID",
    "MappingPolicyID"
})
public class UserDomain_ {

    /**
     * the number of hops to reach the root of the hierarchy of UserDomains
     * 
     */
    @JsonProperty("Level")
    private Integer level;
    /**
     * ID for the Endpoint of a Service managing users in this UserDomain
     * 
     */
    @JsonProperty("UserManagerID")
    private List<String> userManagerID = new ArrayList<String>();
    /**
     * Identifiers for users in this UserDomain
     * 
     */
    @JsonProperty("Member")
    private List<String> member = new ArrayList<String>();
    /**
     * IDs for Policies associated with this UserDomain
     * 
     */
    @JsonProperty("PolicyID")
    private List<String> policyID = new ArrayList<String>();
    /**
     * IDs of UserDomains aggregated by this UserDomain
     * 
     */
    @JsonProperty("ChildDomainID")
    private List<String> childDomainID = new ArrayList<String>();
    /**
     * The ID of the UserDomain that this UserDomain participates in
     * 
     */
    @JsonProperty("ParentDomainID")
    private String parentDomainID;
    /**
     * IDs of AccessPolicies associated with this UserDomain
     * 
     */
    @JsonProperty("AccessPolicyID")
    private List<String> accessPolicyID = new ArrayList<String>();
    /**
     * IDs of MappingPolicies associated with this UserDomain
     * 
     */
    @JsonProperty("MappingPolicyID")
    private List<String> mappingPolicyID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * the number of hops to reach the root of the hierarchy of UserDomains
     * 
     */
    @JsonProperty("Level")
    public Integer getLevel() {
        return level;
    }

    /**
     * the number of hops to reach the root of the hierarchy of UserDomains
     * 
     */
    @JsonProperty("Level")
    public void setLevel(Integer level) {
        this.level = level;
    }

    /**
     * ID for the Endpoint of a Service managing users in this UserDomain
     * 
     */
    @JsonProperty("UserManagerID")
    public List<String> getUserManagerID() {
        return userManagerID;
    }

    /**
     * ID for the Endpoint of a Service managing users in this UserDomain
     * 
     */
    @JsonProperty("UserManagerID")
    public void setUserManagerID(List<String> userManagerID) {
        this.userManagerID = userManagerID;
    }

    /**
     * Identifiers for users in this UserDomain
     * 
     */
    @JsonProperty("Member")
    public List<String> getMember() {
        return member;
    }

    /**
     * Identifiers for users in this UserDomain
     * 
     */
    @JsonProperty("Member")
    public void setMember(List<String> member) {
        this.member = member;
    }

    /**
     * IDs for Policies associated with this UserDomain
     * 
     */
    @JsonProperty("PolicyID")
    public List<String> getPolicyID() {
        return policyID;
    }

    /**
     * IDs for Policies associated with this UserDomain
     * 
     */
    @JsonProperty("PolicyID")
    public void setPolicyID(List<String> policyID) {
        this.policyID = policyID;
    }

    /**
     * IDs of UserDomains aggregated by this UserDomain
     * 
     */
    @JsonProperty("ChildDomainID")
    public List<String> getChildDomainID() {
        return childDomainID;
    }

    /**
     * IDs of UserDomains aggregated by this UserDomain
     * 
     */
    @JsonProperty("ChildDomainID")
    public void setChildDomainID(List<String> childDomainID) {
        this.childDomainID = childDomainID;
    }

    /**
     * The ID of the UserDomain that this UserDomain participates in
     * 
     */
    @JsonProperty("ParentDomainID")
    public String getParentDomainID() {
        return parentDomainID;
    }

    /**
     * The ID of the UserDomain that this UserDomain participates in
     * 
     */
    @JsonProperty("ParentDomainID")
    public void setParentDomainID(String parentDomainID) {
        this.parentDomainID = parentDomainID;
    }

    /**
     * IDs of AccessPolicies associated with this UserDomain
     * 
     */
    @JsonProperty("AccessPolicyID")
    public List<String> getAccessPolicyID() {
        return accessPolicyID;
    }

    /**
     * IDs of AccessPolicies associated with this UserDomain
     * 
     */
    @JsonProperty("AccessPolicyID")
    public void setAccessPolicyID(List<String> accessPolicyID) {
        this.accessPolicyID = accessPolicyID;
    }

    /**
     * IDs of MappingPolicies associated with this UserDomain
     * 
     */
    @JsonProperty("MappingPolicyID")
    public List<String> getMappingPolicyID() {
        return mappingPolicyID;
    }

    /**
     * IDs of MappingPolicies associated with this UserDomain
     * 
     */
    @JsonProperty("MappingPolicyID")
    public void setMappingPolicyID(List<String> mappingPolicyID) {
        this.mappingPolicyID = mappingPolicyID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
