/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.handlers;

import java.util.Properties;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.cpi.GFacImpl;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.handler.ThreadedHandler;
import org.apache.airavata.gfac.monitor.HPCMonitorID;
import org.apache.airavata.gfac.monitor.exception.AiravataMonitorException;
import org.apache.airavata.gfac.monitor.impl.pull.qstat.HPCPullMonitor;
import org.apache.airavata.gfac.monitor.util.CommonUtils;
import org.apache.airavata.gsi.ssh.api.authentication.AuthenticationInfo;
import org.apache.airavata.gsi.ssh.impl.authentication.MyProxyAuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridPullMonitorHandler
extends ThreadedHandler {
    private static final Logger logger = LoggerFactory.getLogger(GridPullMonitorHandler.class);
    private HPCPullMonitor hpcPullMonitor;
    private AuthenticationInfo authenticationInfo;

    public void initProperties(Properties properties) throws GFacHandlerException {
        String myProxyUser = null;
        try {
            myProxyUser = ServerSettings.getSetting((String)"myproxy.username");
            String myProxyPass = ServerSettings.getSetting((String)"myproxy.password");
            String certPath = ServerSettings.getSetting((String)"trusted.cert.location");
            String myProxyServer = ServerSettings.getSetting((String)"myproxy.server");
            this.setAuthenticationInfo((AuthenticationInfo)new MyProxyAuthenticationInfo(myProxyUser, myProxyPass, myProxyServer, 7512, 17280000, certPath));
            this.hpcPullMonitor = new HPCPullMonitor(GFacImpl.getMonitorPublisher());
        }
        catch (ApplicationSettingsException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.hpcPullMonitor.run();
    }

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        super.invoke(jobExecutionContext);
        HPCMonitorID monitorID = new HPCMonitorID(this.getAuthenticationInfo(), jobExecutionContext);
        try {
            CommonUtils.addMonitortoQueue(this.hpcPullMonitor.getQueue(), monitorID);
        }
        catch (AiravataMonitorException e) {
            logger.error("Error adding monitorID object to the queue with experiment ", (Object)monitorID.getExperimentID());
        }
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public HPCPullMonitor getHpcPullMonitor() {
        return this.hpcPullMonitor;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
    }

    public void setHpcPullMonitor(HPCPullMonitor hpcPullMonitor) {
        this.hpcPullMonitor = hpcPullMonitor;
    }
}

