/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.monitor.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.cpi.GFacImpl;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.handler.ThreadedHandler;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.monitor.HPCMonitorID;
import org.apache.airavata.gfac.monitor.impl.push.amqp.AMQPMonitor;
import org.apache.airavata.gsi.ssh.api.authentication.AuthenticationInfo;
import org.apache.airavata.gsi.ssh.impl.authentication.MyProxyAuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridPushMonitorHandler
extends ThreadedHandler {
    private static final Logger logger = LoggerFactory.getLogger(GridPushMonitorHandler.class);
    private AMQPMonitor amqpMonitor;
    private AuthenticationInfo authenticationInfo;

    public void initProperties(Properties properties) throws GFacHandlerException {
        String myProxyUser = null;
        try {
            myProxyUser = ServerSettings.getSetting((String)"myproxy.username");
            String myProxyPass = ServerSettings.getSetting((String)"myproxy.password");
            String certPath = ServerSettings.getSetting((String)"trusted.cert.location");
            String myProxyServer = ServerSettings.getSetting((String)"myproxy.server");
            this.setAuthenticationInfo((AuthenticationInfo)new MyProxyAuthenticationInfo(myProxyUser, myProxyPass, myProxyServer, 7512, 17280000, certPath));
            String hostList = (String)properties.get("hosts");
            String proxyFilePath = ServerSettings.getSetting((String)"proxy.file.path");
            String connectionName = ServerSettings.getSetting((String)"connection.name");
            LinkedBlockingQueue<MonitorID> pushQueue = new LinkedBlockingQueue<MonitorID>();
            LinkedBlockingQueue<MonitorID> finishQueue = new LinkedBlockingQueue<MonitorID>();
            List<String> hosts = Arrays.asList(hostList.split(","));
            this.amqpMonitor = new AMQPMonitor(GFacImpl.getMonitorPublisher(), pushQueue, finishQueue, proxyFilePath, connectionName, hosts);
        }
        catch (ApplicationSettingsException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        this.amqpMonitor.run();
    }

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        super.invoke(jobExecutionContext);
        HPCMonitorID monitorID = new HPCMonitorID(this.getAuthenticationInfo(), jobExecutionContext);
        this.amqpMonitor.getRunningQueue().add(monitorID);
    }

    public AMQPMonitor getAmqpMonitor() {
        return this.amqpMonitor;
    }

    public void setAmqpMonitor(AMQPMonitor amqpMonitor) {
        this.amqpMonitor = amqpMonitor;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
    }
}

