
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "AppName",
    "AppVersion",
    "State",
    "RemovalDate",
    "License",
    "Description",
    "BestBenchmark",
    "ParallelSupport",
    "MaxSlots",
    "MaxJobs",
    "MaxUserSeats",
    "FreeSlots",
    "FreeJobs",
    "FreeUserSeats",
    "ExecutionEnvironmentID",
    "ComputingManagerID",
    "ApplicationHandleID"
})
public class ApplicationEnvironment {

    /**
     * The name of the application
     * 
     */
    @JsonProperty("AppName")
    private String appName;
    /**
     * The version of the application
     * 
     */
    @JsonProperty("AppVersion")
    private String appVersion;
    /**
     * The current installation state of the application - AppEnvState_t
     * 
     */
    @JsonProperty("State")
    private String state;
    /**
     * The date/time after which the application may be removed - DateTime_t
     * 
     */
    @JsonProperty("RemovalDate")
    private String removalDate;
    /**
     * The license under which the application is usable - License_t
     * 
     */
    @JsonProperty("License")
    private String license;
    /**
     * A human-readable description of the application
     * 
     */
    @JsonProperty("Description")
    private String description;
    /**
     * The type(s) of the benchmarks which best describe the sensitivity of this application to the performance of the ExecutionEnvironment - Benchmark_t
     * 
     */
    @JsonProperty("BestBenchmark")
    private List<String> bestBenchmark = new ArrayList<String>();
    /**
     * The type of supported parallel execution - ParallelSupport_t
     * 
     */
    @JsonProperty("ParallelSupport")
    private String parallelSupport;
    /**
     * The maximum number of concurrent slots that may be used to run the application
     * 
     */
    @JsonProperty("MaxSlots")
    private Integer maxSlots;
    /**
     * The maximum number of concurrent jobs that can run the application
     * 
     */
    @JsonProperty("MaxJobs")
    private Integer maxJobs;
    /**
     * The maximum number of concurrent users that can run the application
     * 
     */
    @JsonProperty("MaxUserSeats")
    private Integer maxUserSeats;
    /**
     * The maximum number slots currently available to run the application
     * 
     */
    @JsonProperty("FreeSlots")
    private Integer freeSlots;
    /**
     * The maximum number of additional jobs that can run the application
     * 
     */
    @JsonProperty("FreeJobs")
    private Integer freeJobs;
    /**
     * The maximum number of additional users that can run the application
     * 
     */
    @JsonProperty("FreeUserSeats")
    private Integer freeUserSeats;
    /**
     * ID(s) of ExecutionEnvironments where this ApplicationEnvironment can be used
     * 
     */
    @JsonProperty("ExecutionEnvironmentID")
    private List<String> executionEnvironmentID = new ArrayList<String>();
    /**
     * ID of the ComputingManager this ApplicationEnvironment is associated with
     * 
     */
    @JsonProperty("ComputingManagerID")
    private String computingManagerID;
    /**
     * ID(s) of the ApplicationHandles that can be used to refer to this environment
     * 
     */
    @JsonProperty("ApplicationHandleID")
    private List<String> applicationHandleID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The name of the application
     * 
     */
    @JsonProperty("AppName")
    public String getAppName() {
        return appName;
    }

    /**
     * The name of the application
     * 
     */
    @JsonProperty("AppName")
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * The version of the application
     * 
     */
    @JsonProperty("AppVersion")
    public String getAppVersion() {
        return appVersion;
    }

    /**
     * The version of the application
     * 
     */
    @JsonProperty("AppVersion")
    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    /**
     * The current installation state of the application - AppEnvState_t
     * 
     */
    @JsonProperty("State")
    public String getState() {
        return state;
    }

    /**
     * The current installation state of the application - AppEnvState_t
     * 
     */
    @JsonProperty("State")
    public void setState(String state) {
        this.state = state;
    }

    /**
     * The date/time after which the application may be removed - DateTime_t
     * 
     */
    @JsonProperty("RemovalDate")
    public String getRemovalDate() {
        return removalDate;
    }

    /**
     * The date/time after which the application may be removed - DateTime_t
     * 
     */
    @JsonProperty("RemovalDate")
    public void setRemovalDate(String removalDate) {
        this.removalDate = removalDate;
    }

    /**
     * The license under which the application is usable - License_t
     * 
     */
    @JsonProperty("License")
    public String getLicense() {
        return license;
    }

    /**
     * The license under which the application is usable - License_t
     * 
     */
    @JsonProperty("License")
    public void setLicense(String license) {
        this.license = license;
    }

    /**
     * A human-readable description of the application
     * 
     */
    @JsonProperty("Description")
    public String getDescription() {
        return description;
    }

    /**
     * A human-readable description of the application
     * 
     */
    @JsonProperty("Description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The type(s) of the benchmarks which best describe the sensitivity of this application to the performance of the ExecutionEnvironment - Benchmark_t
     * 
     */
    @JsonProperty("BestBenchmark")
    public List<String> getBestBenchmark() {
        return bestBenchmark;
    }

    /**
     * The type(s) of the benchmarks which best describe the sensitivity of this application to the performance of the ExecutionEnvironment - Benchmark_t
     * 
     */
    @JsonProperty("BestBenchmark")
    public void setBestBenchmark(List<String> bestBenchmark) {
        this.bestBenchmark = bestBenchmark;
    }

    /**
     * The type of supported parallel execution - ParallelSupport_t
     * 
     */
    @JsonProperty("ParallelSupport")
    public String getParallelSupport() {
        return parallelSupport;
    }

    /**
     * The type of supported parallel execution - ParallelSupport_t
     * 
     */
    @JsonProperty("ParallelSupport")
    public void setParallelSupport(String parallelSupport) {
        this.parallelSupport = parallelSupport;
    }

    /**
     * The maximum number of concurrent slots that may be used to run the application
     * 
     */
    @JsonProperty("MaxSlots")
    public Integer getMaxSlots() {
        return maxSlots;
    }

    /**
     * The maximum number of concurrent slots that may be used to run the application
     * 
     */
    @JsonProperty("MaxSlots")
    public void setMaxSlots(Integer maxSlots) {
        this.maxSlots = maxSlots;
    }

    /**
     * The maximum number of concurrent jobs that can run the application
     * 
     */
    @JsonProperty("MaxJobs")
    public Integer getMaxJobs() {
        return maxJobs;
    }

    /**
     * The maximum number of concurrent jobs that can run the application
     * 
     */
    @JsonProperty("MaxJobs")
    public void setMaxJobs(Integer maxJobs) {
        this.maxJobs = maxJobs;
    }

    /**
     * The maximum number of concurrent users that can run the application
     * 
     */
    @JsonProperty("MaxUserSeats")
    public Integer getMaxUserSeats() {
        return maxUserSeats;
    }

    /**
     * The maximum number of concurrent users that can run the application
     * 
     */
    @JsonProperty("MaxUserSeats")
    public void setMaxUserSeats(Integer maxUserSeats) {
        this.maxUserSeats = maxUserSeats;
    }

    /**
     * The maximum number slots currently available to run the application
     * 
     */
    @JsonProperty("FreeSlots")
    public Integer getFreeSlots() {
        return freeSlots;
    }

    /**
     * The maximum number slots currently available to run the application
     * 
     */
    @JsonProperty("FreeSlots")
    public void setFreeSlots(Integer freeSlots) {
        this.freeSlots = freeSlots;
    }

    /**
     * The maximum number of additional jobs that can run the application
     * 
     */
    @JsonProperty("FreeJobs")
    public Integer getFreeJobs() {
        return freeJobs;
    }

    /**
     * The maximum number of additional jobs that can run the application
     * 
     */
    @JsonProperty("FreeJobs")
    public void setFreeJobs(Integer freeJobs) {
        this.freeJobs = freeJobs;
    }

    /**
     * The maximum number of additional users that can run the application
     * 
     */
    @JsonProperty("FreeUserSeats")
    public Integer getFreeUserSeats() {
        return freeUserSeats;
    }

    /**
     * The maximum number of additional users that can run the application
     * 
     */
    @JsonProperty("FreeUserSeats")
    public void setFreeUserSeats(Integer freeUserSeats) {
        this.freeUserSeats = freeUserSeats;
    }

    /**
     * ID(s) of ExecutionEnvironments where this ApplicationEnvironment can be used
     * 
     */
    @JsonProperty("ExecutionEnvironmentID")
    public List<String> getExecutionEnvironmentID() {
        return executionEnvironmentID;
    }

    /**
     * ID(s) of ExecutionEnvironments where this ApplicationEnvironment can be used
     * 
     */
    @JsonProperty("ExecutionEnvironmentID")
    public void setExecutionEnvironmentID(List<String> executionEnvironmentID) {
        this.executionEnvironmentID = executionEnvironmentID;
    }

    /**
     * ID of the ComputingManager this ApplicationEnvironment is associated with
     * 
     */
    @JsonProperty("ComputingManagerID")
    public String getComputingManagerID() {
        return computingManagerID;
    }

    /**
     * ID of the ComputingManager this ApplicationEnvironment is associated with
     * 
     */
    @JsonProperty("ComputingManagerID")
    public void setComputingManagerID(String computingManagerID) {
        this.computingManagerID = computingManagerID;
    }

    /**
     * ID(s) of the ApplicationHandles that can be used to refer to this environment
     * 
     */
    @JsonProperty("ApplicationHandleID")
    public List<String> getApplicationHandleID() {
        return applicationHandleID;
    }

    /**
     * ID(s) of the ApplicationHandles that can be used to refer to this environment
     * 
     */
    @JsonProperty("ApplicationHandleID")
    public void setApplicationHandleID(List<String> applicationHandleID) {
        this.applicationHandleID = applicationHandleID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
