
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "Type",
    "IDFromEndpoint",
    "LocalIDFromManager",
    "State",
    "RestartState",
    "ExitCode",
    "ComputingManagerExitCode",
    "Error",
    "WaitingPosition",
    "Owner",
    "LocalOwner",
    "RequestedTotalWallTime",
    "RequestedTotalCPUTime",
    "RequestedSlots",
    "RequestedApplicationEnvironment",
    "StdIn",
    "StdOut",
    "StdErr",
    "LogDir",
    "ExecutionNode",
    "Queue",
    "UsedTotalWallTime",
    "UsedTotalCpuTime",
    "UsedMainMemory",
    "SubmissionTime",
    "ComputingManagerSubmissionTime",
    "StartTime",
    "EndTime",
    "ComputingManagerEndTime",
    "WorkingAreaEraseTime",
    "ProxyExpirationTime",
    "SubmissionHost",
    "SubmissionClientName",
    "OtherMessages"
})
public class ComputingActivity {

    /**
     * closed enumeration ComputingActivityType_t
     * 
     */
    @JsonProperty("Type")
    private ComputingActivity.Type type;
    /**
     * The ID assigned by the ComputingEndpoint
     * 
     */
    @JsonProperty("IDFromEndpoint")
    private String iDFromEndpoint;
    /**
     * The local ID assigned by the ComputingManager
     * 
     */
    @JsonProperty("LocalIDFromManager")
    private String localIDFromManager;
    /**
     * open enumeration ComputingActivityState_t
     * 
     */
    @JsonProperty("State")
    private List<String> state = new ArrayList<String>();
    /**
     * open enumeration ComputingActivityState_t
     * 
     */
    @JsonProperty("RestartState")
    private List<String> restartState = new ArrayList<String>();
    /**
     * The exit code as returned by the main executable code or script of the job
     * 
     */
    @JsonProperty("ExitCode")
    private Integer exitCode;
    /**
     * The exit code provided by the ComputingManager
     * 
     */
    @JsonProperty("ComputingManagerExitCode")
    private String computingManagerExitCode;
    /**
     * The error messages as provided by the software components involved in the management of the job
     * 
     */
    @JsonProperty("Error")
    private List<String> error = new ArrayList<String>();
    /**
     * The position of the job in the queue, if the job is waiting
     * 
     */
    @JsonProperty("WaitingPosition")
    private Integer waitingPosition;
    /**
     * The Grid identity of the job's owner
     * 
     */
    @JsonProperty("Owner")
    private String owner;
    /**
     * The local user name of the job's owner
     * 
     */
    @JsonProperty("LocalOwner")
    private String localOwner;
    /**
     * The total wall clock time requested by the job
     * 
     */
    @JsonProperty("RequestedTotalWallTime")
    private Integer requestedTotalWallTime;
    /**
     * The total CPU time requested by the job
     * 
     */
    @JsonProperty("RequestedTotalCPUTime")
    private Integer requestedTotalCPUTime;
    /**
     * The number of slots requested for the job
     * 
     */
    @JsonProperty("RequestedSlots")
    private Integer requestedSlots;
    /**
     * The AppName and Version of the requested ApplicationEnvironments
     * 
     */
    @JsonProperty("RequestedApplicationEnvironment")
    private List<String> requestedApplicationEnvironment = new ArrayList<String>();
    /**
     * The name of the file used for standard input
     * 
     */
    @JsonProperty("StdIn")
    private String stdIn;
    /**
     * The name of the file used for standard output
     * 
     */
    @JsonProperty("StdOut")
    private String stdOut;
    /**
     * The name of the file used for standard error
     * 
     */
    @JsonProperty("StdErr")
    private String stdErr;
    /**
     * The name of the directory which contains job logs
     * 
     */
    @JsonProperty("LogDir")
    private String logDir;
    /**
     * Hostnames associated with the ExecutionEnvironments running the job
     * 
     */
    @JsonProperty("ExecutionNode")
    private List<String> executionNode = new ArrayList<String>();
    /**
     * The name of the ComputingManager queue that held the job before execution
     * 
     */
    @JsonProperty("Queue")
    private String queue;
    /**
     * The total wall clock time consumed by the job so far (slots*seconds)
     * 
     */
    @JsonProperty("UsedTotalWallTime")
    private Integer usedTotalWallTime;
    /**
     * The total CPU time consumed by the job so far (seconds)
     * 
     */
    @JsonProperty("UsedTotalCpuTime")
    private Integer usedTotalCpuTime;
    /**
     * The physical RAM currently used by the job (MB)
     * 
     */
    @JsonProperty("UsedMainMemory")
    private Integer usedMainMemory;
    /**
     * The time when the job was submitted to the ComputingEndpoint (DateTime_t)
     * 
     */
    @JsonProperty("SubmissionTime")
    private String submissionTime;
    /**
     * The time when the job was submitted to the ComputingManager (DateTime_t)
     * 
     */
    @JsonProperty("ComputingManagerSubmissionTime")
    private String computingManagerSubmissionTime;
    /**
     * The time when the ComputingManager started the job (DateTime_t)
     * 
     */
    @JsonProperty("StartTime")
    private String startTime;
    /**
     * The time when the job ended in the Grid layer (DateTime_t)
     * 
     */
    @JsonProperty("EndTime")
    private String endTime;
    /**
     * The time when the job ended according to the ComputingManager (DateTime_t)
     * 
     */
    @JsonProperty("ComputingManagerEndTime")
    private String computingManagerEndTime;
    /**
     * The time when working area will be removed from storage (DateTime_t)
     * 
     */
    @JsonProperty("WorkingAreaEraseTime")
    private String workingAreaEraseTime;
    /**
     * The expiration time of the Grid proxy associated with the job (DateTime_t)
     * 
     */
    @JsonProperty("ProxyExpirationTime")
    private String proxyExpirationTime;
    /**
     * The name of the host from which the job was submitted
     * 
     */
    @JsonProperty("SubmissionHost")
    private String submissionHost;
    /**
     * The name of the software client used to submit the job
     * 
     */
    @JsonProperty("SubmissionClientName")
    private String submissionClientName;
    /**
     * Optional messages provided by either the Grid layer or the ComputingManager
     * 
     */
    @JsonProperty("OtherMessages")
    private List<String> otherMessages = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * closed enumeration ComputingActivityType_t
     * 
     */
    @JsonProperty("Type")
    public ComputingActivity.Type getType() {
        return type;
    }

    /**
     * closed enumeration ComputingActivityType_t
     * 
     */
    @JsonProperty("Type")
    public void setType(ComputingActivity.Type type) {
        this.type = type;
    }

    /**
     * The ID assigned by the ComputingEndpoint
     * 
     */
    @JsonProperty("IDFromEndpoint")
    public String getIDFromEndpoint() {
        return iDFromEndpoint;
    }

    /**
     * The ID assigned by the ComputingEndpoint
     * 
     */
    @JsonProperty("IDFromEndpoint")
    public void setIDFromEndpoint(String iDFromEndpoint) {
        this.iDFromEndpoint = iDFromEndpoint;
    }

    /**
     * The local ID assigned by the ComputingManager
     * 
     */
    @JsonProperty("LocalIDFromManager")
    public String getLocalIDFromManager() {
        return localIDFromManager;
    }

    /**
     * The local ID assigned by the ComputingManager
     * 
     */
    @JsonProperty("LocalIDFromManager")
    public void setLocalIDFromManager(String localIDFromManager) {
        this.localIDFromManager = localIDFromManager;
    }

    /**
     * open enumeration ComputingActivityState_t
     * 
     */
    @JsonProperty("State")
    public List<String> getState() {
        return state;
    }

    /**
     * open enumeration ComputingActivityState_t
     * 
     */
    @JsonProperty("State")
    public void setState(List<String> state) {
        this.state = state;
    }

    /**
     * open enumeration ComputingActivityState_t
     * 
     */
    @JsonProperty("RestartState")
    public List<String> getRestartState() {
        return restartState;
    }

    /**
     * open enumeration ComputingActivityState_t
     * 
     */
    @JsonProperty("RestartState")
    public void setRestartState(List<String> restartState) {
        this.restartState = restartState;
    }

    /**
     * The exit code as returned by the main executable code or script of the job
     * 
     */
    @JsonProperty("ExitCode")
    public Integer getExitCode() {
        return exitCode;
    }

    /**
     * The exit code as returned by the main executable code or script of the job
     * 
     */
    @JsonProperty("ExitCode")
    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    /**
     * The exit code provided by the ComputingManager
     * 
     */
    @JsonProperty("ComputingManagerExitCode")
    public String getComputingManagerExitCode() {
        return computingManagerExitCode;
    }

    /**
     * The exit code provided by the ComputingManager
     * 
     */
    @JsonProperty("ComputingManagerExitCode")
    public void setComputingManagerExitCode(String computingManagerExitCode) {
        this.computingManagerExitCode = computingManagerExitCode;
    }

    /**
     * The error messages as provided by the software components involved in the management of the job
     * 
     */
    @JsonProperty("Error")
    public List<String> getError() {
        return error;
    }

    /**
     * The error messages as provided by the software components involved in the management of the job
     * 
     */
    @JsonProperty("Error")
    public void setError(List<String> error) {
        this.error = error;
    }

    /**
     * The position of the job in the queue, if the job is waiting
     * 
     */
    @JsonProperty("WaitingPosition")
    public Integer getWaitingPosition() {
        return waitingPosition;
    }

    /**
     * The position of the job in the queue, if the job is waiting
     * 
     */
    @JsonProperty("WaitingPosition")
    public void setWaitingPosition(Integer waitingPosition) {
        this.waitingPosition = waitingPosition;
    }

    /**
     * The Grid identity of the job's owner
     * 
     */
    @JsonProperty("Owner")
    public String getOwner() {
        return owner;
    }

    /**
     * The Grid identity of the job's owner
     * 
     */
    @JsonProperty("Owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    /**
     * The local user name of the job's owner
     * 
     */
    @JsonProperty("LocalOwner")
    public String getLocalOwner() {
        return localOwner;
    }

    /**
     * The local user name of the job's owner
     * 
     */
    @JsonProperty("LocalOwner")
    public void setLocalOwner(String localOwner) {
        this.localOwner = localOwner;
    }

    /**
     * The total wall clock time requested by the job
     * 
     */
    @JsonProperty("RequestedTotalWallTime")
    public Integer getRequestedTotalWallTime() {
        return requestedTotalWallTime;
    }

    /**
     * The total wall clock time requested by the job
     * 
     */
    @JsonProperty("RequestedTotalWallTime")
    public void setRequestedTotalWallTime(Integer requestedTotalWallTime) {
        this.requestedTotalWallTime = requestedTotalWallTime;
    }

    /**
     * The total CPU time requested by the job
     * 
     */
    @JsonProperty("RequestedTotalCPUTime")
    public Integer getRequestedTotalCPUTime() {
        return requestedTotalCPUTime;
    }

    /**
     * The total CPU time requested by the job
     * 
     */
    @JsonProperty("RequestedTotalCPUTime")
    public void setRequestedTotalCPUTime(Integer requestedTotalCPUTime) {
        this.requestedTotalCPUTime = requestedTotalCPUTime;
    }

    /**
     * The number of slots requested for the job
     * 
     */
    @JsonProperty("RequestedSlots")
    public Integer getRequestedSlots() {
        return requestedSlots;
    }

    /**
     * The number of slots requested for the job
     * 
     */
    @JsonProperty("RequestedSlots")
    public void setRequestedSlots(Integer requestedSlots) {
        this.requestedSlots = requestedSlots;
    }

    /**
     * The AppName and Version of the requested ApplicationEnvironments
     * 
     */
    @JsonProperty("RequestedApplicationEnvironment")
    public List<String> getRequestedApplicationEnvironment() {
        return requestedApplicationEnvironment;
    }

    /**
     * The AppName and Version of the requested ApplicationEnvironments
     * 
     */
    @JsonProperty("RequestedApplicationEnvironment")
    public void setRequestedApplicationEnvironment(List<String> requestedApplicationEnvironment) {
        this.requestedApplicationEnvironment = requestedApplicationEnvironment;
    }

    /**
     * The name of the file used for standard input
     * 
     */
    @JsonProperty("StdIn")
    public String getStdIn() {
        return stdIn;
    }

    /**
     * The name of the file used for standard input
     * 
     */
    @JsonProperty("StdIn")
    public void setStdIn(String stdIn) {
        this.stdIn = stdIn;
    }

    /**
     * The name of the file used for standard output
     * 
     */
    @JsonProperty("StdOut")
    public String getStdOut() {
        return stdOut;
    }

    /**
     * The name of the file used for standard output
     * 
     */
    @JsonProperty("StdOut")
    public void setStdOut(String stdOut) {
        this.stdOut = stdOut;
    }

    /**
     * The name of the file used for standard error
     * 
     */
    @JsonProperty("StdErr")
    public String getStdErr() {
        return stdErr;
    }

    /**
     * The name of the file used for standard error
     * 
     */
    @JsonProperty("StdErr")
    public void setStdErr(String stdErr) {
        this.stdErr = stdErr;
    }

    /**
     * The name of the directory which contains job logs
     * 
     */
    @JsonProperty("LogDir")
    public String getLogDir() {
        return logDir;
    }

    /**
     * The name of the directory which contains job logs
     * 
     */
    @JsonProperty("LogDir")
    public void setLogDir(String logDir) {
        this.logDir = logDir;
    }

    /**
     * Hostnames associated with the ExecutionEnvironments running the job
     * 
     */
    @JsonProperty("ExecutionNode")
    public List<String> getExecutionNode() {
        return executionNode;
    }

    /**
     * Hostnames associated with the ExecutionEnvironments running the job
     * 
     */
    @JsonProperty("ExecutionNode")
    public void setExecutionNode(List<String> executionNode) {
        this.executionNode = executionNode;
    }

    /**
     * The name of the ComputingManager queue that held the job before execution
     * 
     */
    @JsonProperty("Queue")
    public String getQueue() {
        return queue;
    }

    /**
     * The name of the ComputingManager queue that held the job before execution
     * 
     */
    @JsonProperty("Queue")
    public void setQueue(String queue) {
        this.queue = queue;
    }

    /**
     * The total wall clock time consumed by the job so far (slots*seconds)
     * 
     */
    @JsonProperty("UsedTotalWallTime")
    public Integer getUsedTotalWallTime() {
        return usedTotalWallTime;
    }

    /**
     * The total wall clock time consumed by the job so far (slots*seconds)
     * 
     */
    @JsonProperty("UsedTotalWallTime")
    public void setUsedTotalWallTime(Integer usedTotalWallTime) {
        this.usedTotalWallTime = usedTotalWallTime;
    }

    /**
     * The total CPU time consumed by the job so far (seconds)
     * 
     */
    @JsonProperty("UsedTotalCpuTime")
    public Integer getUsedTotalCpuTime() {
        return usedTotalCpuTime;
    }

    /**
     * The total CPU time consumed by the job so far (seconds)
     * 
     */
    @JsonProperty("UsedTotalCpuTime")
    public void setUsedTotalCpuTime(Integer usedTotalCpuTime) {
        this.usedTotalCpuTime = usedTotalCpuTime;
    }

    /**
     * The physical RAM currently used by the job (MB)
     * 
     */
    @JsonProperty("UsedMainMemory")
    public Integer getUsedMainMemory() {
        return usedMainMemory;
    }

    /**
     * The physical RAM currently used by the job (MB)
     * 
     */
    @JsonProperty("UsedMainMemory")
    public void setUsedMainMemory(Integer usedMainMemory) {
        this.usedMainMemory = usedMainMemory;
    }

    /**
     * The time when the job was submitted to the ComputingEndpoint (DateTime_t)
     * 
     */
    @JsonProperty("SubmissionTime")
    public String getSubmissionTime() {
        return submissionTime;
    }

    /**
     * The time when the job was submitted to the ComputingEndpoint (DateTime_t)
     * 
     */
    @JsonProperty("SubmissionTime")
    public void setSubmissionTime(String submissionTime) {
        this.submissionTime = submissionTime;
    }

    /**
     * The time when the job was submitted to the ComputingManager (DateTime_t)
     * 
     */
    @JsonProperty("ComputingManagerSubmissionTime")
    public String getComputingManagerSubmissionTime() {
        return computingManagerSubmissionTime;
    }

    /**
     * The time when the job was submitted to the ComputingManager (DateTime_t)
     * 
     */
    @JsonProperty("ComputingManagerSubmissionTime")
    public void setComputingManagerSubmissionTime(String computingManagerSubmissionTime) {
        this.computingManagerSubmissionTime = computingManagerSubmissionTime;
    }

    /**
     * The time when the ComputingManager started the job (DateTime_t)
     * 
     */
    @JsonProperty("StartTime")
    public String getStartTime() {
        return startTime;
    }

    /**
     * The time when the ComputingManager started the job (DateTime_t)
     * 
     */
    @JsonProperty("StartTime")
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    /**
     * The time when the job ended in the Grid layer (DateTime_t)
     * 
     */
    @JsonProperty("EndTime")
    public String getEndTime() {
        return endTime;
    }

    /**
     * The time when the job ended in the Grid layer (DateTime_t)
     * 
     */
    @JsonProperty("EndTime")
    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    /**
     * The time when the job ended according to the ComputingManager (DateTime_t)
     * 
     */
    @JsonProperty("ComputingManagerEndTime")
    public String getComputingManagerEndTime() {
        return computingManagerEndTime;
    }

    /**
     * The time when the job ended according to the ComputingManager (DateTime_t)
     * 
     */
    @JsonProperty("ComputingManagerEndTime")
    public void setComputingManagerEndTime(String computingManagerEndTime) {
        this.computingManagerEndTime = computingManagerEndTime;
    }

    /**
     * The time when working area will be removed from storage (DateTime_t)
     * 
     */
    @JsonProperty("WorkingAreaEraseTime")
    public String getWorkingAreaEraseTime() {
        return workingAreaEraseTime;
    }

    /**
     * The time when working area will be removed from storage (DateTime_t)
     * 
     */
    @JsonProperty("WorkingAreaEraseTime")
    public void setWorkingAreaEraseTime(String workingAreaEraseTime) {
        this.workingAreaEraseTime = workingAreaEraseTime;
    }

    /**
     * The expiration time of the Grid proxy associated with the job (DateTime_t)
     * 
     */
    @JsonProperty("ProxyExpirationTime")
    public String getProxyExpirationTime() {
        return proxyExpirationTime;
    }

    /**
     * The expiration time of the Grid proxy associated with the job (DateTime_t)
     * 
     */
    @JsonProperty("ProxyExpirationTime")
    public void setProxyExpirationTime(String proxyExpirationTime) {
        this.proxyExpirationTime = proxyExpirationTime;
    }

    /**
     * The name of the host from which the job was submitted
     * 
     */
    @JsonProperty("SubmissionHost")
    public String getSubmissionHost() {
        return submissionHost;
    }

    /**
     * The name of the host from which the job was submitted
     * 
     */
    @JsonProperty("SubmissionHost")
    public void setSubmissionHost(String submissionHost) {
        this.submissionHost = submissionHost;
    }

    /**
     * The name of the software client used to submit the job
     * 
     */
    @JsonProperty("SubmissionClientName")
    public String getSubmissionClientName() {
        return submissionClientName;
    }

    /**
     * The name of the software client used to submit the job
     * 
     */
    @JsonProperty("SubmissionClientName")
    public void setSubmissionClientName(String submissionClientName) {
        this.submissionClientName = submissionClientName;
    }

    /**
     * Optional messages provided by either the Grid layer or the ComputingManager
     * 
     */
    @JsonProperty("OtherMessages")
    public List<String> getOtherMessages() {
        return otherMessages;
    }

    /**
     * Optional messages provided by either the Grid layer or the ComputingManager
     * 
     */
    @JsonProperty("OtherMessages")
    public void setOtherMessages(List<String> otherMessages) {
        this.otherMessages = otherMessages;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum Type {

        COLLECTIONELEMENT("collectionelement"),
        PARALLELELEMENT("parallelelement"),
        SINGLE("single"),
        WORKFLOWNODE("workflownode");
        private final String value;
        private static Map<String, ComputingActivity.Type> constants = new HashMap<String, ComputingActivity.Type>();

        static {
            for (ComputingActivity.Type c: ComputingActivity.Type.values()) {
                constants.put(c.value, c);
            }
        }

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ComputingActivity.Type fromValue(String value) {
            ComputingActivity.Type constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
