
package org.apache.airavata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "URL",
    "Capability",
    "Technology",
    "InterfaceName",
    "InterfaceVersion",
    "InterfaceExtension",
    "WSDL",
    "SupportedProfile",
    "Semantics",
    "Implementor",
    "ImplementationName",
    "ImplementationVersion",
    "QualityLevel",
    "HealthState",
    "HealthStateInfo",
    "ServingState",
    "StartTime",
    "IssuerCA",
    "TrustedCA",
    "DowntimeAnnounce",
    "DowntimeStart",
    "DowntimeEnd",
    "DowntimeInfo",
    "ServiceID",
    "ShareID",
    "AccessPolicyID",
    "ActivityID"
})
public class Endpoint {

    /**
     * Network location of the endpoint
     * 
     */
    @JsonProperty("URL")
    private String uRL;
    /**
     * Capability_t (open enumeration)
     * 
     */
    @JsonProperty("Capability")
    private List<String> capability = new ArrayList<String>();
    /**
     * EndpointTechnology_t
     * 
     */
    @JsonProperty("Technology")
    private String technology;
    /**
     * InterfaceName_t
     * 
     */
    @JsonProperty("InterfaceName")
    private String interfaceName;
    /**
     * The version of the primary interface protocol (free format)
     * 
     */
    @JsonProperty("InterfaceVersion")
    private String interfaceVersion;
    /**
     * URIs identifying supported extensions to the interface protocol
     * 
     */
    @JsonProperty("InterfaceExtension")
    private List<String> interfaceExtension = new ArrayList<String>();
    /**
     * URLs of WSDL document(s) describing the interface
     * 
     */
    @JsonProperty("WSDL")
    private List<String> wSDL = new ArrayList<String>();
    /**
     * URI(s) identifying supported profiles for the Endpoint
     * 
     */
    @JsonProperty("SupportedProfile")
    private List<String> supportedProfile = new ArrayList<String>();
    /**
     * URL(s) of documents providing human-readable descriptions of the semantics of the Endpoint
     * 
     */
    @JsonProperty("Semantics")
    private List<String> semantics = new ArrayList<String>();
    /**
     * The name of the main organization implementing the Endpoint
     * 
     */
    @JsonProperty("Implementor")
    private String implementor;
    /**
     * The name of the implementation of the Endpoint
     * 
     */
    @JsonProperty("ImplementationName")
    private String implementationName;
    /**
     * The version of the implementation of the Endpoint
     * 
     */
    @JsonProperty("ImplementationVersion")
    private String implementationVersion;
    /**
     * QualityLevel_t
     * 
     */
    @JsonProperty("QualityLevel")
    private Endpoint.QualityLevel qualityLevel;
    /**
     * The operational status of the Endpoint
     * 
     */
    @JsonProperty("HealthState")
    private Endpoint.HealthState healthState;
    /**
     * A human-readable explanation of the HealthState of this Endpoint
     * 
     */
    @JsonProperty("HealthStateInfo")
    private String healthStateInfo;
    /**
     * If the endpoint is accepting and serving requests
     * 
     */
    @JsonProperty("ServingState")
    private Endpoint.ServingState servingState;
    /**
     * The start time of the Service associated with this Endpoint (DateTime_t)
     * 
     */
    @JsonProperty("StartTime")
    private String startTime;
    /**
     * The DN of the CA issuing the certificate presented by this Endpoint
     * 
     */
    @JsonProperty("IssuerCA")
    private String issuerCA;
    /**
     * DN(s) of CAs trusted by this Endpoint
     * 
     */
    @JsonProperty("TrustedCA")
    private List<String> trustedCA = new ArrayList<String>();
    /**
     * When the next scheduled downtime was announced (DateTime_t)
     * 
     */
    @JsonProperty("DowntimeAnnounce")
    private String downtimeAnnounce;
    /**
     * When the next scheduled downtime will start (DateTime_t)
     * 
     */
    @JsonProperty("DowntimeStart")
    private String downtimeStart;
    /**
     * When the next scheduled downtime will end (DateTime_t)
     * 
     */
    @JsonProperty("DowntimeEnd")
    private String downtimeEnd;
    /**
     * Human-readable of the next scheduled downtime
     * 
     */
    @JsonProperty("DowntimeInfo")
    private String downtimeInfo;
    /**
     * The ID of the Service associated with this Endpoint
     * 
     */
    @JsonProperty("ServiceID")
    private String serviceID;
    /**
     * The IDs of the Shares accessible from this Endpoint
     * 
     */
    @JsonProperty("ShareID")
    private List<String> shareID = new ArrayList<String>();
    /**
     * IDs of AccessPolicies associated with this Endpoint
     * 
     */
    @JsonProperty("AccessPolicyID")
    private List<String> accessPolicyID = new ArrayList<String>();
    /**
     * IDs of Activities being managed through this Endpoint
     * 
     */
    @JsonProperty("ActivityID")
    private List<String> activityID = new ArrayList<String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * Network location of the endpoint
     * 
     */
    @JsonProperty("URL")
    public String getURL() {
        return uRL;
    }

    /**
     * Network location of the endpoint
     * 
     */
    @JsonProperty("URL")
    public void setURL(String uRL) {
        this.uRL = uRL;
    }

    /**
     * Capability_t (open enumeration)
     * 
     */
    @JsonProperty("Capability")
    public List<String> getCapability() {
        return capability;
    }

    /**
     * Capability_t (open enumeration)
     * 
     */
    @JsonProperty("Capability")
    public void setCapability(List<String> capability) {
        this.capability = capability;
    }

    /**
     * EndpointTechnology_t
     * 
     */
    @JsonProperty("Technology")
    public String getTechnology() {
        return technology;
    }

    /**
     * EndpointTechnology_t
     * 
     */
    @JsonProperty("Technology")
    public void setTechnology(String technology) {
        this.technology = technology;
    }

    /**
     * InterfaceName_t
     * 
     */
    @JsonProperty("InterfaceName")
    public String getInterfaceName() {
        return interfaceName;
    }

    /**
     * InterfaceName_t
     * 
     */
    @JsonProperty("InterfaceName")
    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    /**
     * The version of the primary interface protocol (free format)
     * 
     */
    @JsonProperty("InterfaceVersion")
    public String getInterfaceVersion() {
        return interfaceVersion;
    }

    /**
     * The version of the primary interface protocol (free format)
     * 
     */
    @JsonProperty("InterfaceVersion")
    public void setInterfaceVersion(String interfaceVersion) {
        this.interfaceVersion = interfaceVersion;
    }

    /**
     * URIs identifying supported extensions to the interface protocol
     * 
     */
    @JsonProperty("InterfaceExtension")
    public List<String> getInterfaceExtension() {
        return interfaceExtension;
    }

    /**
     * URIs identifying supported extensions to the interface protocol
     * 
     */
    @JsonProperty("InterfaceExtension")
    public void setInterfaceExtension(List<String> interfaceExtension) {
        this.interfaceExtension = interfaceExtension;
    }

    /**
     * URLs of WSDL document(s) describing the interface
     * 
     */
    @JsonProperty("WSDL")
    public List<String> getWSDL() {
        return wSDL;
    }

    /**
     * URLs of WSDL document(s) describing the interface
     * 
     */
    @JsonProperty("WSDL")
    public void setWSDL(List<String> wSDL) {
        this.wSDL = wSDL;
    }

    /**
     * URI(s) identifying supported profiles for the Endpoint
     * 
     */
    @JsonProperty("SupportedProfile")
    public List<String> getSupportedProfile() {
        return supportedProfile;
    }

    /**
     * URI(s) identifying supported profiles for the Endpoint
     * 
     */
    @JsonProperty("SupportedProfile")
    public void setSupportedProfile(List<String> supportedProfile) {
        this.supportedProfile = supportedProfile;
    }

    /**
     * URL(s) of documents providing human-readable descriptions of the semantics of the Endpoint
     * 
     */
    @JsonProperty("Semantics")
    public List<String> getSemantics() {
        return semantics;
    }

    /**
     * URL(s) of documents providing human-readable descriptions of the semantics of the Endpoint
     * 
     */
    @JsonProperty("Semantics")
    public void setSemantics(List<String> semantics) {
        this.semantics = semantics;
    }

    /**
     * The name of the main organization implementing the Endpoint
     * 
     */
    @JsonProperty("Implementor")
    public String getImplementor() {
        return implementor;
    }

    /**
     * The name of the main organization implementing the Endpoint
     * 
     */
    @JsonProperty("Implementor")
    public void setImplementor(String implementor) {
        this.implementor = implementor;
    }

    /**
     * The name of the implementation of the Endpoint
     * 
     */
    @JsonProperty("ImplementationName")
    public String getImplementationName() {
        return implementationName;
    }

    /**
     * The name of the implementation of the Endpoint
     * 
     */
    @JsonProperty("ImplementationName")
    public void setImplementationName(String implementationName) {
        this.implementationName = implementationName;
    }

    /**
     * The version of the implementation of the Endpoint
     * 
     */
    @JsonProperty("ImplementationVersion")
    public String getImplementationVersion() {
        return implementationVersion;
    }

    /**
     * The version of the implementation of the Endpoint
     * 
     */
    @JsonProperty("ImplementationVersion")
    public void setImplementationVersion(String implementationVersion) {
        this.implementationVersion = implementationVersion;
    }

    /**
     * QualityLevel_t
     * 
     */
    @JsonProperty("QualityLevel")
    public Endpoint.QualityLevel getQualityLevel() {
        return qualityLevel;
    }

    /**
     * QualityLevel_t
     * 
     */
    @JsonProperty("QualityLevel")
    public void setQualityLevel(Endpoint.QualityLevel qualityLevel) {
        this.qualityLevel = qualityLevel;
    }

    /**
     * The operational status of the Endpoint
     * 
     */
    @JsonProperty("HealthState")
    public Endpoint.HealthState getHealthState() {
        return healthState;
    }

    /**
     * The operational status of the Endpoint
     * 
     */
    @JsonProperty("HealthState")
    public void setHealthState(Endpoint.HealthState healthState) {
        this.healthState = healthState;
    }

    /**
     * A human-readable explanation of the HealthState of this Endpoint
     * 
     */
    @JsonProperty("HealthStateInfo")
    public String getHealthStateInfo() {
        return healthStateInfo;
    }

    /**
     * A human-readable explanation of the HealthState of this Endpoint
     * 
     */
    @JsonProperty("HealthStateInfo")
    public void setHealthStateInfo(String healthStateInfo) {
        this.healthStateInfo = healthStateInfo;
    }

    /**
     * If the endpoint is accepting and serving requests
     * 
     */
    @JsonProperty("ServingState")
    public Endpoint.ServingState getServingState() {
        return servingState;
    }

    /**
     * If the endpoint is accepting and serving requests
     * 
     */
    @JsonProperty("ServingState")
    public void setServingState(Endpoint.ServingState servingState) {
        this.servingState = servingState;
    }

    /**
     * The start time of the Service associated with this Endpoint (DateTime_t)
     * 
     */
    @JsonProperty("StartTime")
    public String getStartTime() {
        return startTime;
    }

    /**
     * The start time of the Service associated with this Endpoint (DateTime_t)
     * 
     */
    @JsonProperty("StartTime")
    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    /**
     * The DN of the CA issuing the certificate presented by this Endpoint
     * 
     */
    @JsonProperty("IssuerCA")
    public String getIssuerCA() {
        return issuerCA;
    }

    /**
     * The DN of the CA issuing the certificate presented by this Endpoint
     * 
     */
    @JsonProperty("IssuerCA")
    public void setIssuerCA(String issuerCA) {
        this.issuerCA = issuerCA;
    }

    /**
     * DN(s) of CAs trusted by this Endpoint
     * 
     */
    @JsonProperty("TrustedCA")
    public List<String> getTrustedCA() {
        return trustedCA;
    }

    /**
     * DN(s) of CAs trusted by this Endpoint
     * 
     */
    @JsonProperty("TrustedCA")
    public void setTrustedCA(List<String> trustedCA) {
        this.trustedCA = trustedCA;
    }

    /**
     * When the next scheduled downtime was announced (DateTime_t)
     * 
     */
    @JsonProperty("DowntimeAnnounce")
    public String getDowntimeAnnounce() {
        return downtimeAnnounce;
    }

    /**
     * When the next scheduled downtime was announced (DateTime_t)
     * 
     */
    @JsonProperty("DowntimeAnnounce")
    public void setDowntimeAnnounce(String downtimeAnnounce) {
        this.downtimeAnnounce = downtimeAnnounce;
    }

    /**
     * When the next scheduled downtime will start (DateTime_t)
     * 
     */
    @JsonProperty("DowntimeStart")
    public String getDowntimeStart() {
        return downtimeStart;
    }

    /**
     * When the next scheduled downtime will start (DateTime_t)
     * 
     */
    @JsonProperty("DowntimeStart")
    public void setDowntimeStart(String downtimeStart) {
        this.downtimeStart = downtimeStart;
    }

    /**
     * When the next scheduled downtime will end (DateTime_t)
     * 
     */
    @JsonProperty("DowntimeEnd")
    public String getDowntimeEnd() {
        return downtimeEnd;
    }

    /**
     * When the next scheduled downtime will end (DateTime_t)
     * 
     */
    @JsonProperty("DowntimeEnd")
    public void setDowntimeEnd(String downtimeEnd) {
        this.downtimeEnd = downtimeEnd;
    }

    /**
     * Human-readable of the next scheduled downtime
     * 
     */
    @JsonProperty("DowntimeInfo")
    public String getDowntimeInfo() {
        return downtimeInfo;
    }

    /**
     * Human-readable of the next scheduled downtime
     * 
     */
    @JsonProperty("DowntimeInfo")
    public void setDowntimeInfo(String downtimeInfo) {
        this.downtimeInfo = downtimeInfo;
    }

    /**
     * The ID of the Service associated with this Endpoint
     * 
     */
    @JsonProperty("ServiceID")
    public String getServiceID() {
        return serviceID;
    }

    /**
     * The ID of the Service associated with this Endpoint
     * 
     */
    @JsonProperty("ServiceID")
    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }

    /**
     * The IDs of the Shares accessible from this Endpoint
     * 
     */
    @JsonProperty("ShareID")
    public List<String> getShareID() {
        return shareID;
    }

    /**
     * The IDs of the Shares accessible from this Endpoint
     * 
     */
    @JsonProperty("ShareID")
    public void setShareID(List<String> shareID) {
        this.shareID = shareID;
    }

    /**
     * IDs of AccessPolicies associated with this Endpoint
     * 
     */
    @JsonProperty("AccessPolicyID")
    public List<String> getAccessPolicyID() {
        return accessPolicyID;
    }

    /**
     * IDs of AccessPolicies associated with this Endpoint
     * 
     */
    @JsonProperty("AccessPolicyID")
    public void setAccessPolicyID(List<String> accessPolicyID) {
        this.accessPolicyID = accessPolicyID;
    }

    /**
     * IDs of Activities being managed through this Endpoint
     * 
     */
    @JsonProperty("ActivityID")
    public List<String> getActivityID() {
        return activityID;
    }

    /**
     * IDs of Activities being managed through this Endpoint
     * 
     */
    @JsonProperty("ActivityID")
    public void setActivityID(List<String> activityID) {
        this.activityID = activityID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum HealthState {

        CRITICAL("critical"),
        OK("ok"),
        OTHER("other"),
        UNKNOWN("unknown"),
        WARNING("warning");
        private final String value;
        private static Map<String, Endpoint.HealthState> constants = new HashMap<String, Endpoint.HealthState>();

        static {
            for (Endpoint.HealthState c: Endpoint.HealthState.values()) {
                constants.put(c.value, c);
            }
        }

        private HealthState(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Endpoint.HealthState fromValue(String value) {
            Endpoint.HealthState constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("org.jsonschema2pojo")
    public static enum QualityLevel {

        DEVELOPMENT("development"),
        PRE_PRODUCTION("pre-production"),
        PRODUCTION("production"),
        TESTING("testing");
        private final String value;
        private static Map<String, Endpoint.QualityLevel> constants = new HashMap<String, Endpoint.QualityLevel>();

        static {
            for (Endpoint.QualityLevel c: Endpoint.QualityLevel.values()) {
                constants.put(c.value, c);
            }
        }

        private QualityLevel(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Endpoint.QualityLevel fromValue(String value) {
            Endpoint.QualityLevel constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("org.jsonschema2pojo")
    public static enum ServingState {

        CLOSED("closed"),
        DRAINING("draining"),
        PRODUCTION("production"),
        QUEUEING("queueing");
        private final String value;
        private static Map<String, Endpoint.ServingState> constants = new HashMap<String, Endpoint.ServingState>();

        static {
            for (Endpoint.ServingState c: Endpoint.ServingState.values()) {
                constants.put(c.value, c);
            }
        }

        private ServingState(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Endpoint.ServingState fromValue(String value) {
            Endpoint.ServingState constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
